define([
    'backbone',
    '../collections/lead-reports',
    'i18n!../../../nls/dashboard_'+$('#lead-reports-system-language').val()+'_ln',
    'moment',
    'c3'
], function(Backbone, LeadReportsCollection, i18n, moment, c3
){

    var LeadReportsFilterView = Backbone.View.extend({
        el: $('#lead-reports-filter-block'),
        events: {
            'change .rangeOptions': 'changePeriod',
            'change .rangeOptions-forecast': 'changePeriod',
            'change input[name="compareTo"]': 'compareTo',
            'click #show-lead-reports': 'applyFilter'
        },
        templates: {
        },
        initialize: function(){
            this.LeadReportsCollection = new LeadReportsCollection();
        },
        render: function() {
            $.each($('.lead-reports-filter-datepicker'), function (key, datepicker) {
                var formDate = $(datepicker).closest('form').data('user-time');
                $(datepicker).datepicker();
                //$(datepicker).datepicker("option", "maxDate", new Date(formDate));
                $(datepicker).datepicker("option", "dateFormat", 'd-M-yy');
            });

            this.setDateRange($('.rangeOptions').val(), $('.rangeOptions').closest('form'));

            return this;
        },
        applyFilter: function(e)
        {
            this.$el.trigger('LeadReportsFilter:updated');
            this.$el.trigger('LeadGeneralReportsFilter:updated');
        },
        changePeriod: function(e)
        {
            var el = $(e.currentTarget),
                currentForm = el.closest('form');

            this.setDateRange(el.val(), currentForm);
        },
        compareTo: function(e){
            var el = $(e.currentTarget),
                form = el.closest('form'),
                currentTabName = $('.lead-report-tab.current').data('tab-name');

            if (el.is(':checked')) {
                $('[name="previousStartDate"]', form).prop("disabled", false);
                $('[name="previousEndDate"]', form).prop("disabled", false);
            }
            else {
                $('[name="previousStartDate"]', form).prop("disabled", true);
                $('[name="previousStartDate"]', form).datepicker('setDate', null);
                $('[name="previousEndDate"]', form).prop("disabled", true);
                $('[name="previousEndDate"]', form).datepicker('setDate', null);
            }

            if ($('.rangeOptions', form).val() !== 'custom') {
                if(currentTabName == 'forecast') {
                    this.setDateRange($('.rangeOptions-forecast', form).val(), form);
                } else {
                    this.setDateRange($('.rangeOptions', form).val(), form);
                }
            }

        },
        setDateRange: function(switchValue, currentForm) {
            var $startDate = $('[name="startDate"]', currentForm),
                $endDate = $('[name="endDate"]', currentForm),
                $previousStartDate = $('[name="previousStartDate"]', currentForm),
                $previousEndDate = $('[name="previousEndDate"]', currentForm),
                date = moment(currentForm.data('userTime')),
                compareChecked = currentForm.find('#lead-reports-compare'),
                disabled = false,
                currentTabName = $('.lead-report-tab.current').data('tab-name');

            switch (switchValue) {
                case "1"://Today
                    $startDate.datepicker('setDate', date.startOf('day').toDate());
                    $endDate.datepicker('setDate', date.endOf('day').toDate());
                    if (compareChecked.prop('checked')) {
                        $previousStartDate.datepicker('setDate', date.subtract(1, 'days').startOf('day').toDate());
                        $previousEndDate.datepicker('setDate', date.endOf('day').toDate());
                    }
                    disabled = true;
                    this.leadReportsFilter(currentTabName, switchValue);
                    break;
                case "2"://Yesterday
                    $startDate.datepicker('setDate', date.subtract(1, 'days').startOf('day').toDate());
                    $endDate.datepicker('setDate', date.endOf('day').toDate());
                    if (compareChecked.prop('checked')) {
                        $previousStartDate.datepicker('setDate', date.subtract(1, 'days').startOf('day').toDate());
                        $previousEndDate.datepicker('setDate', date.endOf('day').toDate());
                    }
                    disabled = true;
                    this.leadReportsFilter(currentTabName, switchValue);
                    break;
                case "3"://Last week
                    $startDate.datepicker('setDate', date.subtract(7, 'days').startOf('week').toDate());
                    $endDate.datepicker('setDate', date.endOf('week').toDate());
                    if (compareChecked.prop('checked')) {
                        $previousStartDate.datepicker('setDate', date.subtract(8, 'days').startOf('week').toDate());
                        $previousEndDate.datepicker('setDate', date.endOf('week').toDate());
                    }
                    disabled = true;
                    this.leadReportsFilter(currentTabName, switchValue);
                    break;
                case "4"://Last month
                    $startDate.datepicker('setDate', date.endOf('month').subtract(date.daysInMonth() + 1, 'days').startOf('month').toDate());
                    $endDate.datepicker('setDate', date.endOf('month').toDate());
                    if (compareChecked.prop('checked')) {
                        $previousStartDate.datepicker('setDate', date.subtract(date.daysInMonth() + 1, 'days').startOf('month').toDate());
                        $previousEndDate.datepicker('setDate', date.endOf('month').toDate());
                    }
                    disabled = true;
                    this.leadReportsFilter(currentTabName, switchValue);
                    break;
                case "5"://Last 7 days
                    $endDate.datepicker('setDate', date.subtract(0, 'days').endOf('day').toDate());
                    $startDate.datepicker('setDate', date.subtract(7, 'days').startOf('day').toDate());
                    if (compareChecked.prop('checked')) {
                        $previousEndDate.datepicker('setDate', date.subtract(1, 'days').endOf('day').toDate());
                        $previousStartDate.datepicker('setDate', date.subtract(6, 'days').startOf('day').toDate());
                    }
                    disabled = true;
                    this.leadReportsFilter(currentTabName, switchValue);
                    break;
                case "6"://Last 30 days
                    $endDate.datepicker('setDate', date.subtract(0, 'days').endOf('day').toDate());
                    $startDate.datepicker('setDate', date.subtract(30, 'days').startOf('day').toDate());
                    if (compareChecked.prop('checked')) {
                        $previousEndDate.datepicker('setDate', date.subtract(1, 'days').endOf('day').toDate());
                        $previousStartDate.datepicker('setDate', date.subtract(29, 'days').startOf('day').toDate());
                    }
                    disabled = true;
                    this.leadReportsFilter(currentTabName, switchValue);
                    break;
                case "7"://Tomorrow
                    $startDate.datepicker('setDate', date.add(1, 'days').startOf('day').toDate());
                    $endDate.datepicker('setDate', date.endOf('day').toDate());
                    if (compareChecked.prop('checked')) {
                        $previousStartDate.datepicker('setDate', date.subtract(1, 'days').startOf('day').toDate());
                        $previousEndDate.datepicker('setDate', date.endOf('day').toDate());
                    }
                    disabled = true;
                    this.leadReportsFilter(currentTabName, switchValue);
                    break;
                case "8"://Next week
                    $startDate.datepicker('setDate', date.add(7, 'days').startOf('week').toDate());
                    $endDate.datepicker('setDate', date.endOf('week').toDate());
                    if (compareChecked.prop('checked')) {
                        $previousStartDate.datepicker('setDate', date.subtract(7, 'days').startOf('week').toDate());
                        $previousEndDate.datepicker('setDate', date.endOf('week').toDate());
                    }
                    disabled = true;
                    this.leadReportsFilter(currentTabName, switchValue);
                    break;
                case "9"://Next month
                    $startDate.datepicker('setDate', date.startOf('month').add(date.daysInMonth() + 1, 'days').startOf('month').toDate());
                    $endDate.datepicker('setDate', date.endOf('month').toDate());
                    if (compareChecked.prop('checked')) {
                        $previousStartDate.datepicker('setDate', date.subtract(1, 'month').startOf('month').toDate());
                        $previousEndDate.datepicker('setDate', date.endOf('month').toDate());
                    }
                    disabled = true;
                    this.leadReportsFilter(currentTabName, switchValue);
                    break;
                case "10"://Next 7 days
                    $startDate.datepicker('setDate', date.add(0, 'days').startOf('day').toDate());
                    $endDate.datepicker('setDate', date.add(7, 'days').endOf('day').toDate());
                    if (compareChecked.prop('checked')) {
                        $previousStartDate.datepicker('setDate', date.subtract(14, 'days').endOf('day').toDate());
                        $previousEndDate.datepicker('setDate', date.add(6, 'days').startOf('day').toDate());
                    }
                    disabled = true;
                    this.leadReportsFilter(currentTabName, switchValue);
                    break;
                case "11"://Next 30 days
                    $startDate.datepicker('setDate', date.add(0, 'days').startOf('day').toDate());
                    $endDate.datepicker('setDate', date.add(30, 'days').endOf('day').toDate());
                    if (compareChecked.prop('checked')) {
                        $previousStartDate.datepicker('setDate', date.subtract(60, 'days').startOf('day').toDate());
                        $previousEndDate.datepicker('setDate', date.add(29, 'days').endOf('day').toDate());
                    }
                    disabled = true;
                    this.leadReportsFilter(currentTabName, switchValue);
                    break;
                case "12"://Next quarter
                    $startDate.datepicker('setDate', date.quarter(date.quarter() + 1).startOf('quarter').toDate());
                    $endDate.datepicker('setDate', date.quarter(date.quarter()).endOf('quarter').toDate());
                    if (compareChecked.prop('checked')) {
                        $previousStartDate.datepicker('setDate', date.subtract(1, 'quarter').startOf('quarter').toDate());
                        $previousEndDate.datepicker('setDate', date.endOf('quarter').toDate());
                    }
                    disabled = true;
                    this.leadReportsFilter(currentTabName, switchValue);
                    break;

                case "custom":
                    break;
                default:
                    $startDate.datepicker('setDate', null);
                    $endDate.datepicker('setDate', null);
                    if (compareChecked.prop('checked')) {
                        $previousStartDate.datepicker('setDate', null);
                        $previousEndDate.datepicker('setDate', null);
                    }
                    this.leadReportsFilter(currentTabName, switchValue);
                    break;
            }
            if (!$startDate.datepicker('getDate') && !$endDate.datepicker('getDate')) {
                if (compareChecked.prop('checked') && !$previousStartDate.datepicker('getDate') && $previousEndDate.datepicker('getDate')) {
                    return date = null;
                }
                else if ($previousStartDate.datepicker('getDate') || $previousEndDate.datepicker('getDate')) {
                    return date = false;
                }
                return date = null;
            }

            date = {
                'startDate': moment($startDate.datepicker('getDate')).startOf('day').format('YYYY-MM-DD'),
                'endDate': moment($endDate.datepicker('getDate')).endOf('day').format('YYYY-MM-DD')
            };

            if (compareChecked.prop('checked')) {
                date['pstartDate'] = moment($previousStartDate.datepicker('getDate')).startOf('day').format('YYYY-MM-DD');
                date ['pendDate'] = moment($previousEndDate.datepicker('getDate')).endOf('day').format('YYYY-MM-DD');
                date['fstartDate'] = moment(date.endDate).add(1, "days").startOf('day').format('YYYY-MM-DD');
                var dateDiff = Math.round(moment(date.pendDate).endOf('day').diff(moment(date.pstartDate).startOf('day'), 'days', true));
                date['fendDate'] = moment(date.fstartDate).add(dateDiff, "days").endOf('day').format('YYYY-MM-DD');
            }

            if (disabled === true) {
                $('#lead-reports-filter-end-date').prop('disabled', true);
                $('#lead-reports-filter-start-date').prop('disabled', true);
                $('#lead-reports-filter-compare-start-date').prop('disabled', true);
                $('#lead-reports-filter-compare-end-date').prop('disabled', true);
            } else {
                $('#lead-reports-filter-end-date').prop('disabled', false);
                $('#lead-reports-filter-start-date').prop('disabled', false);
                var disabledCompareDate = true;

                if (compareChecked.prop('checked')) {
                    disabledCompareDate = false;
                }

                $('#lead-reports-filter-compare-start-date').prop('disabled', disabledCompareDate);
                $('#lead-reports-filter-compare-end-date').prop('disabled', disabledCompareDate);
            }

            return date;
        },
        leadReportsFilter: function(currentTabName, switchValue) {
            if(currentTabName == 'forecast') {
                var existOptionValue = $('.rangeOptions option[value="' + switchValue + '"]').val();
                if(typeof existOptionValue !== 'undefined') {
                    $('.rangeOptions').val(switchValue);
                }
            } else {
                $('.rangeOptions-forecast').val(switchValue);
            }
        },
        validateDateRange: function(dates, checked) {
            if (dates === null) {
                return true;
            }
            var startDate = new Date(dates.startDate),
                endDate = new Date(dates.endDate);

            if (checked) {
                var pstartDate = new Date(dates.pstartDate),
                    pendDate = new Date(dates.pendDate);
                if (startDate.getUnixTimestamp() <= endDate.getUnixTimestamp() && pstartDate.getUnixTimestamp() <=
                    pendDate.getUnixTimestamp() && pendDate.getUnixTimestamp() < startDate.getUnixTimestamp()) {
                    return true;
                }
                return false;

            } else if (startDate.getUnixTimestamp() <= endDate.getUnixTimestamp()) {
                return true;
            }

            return false;
        },
        assign: function (selector, view) {
            var selectors;
            if (_.isObject(selector)) {
                selectors = selector;
            }
            else {
                selectors = {};
                selectors[selector] = view;
            }
            if (!selectors) return;
            _.each(selectors, function (view, selector) {
                view.setElement(this.$(selector)).render();
            }, this);
        }
    });

    Date.prototype.getUnixTimestamp = function () {
        return this.getTime() / 1000;
    };

    return LeadReportsFilterView;
});
