define([
    'backbone',
    '../models/event-rule-config',
    'backbone.paginator'
], function(Backbone, EventRuleConfigModel){

    var EventsRuleConfigCollection = Backbone.Paginator.requestPager.extend({
        model: EventRuleConfigModel,
        paginator_core: {
            type: 'GET',
            dataType: 'json',
            url: function(){
                return $('#website_url').val() + 'api/leads/eventrulesconfig/';
            }
        },
        paginator_ui: {
            firstPage:    0,
            currentPage:  0,
            perPage:     1000,
            totalPages:  1000
        },
        server_api: {
            count: true,
            limit: function() { return this.perPage; },
            offset: function() { return this.currentPage * this.perPage },
            key: function(){ return this.key; },
            isGrid: function(){ return this.isGrid; },
            events: function(){ return this.events; }
        },
        parse: function(response, xhr){
            if (this.server_api.count){
                this.totalRecords = response.totalRecords;
            } else {
                this.totalRecords = response.length;
            }
            this.cronScriptPathAudiences = response.cronScriptPathAudiences;
            this.limitedAccess = response.limitedAccess;
            this.events = response;
            this.totalPages = Math.floor(this.totalRecords / this.perPage);
            return this.server_api.count ? response.data : response;
        }

    });

    return EventsRuleConfigCollection;
});
