define([
    'backbone',
    '../models/lead-stage.js',
    'i18n!../../../nls/config_'+$('#lead-stage-leads-config-system-language').val()+'_ln.js'
], function(Backbone, LeadStageModel, i18n){
    var LeadStageFormView = Backbone.View.extend({
        el: $('#lead-stage-form'),
        events: {
            'submit': 'submit',
            'change #default-lead-stage': 'changeDefaultLeadStage'
        },
        templates: {

        },
        initialize: function(){
            this.$el = $('#lead-stage-form');
            this.$el.attr('action', $('#website_url').val()+'api/leads/leadstage');
        },
        render: function(){
            return this;
        },
        changeDefaultLeadStage: function(e){
            var stageId = $(e.currentTarget).val(),
                self = this;

            this.leadStageModel = new LeadStageModel();

            this.leadStageModel.fetch({data: {id: stageId},
                'success': function(leadSocialServiceModel){
                    leadSocialServiceModel.set('default', '1');
                    leadSocialServiceModel.set('secureToken', $('#lead-stage-secure-token').val());
                    leadSocialServiceModel.save({id: stageId}, {
                        success: function(model, response){
                            showMessage(response.responseText, false, 5000);
                            self.$el.trigger('LeadStageForm:created');
                        },
                        error: function(model, response){
                            showMessage(response.responseJSON, true, 5000);
                        }
                    });
                }
            });
        },
        submit: function(e){
            e.preventDefault();

            var self = this,
                form = $(e.currentTarget),
                isValid = true,
                method = 'POST',
                leadStageId = form.find('#lead-stage-id').val(),
                leadStageName = $('#lead-stage-name').val();

            _.each(form.find('.required'), function(el){
                if (!$(el).val()){
                    isValid = false;
                }
            });

            if (!isValid){
                showMessage(_.isUndefined(i18n['Missing required field'])?'Missing required field':i18n['Missing required field'], true);
                return false;
            }

            var formParams = form.serialize();

            if (leadStageId) {
                method = 'PUT';
                formParams = JSON.stringify({'stage_name': $('#lead-stage-name').val(),
                    'secureToken':form.find('input[name=secureToken]').val(),
                    'id':leadStageId
                })
            }

            $.ajax({
                url: form.attr('action'),
                type: method,
                data: formParams,
                dataType: 'json'
            }).done(function(response) {
                 self.$el.trigger('LeadStageForm:created');
                 showMessage(response.responseText.message, false, 5000);
                 form.find('input[type="text"]').val('');

                 var leadStageId = response.responseText.stageId;
                 var htmlOption = '<option value="'+ leadStageId +'">'+ leadStageName +'</option>';

                 $('#default-lead-stage').append(htmlOption);
                 $('#lead-stage-id').val('');
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
            return false;

        }
    });

    return LeadStageFormView;
});