define([
    'backbone',
    'plupload',
    'pluploadhtml5',
    'pluploadflash',
    'pluploadhtml4',
    '../models/lead-social-service.js',
    'i18n!../../../nls/config_'+$('#lead-social-services-leads-config-system-language').val()+'_ln.js'
], function(Backbone, plupload, pluploadhtml5, pluploadflash, pluploadhtml4, leadSocialServiceModel, i18n){
    var LeadSocialServiceFormView = Backbone.View.extend({
        el: $('#lead-social-services-form'),
        events: {
            'submit': 'submit',
            'click .upload-social-service-logo': 'triggerUpload',
            'keyup .service-name': 'updateServiceLabel'
        },
        templates: {

        },
        initialize: function(){
            this.$el = $('#lead-social-services-form');
            this.$el.attr('action', $('#website_url').val()+'api/leads/leadsocialservices');
            this.uploaderSocialServicesFolder = 'lead-social-services';

            var options = {
                runtimes: 'html5',
                browse_button: 'social-service-logo-uploader-pickfiles',
                container: 'social-service-logo-uploader',
                max_file_size: '100mb',
                url: $('#website_url').val()+'plugin/leads/run/uploadSocialServiceImage/',
                filters: [
                    {title : "Image files", extensions : "jpg,gif,png"}
                ],
                multipart_params: {
                    secureToken: '',
                    folder:''
                }
            };

            this.formSocialServiceUploader = new plupload.Uploader(options);

            this.formSocialServiceUploader.init();

            this.formSocialServiceUploader.bind('BeforeUpload', _.bind(this.beforeUpload, this));
            this.formSocialServiceUploader.bind('FilesAdded', _.bind(this.filesAdded, this));
            this.formSocialServiceUploader.bind('UploadProgress', _.bind(this.uploadProgress, this));
            this.formSocialServiceUploader.bind('FileUploaded', _.bind(this.fileUploaded, this));
            this.formSocialServiceUploader.bind('Error', _.bind(this.handleUploadErrors, this));


        },
        render: function(){
            return this;
        },
        filesAdded: function(up, files)
        {
            this.formSocialServiceUploader.settings.multipart_params.secureToken = $('#social-services-secure-token').val();
            this.formSocialServiceUploader.settings.multipart_params.folder = this.uploaderSocialServicesFolder;
            this.formSocialServiceUploader.start();
        },
        uploadProgress: function(up, file)
        {
            $('#progressbar').progressbar({value: file.percent}).text(file.percent);
        },
        fileUploaded: function(up, file)
        {
            var websiteUrl = $('#website_url').val(),
                timestamp = new Date().getTime(),
                imageName = file.name.toLowerCase(),
                src = websiteUrl+'plugins/leads/web/images/'+this.uploaderSocialServicesFolder+'/'+imageName+'?'+timestamp,
                socialServiceDataId = $('#update-social-service-data').val(),
                self = this;

            if (socialServiceDataId) {
                this.leadSocialServiceModel = new leadSocialServiceModel();
                this.leadSocialServiceModel.fetch({data: {id: socialServiceDataId},
                    'success': function(leadSocialServiceModel){
                        $('#update-social-service-data').val('');
                        leadSocialServiceModel.set('image_name', imageName);
                        leadSocialServiceModel.set('secureToken', $('#social-services-secure-token').val());
                        leadSocialServiceModel.save({id: socialServiceDataId}, {
                            success: function(model, response){
                                showMessage(response.responseText, false, 5000);
                                self.$el.trigger('LeadSocialServiceForm:created');
                            },
                            error: function(model, response){
                                showMessage(response.responseJSON, true, 5000);
                            }
                        });
                    }
                });

            } else {
                $('#upload-social-service-logo').find('img').attr('src', src).data('img-name', imageName);
                this.$el.find('.service-image-name').val(imageName);
            }
            $('#progressbar').delay(800).fadeOut();
        },
        handleUploadErrors: function()
        {

        },
        beforeUpload: function(up, file){
            $('#progressbar').fadeIn().progressbar({value: 0});
        },
        updateServiceLabel: function(e) {
            var currentName = $(e.currentTarget).val();
            $(e.currentTarget).closest('form').find('.service-label').val(currentName);
        },
        triggerUpload: function() {
            $('#social-service-logo-uploader-pickfiles').trigger('click');
        },
        submit: function(e){
            e.preventDefault();

            var self = this,
                form = $(e.currentTarget),
                isValid = true;

            _.each(form.find('.required'), function(el){
                if (!$(el).val()){
                    isValid = false;
                }
            });

            if (!isValid){
                showMessage(_.isUndefined(i18n['Missing required field'])?'Missing required field':i18n['Missing required field'], true);
                return false;
            }

            var formParams = form.serialize();

            $.ajax({
                url: form.attr('action'),
                type:  'POST',
                data: formParams,
                dataType: 'json'
            }).done(function(response) {
                 self.$el.trigger('LeadSocialServiceForm:created');
                 showMessage(response.responseText, false, 5000);
                 form.find('input[type="text"]').val('');
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
            return false;

        }
    });

    return LeadSocialServiceFormView;
});
