define([
    'backbone',
    'text!../templates/table-folder-and-templates-row.html',
    'i18n!../../../nls/config_'+$('#lead-general-leads-config-system-language').val()+'_ln.js'
], function(Backbone, tableFolderAndTemplatesRow, i18n){
    var LeadCrmGeneralConfigMainView = Backbone.View.extend({
        el: $('#lead-general-config-block'),
        events:{
            'blur input.lead-general-config-attribute':'changeAttribute',
            'change select.lead-general-config-attribute':'changeAttribute',
            'change input.lead-general-config-attribute-checkbox':'changeAttributeCheckbox',
            'change #redirect-for-admin-enabled':'changeRedirectStatusCheckbox',
            'change select.select-item' : 'setAttributeSelect',
            'click a.add-selection' : 'addSelection',
            'click a.remove-item' : 'removeItem',
            'click span.refresh-items' : 'refreshItems'
        },
        templates: {},
        initialize: function(){
            this.$el = $('#lead-general-config-block');
        },
        changeAttribute: function(e)
        {
            e.preventDefault();
            var el = $(e.currentTarget),
                previousAttrVal = el.data('old-attribute-value'),
                currentVal = el.val(),
                paramName = el.data('attribute-name');

            if (el.hasClass('digit-only')) {
                if(/[^\d]/.test(currentVal)) {
                    showMessage(_.isUndefined(i18n['Only digit allowed'])?'Only digit allowed':i18n['Only digit allowed'], true, 5000);
                    return false;
                }
            }

            if (el.hasClass('email-only') && el.val() != '') {
                var emailValidation = /^(([^<>()\[\]\.,;:\s@\"]+(\.[^<>()\[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i;
                if(!emailValidation.test(currentVal)) {
                    showMessage(_.isUndefined(i18n['Please use valid email format'])?'Please use valid email format':i18n['Please use valid email format'], true, 5000);
                    return false;
                }
            }

            if (previousAttrVal != currentVal) {
                $.ajax({
                    'url': $('#website_url').val()+'api/leads/leadgeneralconfig/',
                    'type': 'POST',
                    'dataType':'json',
                    'data': {paramName: paramName, paramValue:currentVal, secureToken: $('#lead-general-config-secure-token').val()}
                }).done(function(response){
                    if (response.error == '0') {
                        showMessage(response.responseText, false, 5000);
                        el.data('old-attribute-value', currentVal);
                    } else {
                        showMessage(response.responseText, true, 5000);
                    }
                }).fail(function(response){
                    console.log(response);
                });
            }

        },
        changeRedirectStatusCheckbox:function(e)
        {
            e.preventDefault();
            var el = $(e.currentTarget),
                linkTextEl =  $('#redirect-after-login-link');

            if (!el.is(':checked')) {
                this.changeAttributeCheckbox(e, '');
                linkTextEl.val('');
                linkTextEl.addClass('hidden');
            } else {
                if (linkTextEl.val() === '') {
                    linkTextEl.val('dashboard');
                }

                this.changeAttributeCheckbox(e, linkTextEl.val());
                linkTextEl.removeClass('hidden');
            }

        },
        changeAttributeCheckbox: function(e, customValue)
        {
            e.preventDefault();
            var el = $(e.currentTarget),
                paramName = el.data('attribute-name'),
                currentVal = 0;

                if (el.is(':checked')) {
                    currentVal = 1;
                }

                if (customValue) {
                    currentVal = customValue;
                }

                $.ajax({
                    'url': $('#website_url').val()+'api/leads/leadgeneralconfig/',
                    'type': 'POST',
                    'dataType':'json',
                    'data': {paramName: paramName, paramValue:currentVal, secureToken: $('#lead-general-config-secure-token').val()}
                }).done(function(response){
                    if (response.error == '0') {
                        showMessage(response.responseText, false, 5000);
                        el.data('old-attribute-value', currentVal);
                    } else {
                        showMessage(response.responseText, true, 5000);
                    }
                }).fail(function(response){
                    console.log(response);
                });
        },
        setAttributeSelect: function (e)
        {
            e.preventDefault();
            var el = $(e.currentTarget),
                selectedItem = el.val(),
                linkEl = el.closest('div').find('.add-selection');

            linkEl.data('item-name', selectedItem);
        },
        addSelection: function(e)
        {
            e.preventDefault();
            var el = $(e.currentTarget),
                type = el.data('type'),
                itemName = el.data('item-name');

            this.sendSelectionAjax(itemName, type);
        },
        sendSelectionAjax: function (itemName, type)
        {
            $.ajax({
                'url': $('#website_url').val()+'plugin/leads/run/crmLeadsTemplatesAndDirectories/',
                'type': 'POST',
                'dataType':'json',
                'data': {itemName: itemName, type: type, secureToken: $('#lead-general-config-secure-token').val()}
            }).done(function(response){
                if (response.error == '0') {
                    var table = '',
                        dropdownEl = '',
                        itemDataUrl = '',
                        itemName = response.responseText.templatesAndDirectoriesItemName,
                        itemId = response.responseText.templatesAndDirectoriesItemId;

                    if(response.responseText.templatesAndDirectoriesType == 'folder'){
                        table = $('.folders-table');
                        dropdownEl = $('#media-folders');
                        itemDataUrl = $('#website_url').val() + 'backend/backend_media/uploadthings/folder/' + itemName;
                    }else {
                        table = $('.templates-table');
                        dropdownEl = $('#email-templates');
                        if(!_.isEmpty(response.responseText.pageUrl)){
                            itemDataUrl = $('#website_url').val() + response.responseText.pageUrl;
                        }
                    }

                    var htmlTr = _.template(tableFolderAndTemplatesRow, {'itemDataUrl': itemDataUrl, 'itemId': itemId, 'itemName': itemName, 'type': response.responseText.templatesAndDirectoriesType, 'i18n': i18n});
                    table.prepend(htmlTr);

                    var dropdownOptions = dropdownEl.find('option');

                    _.each(dropdownOptions, function (option, id) {
                        if(option.value == itemName){
                            $(dropdownEl).find('option[value="'+ option.value +'"]').remove();
                            dropdownEl.val(0).prop('selected', true);
                        }
                    });
                    showMessage(_.isUndefined(i18n['Added'])?'Added':i18n['Added'], false);
                } else {
                    showMessage(_.isUndefined(i18n['Can\'t add directory'])?'Can\'t add directory':i18n['Can\'t add directory'], true, 5000);
                }
            }).fail(function(response){
                console.log(response);
            });
        },
        removeItem : function (e)
        {
            e.preventDefault();
            var element = $(e.currentTarget),
                itemId = element.data('item-id'),
                itemType = element.data('item-type'),
                deleteMsg = _.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'];

            if(itemType == 'template') {
                deleteMsg = _.isUndefined(i18n['Remove this template from sight in the email editor?'])?'Remove this template from sight in the email editor?':i18n['Remove this template from sight in the email editor?'];
            }

            showConfirm(deleteMsg, function(){
                $.ajax({
                    'url': $('#website_url').val()+'plugin/leads/run/crmLeadsTemplatesAndDirectoriesRemoveItem/',
                    'type': 'POST',
                    'dataType':'json',
                    'data': {itemId: itemId, itemType: itemType, secureToken: $('#lead-general-config-secure-token').val()}
                }).done(function(response){
                    if (response.error == '0') {
                        var dropdownEl = $('#email-templates'),
                            itemName = response.responseText.itemName;
                        if(response.responseText.itemType == 'folder'){
                            dropdownEl = $('#media-folders');
                        }

                        var htmlOption = '<option value="'+ itemName +'">'+ itemName +'</option>';
                        dropdownEl.append(htmlOption);

                        element.closest('tr').remove();
                        var crearHrefAttributesEl = $('a.add-selection');

                        _.each(crearHrefAttributesEl, function (option, id) {
                            $(option).data('item-name', '');
                        });
                    } else {
                        showMessage(_.isUndefined(i18n['can\'t remove this item'])?'can\'t remove this item':i18n['can\'t remove this item'], true, 5000);
                    }
                }).fail(function(response){
                    console.log(response);
                });
            });
        },
        refreshItems: function (e) {
            e.preventDefault();
            var element = $(e.currentTarget),
                type = element.data('type'),
                dropdownEl = '',
                htmlOption = '',
                defaultSelect = '';

            showSpinner();

            $.ajax({
                'url': $('#website_url').val()+'plugin/leads/run/crmConfigLeadGeneralRefreshDirectories/',
                'type': 'POST',
                'dataType':'json',
                'data': {type: type, secureToken: $('#lead-general-config-secure-token').val()}
            }).done(function(response){
                hideSpinner();
                if (response.error == '0') {
                    if(response.responseText.type == 'folder'){
                        dropdownEl = $('#media-folders');
                        dropdownEl.empty();

                        defaultSelect = _.isUndefined(i18n['Select folder']) ? 'Select folder' : i18n['Select folder'];

                        htmlOption = '<option value="0">'+ defaultSelect +'</option>';

                        _.each(response.responseText.listFolders, function (folder, id) {
                            htmlOption += '<option value="'+ id +'">'+ folder +'</option>';
                        });
                        dropdownEl.append(htmlOption);

                        if(!_.isEmpty(response.responseText.removedItems)){
                            _.each(response.responseText.removedItems, function (item, id) {
                                $('.folder-'+item).remove();
                            });
                        }
                    }
                } else {
                    showMessage(_.isUndefined(i18n['can\'t refresh this items'])?'can\'t refresh this items':i18n['can\'t refresh this items'], true, 5000);
                }
            }).fail(function(response){
                console.log(response);
            });
        }


    });

    return LeadCrmGeneralConfigMainView;
});
