define([
    'backbone',
    '../collections/industry-type.js',
    'text!../templates/paginator.html',
    'text!../templates/industry-row.html',
    'i18n!../../../nls/config_'+$('#lead-industry-types-config-system-language').val()+'_ln.js'
], function(Backbone,
            IndustryTypeCollection, PaginatorTmpl, IndustryRowTmpl, i18n
){

    var IndustryTypeGridView = Backbone.View.extend({
        el: $('#industry-type-grid-table'),
        events: {
            'click a[data-role=delete]': 'deleteIndustryType',
            'blur .lead-industry-edit-attribute'  : 'editIndustryType',
            'click td.industry-type-grid-paginator a.page': 'navigate'
        },
        templates: {
            paginator: _.template(PaginatorTmpl)
        },
        initialize: function(options){
            this.IndustryTypes = new IndustryTypeCollection();
            this.$el =  $('#industry-type-grid-table');
            this.IndustryTypes.on('reset', this.renderIndustryTypes, this);
            this.IndustryTypes.on('add', this.renderIndustryTypes, this);
            this.IndustryTypes.on('destroy', this.renderIndustryTypes, this);
        },
        render: function(){
            this.IndustryTypes.pager();
        },
        renderIndustryTypes: function(){
            this.$el.find('tbody').empty();
            this.IndustryTypes.each(this.renderIndustryType, this);
            this.IndustryTypes.info()['i18n'] = i18n;
            if((this.IndustryTypes.length == 0) && (this.IndustryTypes.currentPage != 0)){
                this.IndustryTypes.requestPreviousPage();
            }
            this.$('td.industry-type-grid-paginator').html(this.templates.paginator(this.IndustryTypes.information));
        },
        renderIndustryType: function(industryTypeData){
            this.$el.find('tbody').append(_.template(IndustryRowTmpl, {'leadsIndustryData':industryTypeData}));
            return false;
        },
        editIndustryType: function(e){
            var el = $(e.currentTarget),
                currentValue = el.val(),
                oldValue = el.data('old-value'),
                leadIndustryId = el.closest('tr').data('lead-industry-id'),
                leadIndustryModel = this.IndustryTypes.get(leadIndustryId),
                attrName =  el.data('attrName');

            if (currentValue != oldValue) {
                el.data('old-value', currentValue);
                leadIndustryModel.set(attrName, currentValue);
                leadIndustryModel.set('secureToken', $('#lead-industry-secure-token').val());
                leadIndustryModel.save(null, {
                    success: function(model, response){
                        showMessage(response.responseText, false, 5000);
                    },
                    error: function(model, response){
                        showMessage(response.responseJSON, true, 5000);
                    }
                });

            }
        },
        deleteIndustryType: function(e){
            var self = this,
                cid = $(e.currentTarget).data('cid'),
                model = this.IndustryTypes.get(cid);

            showConfirm(_.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'], function(){
                if (model){
                    model.destroy();
                    self.render();
                }
            });
        },
        navigate: function(e){
            e.preventDefault();

            var page = $(e.currentTarget).data('page');
            if ($.isNumeric(page)){
                this.IndustryTypes.goTo(page);
            } else {
                switch(page){
                    case 'first':
                        this.IndustryTypes.goTo(this.IndustryTypes.firstPage);
                        break;
                    case 'last':
                        this.IndustryTypes.goTo(this.IndustryTypes.information.lastPage);
                        break;
                    case 'prev':
                        this.IndustryTypes.requestPreviousPage();
                        break;
                    case 'next':
                        this.IndustryTypes.requestNextPage();
                        break;
                }
            }
        }
    });

    return IndustryTypeGridView;
});