import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
export default {
    data () {
        return {
            loadedScreen: false,
            oppStage: '-1',
            websiteUrl: $('#website_url').val(),
            oppQuotesDetailedId:'',
            subType: 'open'
        }
    },
    components: {
        pagination: pagination
    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
            configDataInfo:'getConfigDataInfo',
            additionalInfo:'getAdditionalInfo',
            opportunitiesAdditionalInfo:'getOpportunitiesAdditionalInfo',
            sortByColumn: 'sortByColumn',
            truncateText: 'truncateText',
            selectedUserId: 'getSelectedUserId',
            opportunitiesClosingSoonData: 'getOpportunitiesClosingSoonData'
        })
    },
    watch: {
        selectedUserId (newUserId, oldUseId) {
            console.log(`Old user id ${oldUseId} - new user id ${newUserId}`);
            if (newUserId !== oldUseId) {
                this.$store.commit('setPaginationData',
                    {
                        opportunitiesClosingSoon: {
                            currentPage: 1,
                            itemsPerPage: 10,
                            totalItems: 0,
                            visiblePages: 4
                        }
                    }
                );

                this.applyFilter();
            }
        }
    },
    methods: {
        changeOppStage() {
            this.$store.commit('setPaginationData',
                {
                    opportunitiesClosingSoon: {
                        currentPage: 1,
                        itemsPerPage: 10,
                        totalItems: 0,
                        visiblePages: 4
                    }
                }
            );

            this.applyFilter();
        },
        async applyFilter() {
            const result = await this.$store.dispatch('getOpportunitiesClosingSoonData', {'router':this.$router, 'oppStage': this.oppStage, 'userId':this.selectedUserId, 'subType':this.subType});
            if(result.status === 'error') {
                showMessage('Please re-login', true, 3000);
            } else {
                this.loadedScreen = true;
            }
        },
        showQuoteItems(oppId)
        {
            if (this.oppQuotesDetailedId === oppId) {
                this.oppQuotesDetailedId = '';
            } else {
                this.oppQuotesDetailedId = oppId;
            }
        },
        applySubFilter(subType)
        {
            if (subType !== this.subType) {
                this.$store.commit('setPaginationData',
                    {
                        opportunitiesClosingSoon: {
                            currentPage: 1,
                            itemsPerPage: 10,
                            totalItems: 0,
                            visiblePages: 4
                        }
                    }
                );
            }

            this.subType = subType;
            this.applyFilter();
        }
    },
    async created(){
        const result = await this.$store.dispatch('getOpportunitiesClosingSoonData', {'router':this.$router, 'oppStage': this.oppStage, 'userId':this.selectedUserId});
        if(result.status === 'error') {
            showMessage('Please re-login', true, 3000);
        } else {
            this.loadedScreen = true;
        }

    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
