import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
import moment from 'moment';
export default {
    data () {
        return {
            loadedScreen: false,
            websiteUrl: $('#website_url').val(),
            localeMapping: localeMapping,
            locale: $('#membership-system-language').val(),
            applyFullFilter:0,
            notProcessOrders:0,
            totalTasksQuantity:0,
            filter:'',
            hideImportStart:true,
            processedCount: 0,
            offset:0,
            limit: 10,
            userId: '-2',
            specialCloseType:''
        }
    },
    components: {
    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
            configDataInfo:'getConfigDataInfo',
            additionalInfo:'getAdditionalInfo',
            sortByColumn: 'sortByColumn',
            truncateText: 'truncateText',
            unescapeValue:'unescapeValue',
            checkedTasksItemsData:'getCheckedTasksItemsData',
            totalFoundItems:'getTotalItemsFound',
            filterData:'getFilterData',
            allCheckedItemsTracking:'getAllCheckedTasksItemsTracking'
        })
    },
    watch: {
        allCheckedItemsTracking (newData, originalData) {
            if (this.applyFullFilter === 0) {
                if (typeof newData.items !== 'undefined') {
                    this.totalTasksQuantity = Object.keys(newData.items).length;
                } else {
                    this.totalTasksQuantity = 0;
                }
            }
        },
        totalFoundItems(newData, originalData) {
            if (this.applyFullFilter === 1) {
                this.totalTasksQuantity = this.totalFoundItems;
            }
        }

    },
    methods: {
        closeMassAction() {
            this.$store.commit('setActiveTaskMassAction', 0);
        },
        applyFullFilterEv(e) {
            if (e.target.checked === true) {
                this.applyFullFilter = 1;
                this.filter = this.filterData;
                this.totalTasksQuantity = this.totalFoundItems;
            } else {
                this.applyFullFilter = 0;
                this.filter = '';
                this.totalTasksQuantity = Object.keys(this.checkedTasksItemsData).length;
            }

            this.specialCloseType = '';
        },
        async setSpecialCloseType(e) {
            if (e.target.checked === true) {
                this.specialCloseType = e.target.value;
                let checkedTasksItemsData = this.checkedTasksItemsData;

                const result = await this.$store.dispatch('countTasksToComplete', {
                    'router': this.$router,
                    'tasksIds' : checkedTasksItemsData,
                    'userId':this.userId,
                    'specialCloseType':this.specialCloseType
                });

                this.totalTasksQuantity = result.totalRecords;
            } else {
                this.specialCloseType = '';
                this.totalTasksQuantity = Object.keys(this.checkedTasksItemsData).length;
            }

            this.filter = '';
            this.applyFullFilter = 0;
        },
        async completeTasks() {
            if (this.totalTasksQuantity < 1) {
                showMessage(this.$t('message.missingCheckedItems'), true, 3000);
                return false;
            }

            this.hideImportStart = false;
            this.offset = 0;
            this.processedCount = 0;

            this.completeTaskProcess();

        },
        async completeTaskProcess(checkedTasksItemsDataSet)
        {

            let checkedTasksItemsData = checkedTasksItemsDataSet || this.checkedTasksItemsData;

            const result = await this.$store.dispatch('completeTasks', {
                'router': this.$router,
                'tasksIds' : checkedTasksItemsData,
                'filter':this.filter,
                'applyFullFilter':this.applyFullFilter,
                'offset': this.offset,
                'limit': this.limit,
                'userId':this.userId,
                'specialCloseType':this.specialCloseType
            });

            if(result.error == '1') {
                this.hideImportStart = true;
                this.processedCount = result.responseText.count;
                if (result.responseText.error == '1') {
                    showMessage(result.responseText.message, true, 5000);
                } else {
                    showMessage(result.responseText.message, false, 5000);
                }

            } else {
                this.processedCount = result.responseText.count;
                this.offset += this.limit;
                this.completeTaskProcess(checkedTasksItemsData);
            }

            this.$store.commit('setChangedTaskMeetingNotesGrid', (Date.now() % 1000) / 1000);
        },
        async getInitialData()
        {
            if (Object.keys(this.checkedTasksItemsData).length === 0) {
                showMessage(this.$t('message.noProductsWithSubscription'), true, 3000);
                this.$store.commit('setActiveTaskMassAction', 0);
            }

            this.totalTasksQuantity = Object.keys(this.checkedTasksItemsData).length;

            this.loadedScreen = true;
        }
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.getInitialData();

    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
