import merge from 'lodash/merge';
import moment from 'moment';
import lodash from 'lodash';
import draggable from 'vuedraggable'

let defaultState = {
    opportunities: [],
    opportunitiesAdditionalInfo: [],
    additionalInfo: [],
    forecastedSales: '0',
    pipelineSize: '0',
    currencyInfo :[],
    draggable,
    selectedUserId: '',
    Unqualified:[],
    NeedsAssessment:[],
    Qualified:[],
    MeetingSet:[],
    MeetingHeld:[],
    ProposalSent:[],
    ProposalAcknowledged:[],
    ObjectionsRaised:[],
    ObjectionsOvercame:[],
    Lost:[],
    Won:[],
    shoppingCurrency:$('#dashboard-shopping-currency').val(),
    changedDate:'',
    filterPeriodMonths:[],
    selectedDate:'',
    filterDateFrom:'',
    filterDateTo:'',
};

let state = {};
merge(state, defaultState);

const actions = {

};

const mutations = {
    setOpportunities: (state, payload) => {
        state.opportunities = payload;
    },
    setOpportunitiesAdditionalInfo : (state, payload) => {
        state.opportunitiesAdditionalInfo = payload;
    },
    setCurrencyInfo : (state, payload) => {
        state.currencyInfo = payload;
    },
    setAdditionalInfo : (state, payload) => {
        state.additionalInfo = payload;
    },
    setForecastedSales : (state, payload) => {
        state.forecastedSales = payload;
    },
    setPipelineSize : (state, payload) => {
        state.pipelineSize = payload;
    },
    setSelectedUserId : (state, payload) => {
        state.selectedUserId = payload;
    },
    setUnqualified : (state, payload) => {
        state.Unqualified = payload;
    },
    setNeedsAssessment : (state, payload) => {
        state.NeedsAssessment = payload;
    },
    setQualified : (state, payload) => {
        state.Qualified = payload;
    },
    setMeetingSet : (state, payload) => {
        state.MeetingSet = payload;
    },
    setMeetingHeld : (state, payload) => {
        state.MeetingHeld = payload;
    },
    setProposalSent : (state, payload) => {
        state.ProposalSent = payload;
    },
    setProposalAcknowledged : (state, payload) => {
        state.ProposalAcknowledged = payload;
    },
    setObjectionsRaised : (state, payload) => {
        state.ObjectionsRaised = payload;
    },
    setObjectionsOvercame : (state, payload) => {
        state.ObjectionsOvercame = payload;
    },
    setLost : (state, payload) => {
        state.Lost = payload;
    },
    setWon : (state, payload) => {
        state.Won = payload;
    },
    setFilterPeriodMonths: (state, payload) => {
        state.filterPeriodMonths = payload;
    },
    setSelectedDate : (state, payload) => {
        state.selectedDate = payload;
    },
    setFilterDateFrom : (state, payload) => {
        state.filterDateFrom = payload;
    },
    setFilterDateTo : (state, payload) => {
        state.filterDateTo = payload;
    },
    setChangedDate: (state, payload) => {
        state.changedDate = payload;
    },
};

const getters = {
    getOpportunities : (state) => {
        return state.opportunities;
    },
    getOpportunitiesAdditionalInfo : (state) => {
        return state.opportunitiesAdditionalInfo;
    },
    getCurrencyInfo : (state) => {
        return state.currencyInfo
    },
    getAdditionalInfo : (state) => {
        return state.additionalInfo
    },
    getForecastedSales : (state) => {
        return state.forecastedSales
    },
    getPipelineSize : (state) => {
        return state.pipelineSize
    },
    getSelectedUserId : (state) => {
        return state.selectedUserId
    },
    getUnqualified : (state) => {
       return state.Unqualified;
    },
    getNeedsAssessment : (state) => {
        return state.NeedsAssessment;
    },
    getQualified : (state) => {
        return state.Qualified;
    },
    getMeetingSet : (state) => {
        return state.MeetingSet;
    },
    getMeetingHeld : (state) => {
        return state.MeetingHeld;
    },
    getProposalSent : (state) => {
        return state.ProposalSent;
    },
    getProposalAcknowledged : (state,) => {
        return state.ProposalAcknowledged;
    },
    getObjectionsRaised : (state) => {
        return state.ObjectionsRaised;
    },
    getObjectionsOvercame : (state) => {
        return state.ObjectionsOvercame;
    },
    getLost : (state) => {
        return state.Lost;
    },
    getWon : (state) => {
        return state.Won;
    },
    toCurrency : (state) => {
        return (value, decimals) => {
            let result = parseFloat(value),
                minDecimals = 2;

            if (typeof decimals !== 'undefined') {
                minDecimals = decimals;
            }

            if (isNaN(result)) {
                return '';
            }

            if (state.currencyInfo) {
                var currency = state.currencyInfo.currency;
                if(typeof currency === 'undefined') {
                    currency = state.shoppingCurrency;
                }

                result = result.toLocaleString(state.currencyInfo.locale, { style: 'currency', currency: currency, minimumFractionDigits: minDecimals, maximumFractionDigits: minDecimals });
            }

            return result;
        }
    },
    formatOnlyDate: (state) => {
        return (date) => {
            let finalDate = moment(date).format('DD MMM YYYY');
            if (finalDate === 'Invalid date') {
                return '';
            }

            return finalDate;
        }
    },
    sortByColumn : (state) => {
        return (data, columnName, reverse) => {
            if (typeof reverse !== 'undefined') {
                return _.orderBy(data, columnName).reverse();
            }

            return _.orderBy(data, columnName);
        }
    },
    getSelectedDate : (state) => {
        return state.selectedDate
    },
    getChangedDate: (state) => {
        return state.changedDate
    },
    getFilterPeriodMonths: (state) => {
        return state.filterPeriodMonths
    },
    getFilterDateFrom : (state) => {
        return state.filterDateFrom
    },
    getFilterDateTo : (state) => {
        return state.filterDateTo
    },
};
export default {
    state,
    actions,
    getters,
    mutations
};
