import merge from 'lodash/merge';
import moment from 'moment';
import lodash from 'lodash';
import unescape from "lodash/unescape";
import {toRaw} from "vue";

let defaultState = {
    configDataInfo: [],
    additionalInfo: [],
    selectedUserId: '',
    currencyInfo :[],
    leadGridInfo :[],
    leadGridAdditionalInfo :[],
    defaultPresetEnabled:[],
    membershipLogInfo:[],
    filterInfo:[],
    checkedItems:{},
    activeMassAction:0,
    totalItemsFound:0,
    filterData:{},
    allCheckedItemsTracking:{},
    isMassActionActive: false,
    additionalInfoDetailedScreen: [],
    detailedScreenLeadData:{},
    salesStats :[],
    opportunitiesStats :[],
    timelineLogDataUpcoming:[],
    timelineLogDataToday:[],
    timelineLogDataExpired:[],
    additionalInfoTimelineLog:[],
    timelineLogChangeFilter:{},
    profileLogData:[],
    additionalInfoProfileLog:[],
    profileLogChangeFilter:{},
    opportunitiesData:[],
    additionalInfoOpportunities:[],
    opportunitiesLogChangeFilter:{},
    emailsSmsLogData:[],
    additionalInfoEmailsSmsLog:[],
    emailsSmsLogChangeFilter:{},
    documentsGridData:[],
    additionalInfoDocumentsGrid:[],
    documentsGridChangeFilter:{},
    additionalInfoCustomAttributes:[],
    customAttributesData:[],
    changeMainTabRemote:'',
    changeSubTabRemote:'',
    updateOppStats:'',
    notesSubTabData:[],
    notesAdditionalSubTabData:[],
    taskSubTabData:[],
    taskAdditionalSubTabData:[],
    meetingSubTabData:[],
    meetingAdditionalSubTabData:[],
    emailSubTabData:[],
    emailAdditionalSubTabData:[],
    smsSubTabData:[],
    smsAdditionalSubTabData:[],
    callSubTabData:[],
    callAdditionalSubTabData:[],
    opportunitySubTabData:[],
    opportunityAdditionalSubTabData:[],
    opportunityFilterData:{},
    documentsSubTabData:[],
    documentsAdditionalSubTabData:[],
    customAttrSubTabData:[],
    customAttrAdditionalSubTabData:[],
    timelineFilterData:{},
    timelineMonth:'',
    profileTableOffset:0,
    preChosenOpportunityId:0,
    changeCustomParams:'',
    changeCustomParamsSub:'',
    activeFilterPreset:'',
    activeGridTablePreset:'',
    applyFilterRemote:{},
    showSpinnerTimeilineUpcomingSpinnerId:false,
    showSpinnerTimelineTodaySpinnerId:false,
    showSpinnerTimelineExpiredSpinnerId:false,
};

let state = {};
merge(state, defaultState);

const actions = {

};

const mutations = {
    setConfigDataInfo : (state, payload) => {
        state.configDataInfo = payload;
    },
    setAdditionalInfo : (state, payload) => {
        state.additionalInfo = payload;
    },
    setCurrencyInfo: (state, payload) => {
        state.currencyInfo = payload
    },
    setLeadGridInfo:(state, payload) => {
        state.leadGridInfo = payload;
    },
    setLeadGridAdditionalInfo:(state, payload) => {
        state.leadGridAdditionalInfo = payload;
    },
    setDefaultPresetEnabled:(state, payload) => {
        state.defaultPresetEnabled = payload;
    },
    setChangeFilter : (state, payload) => {
        state.filterInfo = payload;
    },
    setStageCompletedInfo : (state, payload) => {
        state.stageCompletedInfo = payload;
    },
    setMembershipLogInfo : (state, payload) => {
        state.membershipLogInfo = payload;
    },
    setCheckedItems : (state, payload) => {
        state.checkedItems = payload;
    },
    setActiveMassAction : (state, payload) => {
        state.activeMassAction = payload;
    },
    setTotalItemsFound: (state, payload) => {
        state.totalItemsFound = payload
    },
    setFilterData: (state, payload) => {
        state.filterData = payload
    },
    setAllCheckedItemsTracking: (state, payload) => {
        state.allCheckedItemsTracking = payload
    },
    setIsMassActionActive: (state, payload) => {
        state.isMassActionActive = payload
    },
    setAdditionalInfoDetailedScreen: (state, payload) => {
        state.additionalInfoDetailedScreen = payload
    },
    setSalesStats: (state, payload) => {
        state.salesStats = payload
    },
    setOpportunitiesStats: (state, payload) => {
        state.opportunitiesStats = payload
    },
    setTimelineLogDataUpcoming: (state, payload) => {
        state.timelineLogDataUpcoming = payload
    },
    setTimelineLogDataToday: (state, payload) => {
        state.timelineLogDataToday = payload
    },
    setTimelineLogDataExpired: (state, payload) => {
        state.timelineLogDataExpired = payload
    },
    setTimelineFilterData: (state, payload) => {
        state.timelineFilterData = payload
    },
    setOpportunityFilterData: (state, payload) => {
        state.opportunityFilterData = payload
    },
    setAdditionalInfoTimelineLog: (state, payload) => {
        state.additionalInfoTimelineLog = payload
    },
    setTimelineLogChangeFilter: (state, payload) => {
        state.timelineLogChangeFilter = payload
    },
    setChangeMainTabRemote: (state, payload) => {
        state.changeMainTabRemote = payload
    },
    setChangeSubTabRemote: (state, payload) => {
        state.changeSubTabRemote = payload
    },
    setUpdateOppStats: (state, payload) => {
        state.updateOppStats = payload
    },
    setProfileLogData: (state, payload) => {
        state.profileLogData = payload
    },
    setAdditionalInfoProfileLog: (state, payload) => {
        state.additionalInfoProfileLog = payload
    },
    setProfileLogChangeFilter: (state, payload) => {
        state.profileLogChangeFilter = payload
    },
    setOpportunitiesData: (state, payload) => {
        state.opportunitiesData = payload
    },
    setAdditionalInfoOpportunities: (state, payload) => {
        state.additionalInfoOpportunities = payload
    },
    setOpportunitiesLogChangeFilter: (state, payload) => {
        state.opportunitiesLogChangeFilter = payload
    },
    setEmailsSmsLogData: (state, payload) => {
        state.emailsSmsLogData = payload
    },
    setAdditionalInfoEmailsSmsLog: (state, payload) => {
        state.additionalInfoEmailsSmsLog = payload
    },
    setEmailsSmsLogChangeFilter: (state, payload) => {
        state.emailsSmsLogChangeFilter = payload
    },
    setDocumentsGridData: (state, payload) => {
        state.documentsGridData = payload
    },
    setAdditionalInfoDocumentsGrid: (state, payload) => {
        state.additionalInfoDocumentsGrid = payload
    },
    setDocumentsGridChangeFilter: (state, payload) => {
        state.documentsGridChangeFilter = payload
    },
    setAdditionalInfoCustomAttributes: (state, payload) => {
        state.additionalInfoCustomAttributes = payload
    },
    setCustomAttributesData: (state, payload) => {
        state.customAttributesData = payload
    },
    setNotesSubTabData: (state, payload) => {
        state.notesSubTabData = payload
    },
    setNotesAdditionalSubTabData: (state, payload) => {
        state.notesAdditionalSubTabData = payload
    },
    setTaskSubTabData: (state, payload) => {
        state.taskSubTabData = payload
    },
    setTaskAdditionalSubTabData: (state, payload) => {
        state.taskAdditionalSubTabData = payload
    },
    setMeetingSubTabData: (state, payload) => {
        state.meetingSubTabData = payload
    },
    setMeetingAdditionalSubTabData: (state, payload) => {
        state.meetingAdditionalSubTabData = payload
    },
    setEmailSubTabData: (state, payload) => {
        state.emailSubTabData = payload
    },
    setEmailAdditionalSubTabData: (state, payload) => {
        state.emailAdditionalSubTabData = payload
    },
    setSmsSubTabData: (state, payload) => {
        state.smsSubTabData = payload
    },
    setSmsAdditionalSubTabData: (state, payload) => {
        state.smsAdditionalSubTabData = payload
    },
    setCallSubTabData: (state, payload) => {
        state.callSubTabData = payload
    },
    setCallAdditionalSubTabData: (state, payload) => {
        state.callAdditionalSubTabData = payload
    },
    setOpportunitySubTabData: (state, payload) => {
        state.opportunitySubTabData = payload
    },
    setOpportunityAdditionalSubTabData: (state, payload) => {
        state.opportunityAdditionalSubTabData = payload
    },
    setDocumentsSubTabData: (state, payload) => {
        state.documentsSubTabData = payload
    },
    setDocumentsAdditionalSubTabData: (state, payload) => {
        state.documentsAdditionalSubTabData = payload
    },
    setCustomAttrSubTabData: (state, payload) => {
        state.customAttrSubTabData = payload
    },
    setCustomAttrAdditionalSubTabData: (state, payload) => {
        state.customAttrAdditionalSubTabData = payload
    },
    setDetailedScreenLeadData: (state, payload) => {
        state.detailedScreenLeadData = payload
    },
    setTimelineMonth: (state, payload) => {
        state.timelineMonth = payload
    },
    setProfileTableOffset: (state, payload) => {
        state.profileTableOffset = payload;
    },
    setPreChosenOpportunityId: (state, payload) => {
        state.preChosenOpportunityId = payload;
    },
    setChangeCustomParams: (state, payload) => {
        state.changeCustomParams = payload;
    },
    setChangeCustomParamsSub: (state, payload) => {
        state.changeCustomParamsSub = payload;
    },
    setActiveFilterPreset: (state, payload) => {
        state.activeFilterPreset = payload;
    },
    setActiveGridTablePreset: (state, payload) => {
        state.activeGridTablePreset = payload;
    },
    setApplyFilterRemote: (state, payload) => {
        state.applyFilterRemote = payload;
    },
    setShowSpinnerTimeilineUpcomingSpinnerId: (state, payload) => {
        state.showSpinnerTimeilineUpcomingSpinnerId = payload;
    },
    setShowSpinnerTimelineTodaySpinnerId: (state, payload) => {
        state.showSpinnerTimelineTodaySpinnerId = payload;
    },
    setShowSpinnerTimelineExpiredSpinnerId: (state, payload) => {
        state.showSpinnerTimelineExpiredSpinnerId = payload;
    },


};

const getters = {
    getConfigDataInfo : (state) => {
        return state.configDataInfo
    },
    getAdditionalInfo : (state) => {
        return state.additionalInfo
    },
    getCurrencyInfo : (state) => {
        return state.currencyInfo
    },
    getChangeFilter : (state) => {
        return state.filterInfo
    },
    getStageCompletedInfo : (state) => {
        return state.stageCompletedInfo
    },
    getLeadGridInfo : (state) => {
        return state.leadGridInfo
    },
    getLeadGridAdditionalInfo : (state) => {
        return state.leadGridAdditionalInfo
    },
    getDefaultPresetEnabled : (state) => {
        return state.defaultPresetEnabled
    },
    getMembershipLogInfo : (state) => {
        return state.membershipLogInfo
    },
    getCheckedItems : (state) => {
        return state.checkedItems
    },
    getActiveMassAction : (state) => {
        return state.activeMassAction
    },
    getTotalItemsFound : (state) => {
        return state.totalItemsFound
    },
    getFilterData : (state) => {
        return state.filterData
    },
    getAllCheckedItemsTracking : (state) => {
        return state.allCheckedItemsTracking
    },
    getIsMassActionActive : (state) => {
        return state.isMassActionActive
    },
    getAdditionalInfoDetailedScreen : (state) => {
        return state.additionalInfoDetailedScreen
    },
    getSalesStats : (state) => {
        return state.salesStats
    },
    getOpportunitiesStats : (state) => {
        return state.opportunitiesStats
    },
    getTimelineLogDataUpcoming : (state) => {
        return state.timelineLogDataUpcoming
    },
    getTimelineLogDataToday : (state) => {
        return state.timelineLogDataToday
    },
    getTimelineLogDataExpired : (state) => {
        return state.timelineLogDataExpired
    },
    getTimelineFilterData : (state) => {
        return state.timelineFilterData
    },
    getOpportunityFilterData : (state) => {
        return state.opportunityFilterData
    },
    getAdditionalInfoTimelineLog : (state) => {
        return state.additionalInfoTimelineLog
    },
    getTimelineLogChangeFilter : (state) => {
        return state.timelineLogChangeFilter
    },
    getRequestsData : (state) => {
        return state.requestsData
    },
    getAdditionalInfoRequests : (state) => {
        return state.additionalInfoRequests
    },
    getChangeMainTabRemote: (state) => {
        return state.changeMainTabRemote;
    },
    getChangeSubTabRemote: (state) => {
        return state.changeSubTabRemote;
    },
    getUpdateOppStats: (state) => {
        return state.updateOppStats;
    },
    getProfileLogData: (state) => {
        return state.profileLogData;
    },
    getAdditionalInfoProfileLog: (state) => {
        return state.additionalInfoProfileLog;
    },
    getProfileLogChangeFilter: (state) => {
        return state.profileLogChangeFilter;
    },
    getOpportunitiesData: (state) => {
        return state.opportunitiesData;
    },
    getAdditionalInfoOpportunities: (state) => {
        return state.additionalInfoOpportunities;
    },
    getOpportunitiesLogChangeFilter: (state) => {
        return state.opportunitiesLogChangeFilter;
    },
    getEmailsSmsLogData: (state) => {
        return state.emailsSmsLogData;
    },
    getAdditionalInfoEmailsSmsLog: (state) => {
        return state.additionalInfoEmailsSmsLog;
    },
    getEmailsSmsLogChangeFilter: (state) => {
        return state.emailsSmsLogChangeFilter;
    },
    getDocumentsGridData: (state) => {
        return state.documentsGridData;
    },
    getAdditionalInfoDocumentsGrid: (state) => {
        return state.additionalInfoDocumentsGrid;
    },
    getDocumentsGridChangeFilter: (state) => {
        return state.documentsGridChangeFilter;
    },
    getAdditionalInfoCustomAttributes: (state) => {
        return state.additionalInfoCustomAttributes;
    },
    getCustomAttributesData: (state) => {
        return state.customAttributesData;
    },
    getNotesSubTabData: (state) => {
        return state.notesSubTabData;
    },
    getNotesAdditionalSubTabData: (state) => {
        return state.notesAdditionalSubTabData;
    },
    getTaskSubTabData: (state) => {
        return state.taskSubTabData;
    },
    getTaskAdditionalSubTabData: (state) => {
        return state.taskAdditionalSubTabData;
    },
    getMeetingSubTabData: (state) => {
        return state.meetingSubTabData;
    },
    getMeetingAdditionalSubTabData: (state) => {
        return state.meetingAdditionalSubTabData;
    },
    getEmailSubTabData: (state) => {
        return state.emailSubTabData;
    },
    getEmailAdditionalSubTabData: (state) => {
        return state.emailAdditionalSubTabData;
    },
    getSmsSubTabData: (state) => {
        return state.smsSubTabData;
    },
    getSmsAdditionalSubTabData: (state) => {
        return state.smsAdditionalSubTabData;
    },
    getCallSubTabData: (state) => {
        return state.callSubTabData;
    },
    getCallAdditionalSubTabData: (state) => {
        return state.callAdditionalSubTabData;
    },
    getOpportunitySubTabData: (state) => {
        return state.opportunitySubTabData;
    },
    getOpportunityAdditionalSubTabData: (state) => {
        return state.opportunityAdditionalSubTabData;
    },
    getDocumentsSubTabData: (state) => {
        return state.documentsSubTabData;
    },
    getDocumentsAdditionalSubTabData: (state) => {
        return state.documentsAdditionalSubTabData;
    },
    getCustomAttrSubTabData: (state) => {
        return state.customAttrSubTabData;
    },
    getCustomAttrAdditionalSubTabData: (state) => {
        return state.customAttrAdditionalSubTabData;
    },
    getDetailedScreenLeadData: (state) => {
        return state.detailedScreenLeadData;
    },
    getProfileTableOffset: (state) => {
        return state.profileTableOffset;
    },
    getPreChosenOpportunityId: (state) => {
        return state.preChosenOpportunityId;
    },
    getChangeCustomParams: (state) => {
        return state.changeCustomParams;
    },
    getChangeCustomParamsSub: (state) => {
        return state.changeCustomParamsSub;
    },
    getActiveFilterPreset: (state) => {
        return state.activeFilterPreset;
    },
    getActiveGridTablePreset: (state) => {
        return state.activeGridTablePreset;
    },
    getApplyFilterRemote: (state) => {
        return state.applyFilterRemote;
    },
    getShowSpinnerTimeilineUpcomingSpinnerId: (state) => {
        return state.showSpinnerTimeilineUpcomingSpinnerId;
    },
    getShowSpinnerTimelineTodaySpinnerId: (state) => {
        return state.showSpinnerTimelineTodaySpinnerId;
    },
    getShowSpinnerTimelineExpiredSpinnerId: (state) => {
        return state.showSpinnerTimelineExpiredSpinnerId;
    },
    isNewMonthRowTimeline:(state) => {
        return (date) => {
            let currentRowMonthTimeline = moment(date, 'YYYY-MM-DD HH:mm:ss').format('MMMM');

            if (typeof window.newMonthRowExpiredTimeline === 'undefined' || currentRowMonthTimeline !== window.newMonthRowExpiredTimeline) {
                window.newMonthRowExpiredTimeline = currentRowMonthTimeline;
                return true;
            }

            window.newMonthRowExpiredTimeline = currentRowMonthTimeline;

            return false;
        }
    },
    isNewOpportunityRow:(state) => {
        return (opportunityId) => {
            let newOpportunityRow = false;


            if (typeof window.newOpportunityNameRow === 'undefined' || window.newOpportunityNameRow !== opportunityId) {
                window.newOpportunityNameRow = opportunityId;
                newOpportunityRow = true;
            }

            return newOpportunityRow;
        }
    },
    isNewWeekRow:(state) => {
        return (weekId) => {

            let newWeekRow = false;

            if (typeof window.newEmailSmsWeekRow === 'undefined' || window.newEmailSmsWeekRow !== weekId) {
                window.newEmailSmsWeekRow = weekId;
                newWeekRow = true;
            }

            return newWeekRow;
        }
    },
    formatDate : (state) => {
        return (date) => {
            let finalDate =  moment(date).format('DD MMM YYYY hh:mm a');
            if (finalDate === 'Invalid date') {
                return '';
            }

            return finalDate;
        }
    },
    formatOnlyDate: (state) => {
        return (date) => {
            let finalDate = moment(date).format('DD MMM YYYY');
            if (finalDate === 'Invalid date') {
                return '';
            }

            return finalDate;
        }
    },
    formatTimeDayFullName: (state) => {
        return (date) => {
            let finalDate = moment(date).format('DD MMMM YYYY');
            if (finalDate === 'Invalid date') {
                return '';
            }

            return finalDate;
        }
    },
    formatTimeOnlyWithPartOfTheDay: (state) => {
        return (date) => {
            let finalDate = moment(date).format('hh:mm A');
            if (finalDate === 'Invalid date') {
                return '';
            }

            return finalDate;
        }
    },
    formatTimeOnly: (state) => {
        return (date) => {
            let finalDate = moment(date).format('HH:mm');
            if (finalDate === 'Invalid date') {
                return '';
            }

            return finalDate;
        }
    },
    isValidDate: (state) => {
        return (date) => {
            return moment(date, 'YYYY-MM-DD HH:mm:ss').isValid();
        }
    },
    isAfterDate: (state) => {
        return (date, dateCompare) => {
            let origDate = moment(date).format('DD MMM YYYY');
            if (origDate === 'Invalid date') {
                return '';
            }

            let compareDate = moment(dateCompare).format('DD MMM YYYY');
            if (compareDate === 'Invalid date') {
                return '';
            }

            return moment(origDate).isAfter(compareDate);
        }
    },
    formatDateForGraphs : (state) => {
        return (date) => {
            return moment(date).format('DD-MMM-YYYY');
        }
    },
    sortByColumn : (state) => {
        return (data, columnName, reverse, numerical) => {
            if (reverse) {
                return _.orderBy(data, [info => info[columnName].toLowerCase()]).reverse();
            }

            if (numerical) {
                return   _.orderBy(data,  [info => parseInt(info[columnName])]);
            }

            return _.orderBy(data,  [info => info[columnName].toLowerCase()]);
        }
    },
    truncateText : (state) => {
        return (text, limit) => {
            if (text.length > limit) {
                text = text.substring(0, (limit - 3)) + '...';
            }

            return text;
        }
    },
    cleanText : (state) => {
        return (text, replaceTo) => {
            let replaceToSymbol = '';

            if (typeof replaceTo !== 'undefined') {
                replaceToSymbol = replaceTo;
            }

            text = text.replace(/(<([^>]+)>)/gi, replaceToSymbol);

            return text;
        }
    },
    countOnlySymbols : (state) => {
        return (text) => {
            let replaceToSymbol = text.replaceAll(/[.,?!;:\-—\[\]{}() ]/g, "").length;

            return replaceToSymbol;
        }
    },
    toCurrency : (state) => {
        return (value, decimals) => {
            let result = parseFloat(value),
                minDecimals = 2;

            if (typeof decimals !== 'undefined') {
                minDecimals = decimals;
            }

            if (isNaN(result)) {
                return '';
            }

            if (state.currencyInfo) {
                result = result.toLocaleString(state.currencyInfo.locale, { style: 'currency', currency: state.currencyInfo.currency, minimumFractionDigits: minDecimals, maximumFractionDigits: minDecimals });
            }

            return result;
        }
    },
    currencyOnly: (state) => {
       return (value) => {
          let result ='';

          result = (0).toLocaleString(state.currencyInfo.locale, { style: 'currency', currency:state.currencyInfo.currency, minimumFractionDigits: 0, maximumFractionDigits: 0 }).replace(/\d/g, '').trim()

          return result;
      }
    },
    unescapeValue: (state) => {
        return (value) => {
            return unescape(value);
        }
    },
    alphabeticalSort: (state) => {
        return (data) => {
            // convert object into array
            var sortable=[];
            for(var key in data)
            if(data.hasOwnProperty(key))
                sortable.push([key, data[key]]); // each item is an array in format [key, value]
            // sort items by value
            sortable.sort(function(a, b)
            {
                var x=a[1].toLowerCase(),
                    y=b[1].toLowerCase();
                return x<y ? -1 : x>y ? 1 : 0;
            });
            return sortable; // array in format [ [ key1, val1 ], [ key2, val2 ], ... ]
        }
    },
    ucFirstAllText: (state) => {
        return (str) => {
            let result = '';
            for (let i = 0; i < str.length; i += 1) {
                let shouldBeBig = str[i] !== ' ' && (i === 0 || str[i - 1] === ' ');
                result += shouldBeBig ? str[i].toUpperCase() : str[i];
            }
            return result;
        };
    },


};
export default {
    state,
    actions,
    getters,
    mutations
};
