import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
import moment from 'moment';
import { isProxy, toRaw } from 'vue';

export default {
    data () {
        return {
            loadedScreen: false,
            websiteUrl: $('#website_url').val(),
            localeMapping: localeMapping,
            locale: $('#dashboard-system-language').val(),
            itemsQuantity:0,
            filterUsed:false,
            matchingFilter:false,
            deletedElBlock:false,
            origProcessed:true,
            endProcessed:false,
            matchingFilterBlock:true,
            clNone:true,
            itemsProcessed:0,
        }
    },
    components: {
    },
    computed: {
        ...mapGetters({
            configDataInfo:'getConfigDataInfo',
            additionalInfo:'getAdditionalInfo',
            truncateText: 'truncateText',
            unescapeValue:'unescapeValue',
            checkedItemsData:'getCheckedItems',
            totalFoundItems:'getTotalItemsFound',
            filterData:'getFilterData',
            ucFirstAllText:'ucFirstAllText',
        })
    },
    watch: {

    },
    methods: {
        closeMassAction() {
            this.$store.commit('setActiveMassAction', 0);
        },
        async submitRegularForm()
        {
            let self = this,
                leadsLabel = this.$t('message.lead')+'?';
            if(this.itemsQuantity > 1) {
                leadsLabel = this.$t('message.leads')+'?';
            }

            this.itemsProcessed = 0;

            showConfirm(this.$t('message.areYouSureYouWantToDeleteLead') + ' ' + this.itemsQuantity + ' ' + leadsLabel, function(){
                self.massDeleteLeadsRequest(0);
            }, function () {

            });
        },
        async massDeleteLeadsRequest(step)
        {
            let filters = toRaw(this.filterData),
                matchingFilter = 0;

            if (Object.keys(filters).length === 0) {
                filters = {};
            }

            if(this.matchingFilter) {
                matchingFilter = 1;
            }

            const result = await this.$store.dispatch('deleteMassLeadsMassAction', {
                'router': this.$router,
                'leadIds': Object.keys(this.checkedItemsData).join(','),
                'step': step,
                'filters': filters,
                'matchingFilter': matchingFilter,
                'filterQuantity': this.itemsQuantity,
            });

            this.deletedElBlock = true;
            this.itemsProcessed = this.itemsProcessed + result.responseText.quantity;

            if (result.error == 0) {
                this.massDeleteLeadsRequest(step+1);
            } else {
                this.origProcessed = false;
                this.matchingFilterBlock = false;
                this.endProcessed = true;
                this.clNone = false;

                this.$store.commit('setApplyFilterRemote', Date.now());
                this.$store.commit('setCheckedItems', {});

            }
        },
        async countLeads(event)
        {
            let isChecked = event.target.checked;

            if (isChecked === true) {
                let filters = toRaw(this.filterData);

                if (Object.keys(filters).length === 0) {
                    filters = {};
                }

                const result = await this.$store.dispatch('countLeadsMassAction', {
                    'router': this.$router,
                    'filters': filters,
                    'existMobileNumber': 0,
                });

                if(result.error != 1) {
                    this.itemsQuantity = parseInt(result.responseText.quantity);
                } else {
                    showMessage(this.$t('message.noLeadsFound'), true, 5000);
                }
            } else {
                this.itemsQuantity = parseInt(Object.keys(this.checkedItemsData).length);
            }

        },
        async getInitialData()
        {
            if (Object.keys(this.checkedItemsData).length === 0) {
                showMessage(this.$t('message.pleaseChooseAtLeastOneLead'), true, 3000);
                this.closeMassAction();
            }

            let filters = toRaw(this.filterData);

            this.filterUsed = true;
            if (Object.keys(filters).length === 0) {
                this.filterUsed = false;
            }

            this.itemsQuantity = parseInt(Object.keys(this.checkedItemsData).length);

            if (this.itemsQuantity > 0) {
                this.loadedScreen = true;
            }
        },
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.getInitialData();
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
