import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
import moment from 'moment';
import { isProxy, toRaw } from 'vue';

export default {
    data () {
        return {
            loadedScreen: false,
            websiteUrl: $('#website_url').val(),
            localeMapping: localeMapping,
            locale: $('#dashboard-system-language').val(),
            leadOwners:[],
            selectedOwner:0,
            allOwnerFilterLeads:0,
            filter:'',
            itemsQuantity:0,
        }
    },
    components: {

    },
    computed: {
        ...mapGetters({
            configDataInfo:'getConfigDataInfo',
            additionalInfo:'getAdditionalInfo',
            truncateText: 'truncateText',
            unescapeValue:'unescapeValue',
            checkedItemsData:'getCheckedItems',
            totalFoundItems:'getTotalItemsFound',
            filterData:'getFilterData',
            ucFirstAllText:'ucFirstAllText',
        })
    },
    watch: {

    },
    methods: {
        closeMassAction() {
            this.$store.commit('setActiveMassAction', 0);
        },
        async submitRegularForm()
        {
            let filters = toRaw(this.filterData);

            if (Object.keys(filters).length === 0) {
                filters = {};
            }

            if(this.selectedOwner == 0) {
                showMessage(this.$t('message.pleaseChooseLeadOwner'), true, 5000);
                return false;
            }

            const result = await this.$store.dispatch('assignLeadOwnerMassAction', {
                'router': this.$router,
                'leadOwnerId': this.selectedOwner,
                'leadIds': Object.keys(this.checkedItemsData).join(','),
                'filters': filters,
                'allOwnerFilterLeads': this.allOwnerFilterLeads,
            });

            if(result.error != 1) {
                showMessage(result.responseText, false, 3000);
                this.closeMassAction();
            } else {
                showMessage(result.responseText, true, 5000);
            }
        },
        async getLeadOwners()
        {
            const result = await this.$store.dispatch('getLeadOwnersMassAction', {
                'router': this.$router
            });

            if (result.error === 1) {
                showMessage(this.$t('message.smsNoMassActionRecordsFound'), true, 3000);
                this.closeMassAction();
                return false;
            } else {
                this.itemsQuantity = parseInt(Object.keys(this.checkedItemsData).length);
                this.leadOwners = result.leadOwnersFull;
            }
        },
        async countLeads(event)
        {
            let isChecked = event.target.checked;

            if (isChecked === true) {
                this.allOwnerFilterLeads = 1;
                let filters = toRaw(this.filterData);

                if (Object.keys(filters).length === 0) {
                    filters = {};
                }

                const result = await this.$store.dispatch('countLeadsMassAction', {
                    'router': this.$router,
                    'filters': filters,
                    'existMobileNumber': 0,
                });

                if(result.error != 1) {
                    this.itemsQuantity = parseInt(result.responseText.quantity);
                } else {
                    this.allOwnerFilterLeads = 0;
                    showMessage(this.$t('message.noLeadsFound'), true, 5000);
                }
            } else {
                this.allOwnerFilterLeads = 0;
                this.itemsQuantity = parseInt(Object.keys(this.checkedItemsData).length);
            }

        },
        async getInitialData()
        {
            if (Object.keys(this.checkedItemsData).length === 0) {
                showMessage(this.$t('message.pleaseChooseAtLeastOneLead'), true, 3000);
                this.closeMassAction();
            }

            await this.getLeadOwners();

            if (this.itemsQuantity > 0) {
                this.loadedScreen = true;
            }
        },
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.getInitialData();
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
