import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
import massactiongridsendsms from '../../massactiongridsendsms';
import massactiongridaddtags from '../../massactiongridaddtags';
import massactiongridassignsequence from '../../massactiongridassignsequence';
import massactiongridaddremoveemailmarketing from '../../massactiongridaddremoveemailmarketing';
import massactiongridremarketingcampaigns from '../../massactiongridremarketingcampaigns';
import massactiongridchangeleadowner from '../../massactiongridchangeleadowner';
import massactiongridmergeleads from '../../massactiongridmergeleads';
import massactiongridexportleads from '../../massactiongridexportleads';
import massactiongriddeleteleads from '../../massactiongriddeleteleads';
import massactiongriddeleteleadsandmarkasspam from '../../massactiongriddeleteleadsandmarkasspam';
import massactiongridvalidateemails from '../../massactiongridvalidateemails';
import { isProxy, toRaw } from 'vue';
export default {
    data () {
        return {
            loadedScreen: false,
            websiteUrl: $('#website_url').val(),
            searchData:'',
            planId:0,
            localeMapping: localeMapping,
            locale: $('#dashboard-system-language').val(),
            perPageDataValues : {
                '10':10,
                '25':25,
                '50':50,
                '100':100
            },
            columnsHeaders: {},
            listOfDefaultColumnNamesOrder: [],
            options: [],
            columnSelectionModel:[],
            tableColumnOrderName:'',
            restrictColumnEditing:'0',
            columnsModified:false,
            applyColumnOrderToAllUsers:'',
            userPresetsList: [],
            presetId:0,
            currentPresetId:0,
            newPresetName:'',
            presetDefault:false,
            stages:{},
            customerGroups:{},
            leadTypes:{},
            userTimezoneOffset:'',
            displayCallDialog:false,
            activeDialogId:0,
            callDialogLeadName:'',
            callDialogCountryCodeMobile:'',
            callDialogCountryCodeDesktop:'',
            callDialogMobile:'',
            callDialogDeviceFrom:'mobile',
            callDialogDeviceTo:'mobile',
            callDialogNumber:'',
            callDialogCountryCodeChosen:'',
            urlPredefinedFilterParams:[],
            scrollBarStyle:'',
            initialScrollBarSize:'',
            currentScrollBarSize:''
        }
    },
    components: {
        pagination: pagination,
        massactiongridsendsms:massactiongridsendsms,
        massactiongridaddtags:massactiongridaddtags,
        massactiongridassignsequence:massactiongridassignsequence,
        massactiongridaddremoveemailmarketing:massactiongridaddremoveemailmarketing,
        massactiongridremarketingcampaigns:massactiongridremarketingcampaigns,
        massactiongridchangeleadowner:massactiongridchangeleadowner,
        massactiongridmergeleads:massactiongridmergeleads,
        massactiongridexportleads:massactiongridexportleads,
        massactiongriddeleteleads:massactiongriddeleteleads,
        massactiongriddeleteleadsandmarkasspam:massactiongriddeleteleadsandmarkasspam,
        massactiongridvalidateemails:massactiongridvalidateemails,
    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
            configDataInfo:'getConfigDataInfo',
            additionalInfo:'getAdditionalInfo',
            sortByColumn: 'sortByColumn',
            truncateText: 'truncateText',
            changeFilter: 'getChangeFilter',
            unescapeValue:'unescapeValue',
            LeadsGridInfoData: 'getLeadGridInfo',
            leadsGridAdditionalInfoData: 'getLeadGridAdditionalInfo',
            checkedItems:'getCheckedItems',
            activeMassAction:'getActiveMassAction',
            massActionActive:'getIsMassActionActive',
            filterData:'getFilterData',
            salesStats:'getSalesStats',
            opportunitiesStats:'getOpportunitiesStats',
            toCurrency:'toCurrency',
            updateOppStats:'getUpdateOppStats',
            activeGridTablePreset:'getActiveGridTablePreset',
            applyFilterRemote:'getApplyFilterRemote',
            pagerState: 'getPagerState',
        })
    },
    watch: {
        applyFilterRemote()
        {
            this.applyFilter();
        },
        changeFilter (newData, originalData) {
            this.$store.commit('setPaginationData',
            {
                leadGrid: {
                    currentPage: 1,
                    itemsPerPage: this.pagerState('leadGrid').itemsPerPage,
                    totalItems: 0,
                    visiblePages: 4
                }
            });

            if (typeof newData.searchData !== 'undefined') {
                if (isProxy(newData.searchData)) {
                    let filterDataObject = {};
                    if (newData.searchData.filterBy !== 'undefined') {
                        filterDataObject['filter-by'] = toRaw(newData.searchData.filterBy);
                    }

                    if (newData.searchData.filterOrderBy !== 'undefined') {
                        filterDataObject['interaction_value'] = toRaw(newData.searchData.filterOrderBy);
                    }

                    if (newData.searchData.filterIncludeCustomLeadFields !== 'undefined') {
                        filterDataObject['search_includes_custom_lead_fields'] = toRaw(newData.searchData.filterIncludeCustomLeadFields);
                    }

                    if (newData.searchData.filterIncludeCustomNotes !== 'undefined') {
                        filterDataObject['search_includes_notes'] = toRaw(newData.searchData.filterIncludeCustomNotes);
                    }

                    if (newData.searchData.filterIncludeCallTranscript !== 'undefined') {
                        filterDataObject['search_includes_call_transcript'] = toRaw(newData.searchData.filterIncludeCallTranscript);
                    }

                    if (newData.searchData.filterCreationDateFrom !== 'undefined') {
                        filterDataObject['created_at_from'] = toRaw(newData.searchData.filterCreationDateFrom);
                    }

                    if (newData.searchData.filterCreationDateTo !== 'undefined') {
                        filterDataObject['created_at_to'] = toRaw(newData.searchData.filterCreationDateTo);
                    }

                    if (newData.searchData.filterActivityDateFrom !== 'undefined') {
                        filterDataObject['next_activity_from'] = toRaw(newData.searchData.filterActivityDateFrom);
                    }

                    if (newData.searchData.filterActivityDateTo !== 'undefined') {
                        filterDataObject['next_activity_to'] = toRaw(newData.searchData.filterActivityDateTo);
                    }

                    if (newData.searchData.filterSequenceDateFrom !== 'undefined') {
                        filterDataObject['last_sequence_from'] = toRaw(newData.searchData.filterSequenceDateFrom);
                    }

                    if (newData.searchData.filterSequenceDateTo !== 'undefined') {
                        filterDataObject['last_sequence_to'] = toRaw(newData.searchData.filterSequenceDateTo);
                    }

                    if (newData.searchData.filterOpportunityDateFrom !== 'undefined') {
                        filterDataObject['opportunity_date_from'] = toRaw(newData.searchData.filterOpportunityDateFrom);
                    }

                    if (newData.searchData.filterOpportunityDateTo !== 'undefined') {
                        filterDataObject['opportunity_date_to'] = toRaw(newData.searchData.filterOpportunityDateTo);
                    }

                    if (newData.searchData.creationAt !== 'undefined') {
                        filterDataObject['creation_at'] = toRaw(newData.searchData.creationAt);
                    }

                    if (newData.searchData.stateChangeAt !== 'undefined') {
                        filterDataObject['state_change_at'] = toRaw(newData.searchData.stateChangeAt);
                    }

                    if (newData.searchData.expectedAt !== 'undefined') {
                        filterDataObject['expected_at'] = toRaw(newData.searchData.expectedAt);
                    }

                    if (newData.searchData.filterActivities !== 'undefined') {
                        filterDataObject['activity_id'] = toRaw(newData.searchData.filterActivities);
                    }

                    if (newData.searchData.lastUpdatedFlag !== 'undefined') {
                        filterDataObject['last_updated'] = toRaw(newData.searchData.lastUpdatedFlag);
                    }

                    if (newData.searchData.searchTerm !== 'undefined') {
                        filterDataObject['lead-attribute'] = toRaw(newData.searchData.searchTerm);
                    }

                    if (newData.searchData.filterLifecycles !== 'undefined') {
                        filterDataObject['stage_id'] = toRaw(newData.searchData.filterLifecycles);
                    }

                    if (newData.searchData.emailInteractionActivitySubtype !== 'undefined') {
                        filterDataObject['outbound_emails_sub_type'] = toRaw(newData.searchData.emailInteractionActivitySubtype);
                    }

                    if (newData.searchData.filterByTaskStatus !== 'undefined') {
                        filterDataObject['lead_task'] = toRaw(newData.searchData.filterByTaskStatus);
                    }

                    if (newData.searchData.filterByCountry !== 'undefined') {
                        filterDataObject['lead_country'] = toRaw(newData.searchData.filterByCountry);
                    }

                    if (newData.searchData.filterByCountryState !== 'undefined') {
                        filterDataObject['lead_country_state'] = toRaw(newData.searchData.filterByCountryState);
                    }

                    if (newData.searchData.filterByIndustry !== 'undefined') {
                        filterDataObject['industry_id'] = toRaw(newData.searchData.filterByIndustry);
                    }

                    if (newData.searchData.filterByEmailSequence !== 'undefined') {
                        filterDataObject['email_sms_sequences'] = toRaw(newData.searchData.filterByEmailSequence);
                    }

                    if (newData.searchData.filterBySequenceType !== 'undefined') {
                        filterDataObject['email_sequence_type'] = toRaw(newData.searchData.filterBySequenceType);
                    }

                    if (newData.searchData.filterBySequenceTypeAction !== 'undefined') {
                        filterDataObject['email_sequence_type_action'] = toRaw(newData.searchData.filterBySequenceTypeAction);
                    }

                    if (newData.searchData.filterByOpportunityOwnerId !== 'undefined') {
                        filterDataObject['opportunity_owner_id'] = toRaw(newData.searchData.filterByOpportunityOwnerId);
                    }

                    if (newData.searchData.filterByTotalOpportunityAmountFrom !== 'undefined') {
                        filterDataObject['total_opportunity_amount_from'] = toRaw(newData.searchData.filterByTotalOpportunityAmountFrom);
                    }

                    if (newData.searchData.filterByTotalOpportunityAmountTo !== 'undefined') {
                        filterDataObject['total_opportunity_amount_to'] = toRaw(newData.searchData.filterByTotalOpportunityAmountTo);
                    }

                    if (newData.searchData.filterByTotalSpentPurchaseAmountFrom !== 'undefined') {
                        filterDataObject['total_spent_purchase_amount_from'] = toRaw(newData.searchData.filterByTotalSpentPurchaseAmountFrom);
                    }

                    if (newData.searchData.filterByTotalSpentPurchaseAmountTo !== 'undefined') {
                        filterDataObject['total_spent_purchase_amount_to'] = toRaw(newData.searchData.filterByTotalSpentPurchaseAmountTo);
                    }

                    if (newData.searchData.filterLeadOwnerId !== 'undefined') {
                        filterDataObject['owner_id'] = toRaw(newData.searchData.filterLeadOwnerId);
                    }

                    if (newData.searchData.filterByGroup !== 'undefined') {
                        filterDataObject['customer_group_id'] = toRaw(newData.searchData.filterByGroup);
                    }

                    if (newData.searchData.filterByTags !== 'undefined') {
                        filterDataObject['lead_tags'] = toRaw(newData.searchData.filterByTags);
                    }

                    if (newData.searchData.filterBySourceTypes !== 'undefined') {
                        filterDataObject['lead_source_type_and_utm'] = toRaw(newData.searchData.filterBySourceTypes);
                    }

                    if (newData.searchData.filterBySourceUtmValues !== 'undefined') {
                        filterDataObject['lead_utm_source_value_id'] = toRaw(newData.searchData.filterBySourceUtmValues);
                    }

                    if (newData.searchData.filterByCampaignUtmValues !== 'undefined') {
                        filterDataObject['lead_utm_campaign_value_id'] = toRaw(newData.searchData.filterByCampaignUtmValues);
                    }

                    if (newData.searchData.filterByCity !== 'undefined') {
                        filterDataObject['lead_city'] = toRaw(newData.searchData.filterByCity);
                    }

                    if (newData.searchData.filterByTitleOperator !== 'undefined') {
                        filterDataObject['lead_title_operator'] = toRaw(newData.searchData.filterByTitleOperator);
                    }

                    if (newData.searchData.byLeadTitle !== 'undefined') {
                        filterDataObject['lead_titles'] = toRaw(newData.searchData.byLeadTitle);
                    }

                    if (newData.searchData.filterByOpportunityStatus !== 'undefined') {
                        filterDataObject['lead_opportunity_stages'] = toRaw(newData.searchData.filterByOpportunityStatus);
                    }

                    if (newData.searchData.filterByScoreFrom !== 'undefined') {
                        filterDataObject['lead_score_from'] = toRaw(newData.searchData.filterByScoreFrom);
                    }

                    if (newData.searchData.filterByScoreTo !== 'undefined') {
                        filterDataObject['lead_score_to'] = toRaw(newData.searchData.filterByScoreTo);
                    }

                    if (newData.searchData.filterBySentimentScoreFrom !== 'undefined') {
                        filterDataObject['lead_sentiment_score_from'] = toRaw(newData.searchData.filterBySentimentScoreFrom);
                    }

                    if (newData.searchData.filterBySentimentScoreTo !== 'undefined') {
                        filterDataObject['lead_sentiment_score_to'] = toRaw(newData.searchData.filterBySentimentScoreTo);
                    }

                    if (newData.searchData.filterByLeadType !== 'undefined') {
                        filterDataObject['lead_source_type'] = toRaw(newData.searchData.filterByLeadType);
                    }

                    if (newData.searchData.filterBySignCallDuration !== 'undefined') {
                        filterDataObject['more_less_call_duration'] = toRaw(newData.searchData.filterBySignCallDuration);
                    }

                    if (newData.searchData.filterByCallDuration !== 'undefined') {
                        filterDataObject['call_duration'] = toRaw(newData.searchData.filterByCallDuration);
                    }

                    if (newData.searchData.filterByLeadSource !== 'undefined') {
                        filterDataObject['lead_source'] = toRaw(newData.searchData.filterByLeadSource);
                    }

                    if (newData.searchData.filterByExcludeTags !== 'undefined') {
                        filterDataObject['lead_tags_exclude'] = toRaw(newData.searchData.filterByExcludeTags);
                    }

                    if (newData.searchData.filterByLeadZip !== 'undefined') {
                        filterDataObject['lead_zip'] = toRaw(newData.searchData.filterByLeadZip);
                    }

                    if (newData.searchData.filterByNpsScoreOperator !== 'undefined') {
                        filterDataObject['lead_filter_nps_score_operator'] = toRaw(newData.searchData.filterByNpsScoreOperator);
                    }

                    if (newData.searchData.filterByNpsScore !== 'undefined') {
                        filterDataObject['nps_score'] = toRaw(newData.searchData.filterByNpsScore);
                    }

                    if (newData.searchData.filterByEmailValidation !== 'undefined') {
                        filterDataObject['email_validation_status'] = toRaw(newData.searchData.filterByEmailValidation);
                    }

                    if (newData.searchData.filterEmailValidationDatepicker !== 'undefined') {
                        filterDataObject['validated_date_to'] = toRaw(newData.searchData.filterEmailValidationDatepicker);
                    }

                    if (newData.searchData.filterByOpportunityType !== 'undefined') {
                        filterDataObject['opportunity_type_id'] = toRaw(newData.searchData.filterByOpportunityType);
                    }

                    if (newData.searchData.filterByEmailStatus !== 'undefined') {
                        filterDataObject['email_status'] = toRaw(newData.searchData.filterByEmailStatus);
                    }

                    if (newData.searchData.filterByLastInteractionType !== 'undefined') {
                        filterDataObject['last_interaction_id'] = toRaw(newData.searchData.filterByLastInteractionType);
                    }

                    if (newData.searchData.filterLeadsCustomParams !== 'undefined') {
                        filterDataObject['custom_params_search'] = toRaw(newData.searchData.filterLeadsCustomParams);
                    }

                    if (newData.searchData.filterOrganizationsCustomParams !== 'undefined') {
                        filterDataObject['custom_organization_params_search'] = toRaw(newData.searchData.filterOrganizationsCustomParams);
                    }

                    if (newData.searchData.specialFilterType !== 'undefined') {
                        filterDataObject['special_filter_type'] = toRaw(newData.searchData.specialFilterType);
                    }

                    if (newData.searchData.rangeOptions !== 'undefined') {
                        filterDataObject['range_options'] = toRaw(newData.searchData.rangeOptions);
                    }

                    if (newData.searchData.switchLastNextActivityDate !== 'undefined') {
                        filterDataObject['switch_last_next_activity_date'] = toRaw(newData.searchData.switchLastNextActivityDate);
                    }

                    if (newData.searchData.emailSmsSequencesTypePeriod !== 'undefined') {
                        filterDataObject['email_sms_sequences_type_period'] = toRaw(newData.searchData.emailSmsSequencesTypePeriod);
                    }

                    this.searchData = filterDataObject;
                } else {
                    this.searchData = newData.searchData;
                }
            } else {
                this.searchData = '';
            }

            this.$store.commit('setFilterData', toRaw(this.searchData));

            this.applyFilter();
        },
        async updateOppStats (newData, originalData) {
            if (typeof newData !== 'undefined') {
                let leadIdsString = '';

                _.each(this.LeadsGridInfoData, function(leadInfo, index) {
                    leadIdsString = leadIdsString.concat(leadInfo.id, ",");
                });

                const resultStats = await this.$store.dispatch('getLeadStatsGridData', {'router':this.$router, 'leadIdsString' : leadIdsString});
            }
        },
        activeMassAction  (newData, originalData) {
            if (newData == '0') {
                this.$store.commit('setIsMassActionActive', false);
            } else {
                this.$store.commit('setIsMassActionActive', true);
            }
        }

    },
    methods: {
        async applyFilter(type) {

            let allowFilter = true;

            if (typeof type !== "undefined") {
                if (type === 'firstLoad') {
                    this.loadedScreen = true;

                    const resultDefaultPreset = await this.$store.dispatch('getLeadFilterDefaultPreset', {
                        'router': this.$router
                    });

                    if (typeof resultDefaultPreset.isDefault !== 'undefined' && parseInt(resultDefaultPreset.isDefault) === 1) {
                        allowFilter = false;
                        this.$store.commit('setDefaultPresetEnabled', resultDefaultPreset);
                    }

                    const table = document.getElementById('leads-grid-table');
                    this.initialScrollBarSize = table.offsetWidth;
                    this.currentScrollBarSize = table.offsetWidth;
                }
            }

            if (allowFilter === true) {

                const result = await this.$store.dispatch('getLeadGridData', {
                    'router': this.$router,
                    'searchData': this.filterData
                });
                if (result.status === 'error') {
                    showMessage('Please re-login', true, 3000);
                } else {
                    this.loadedScreen = true;
                }

                let formattedStagesList = [];
                for (const [key, value] of Object.entries(result.stages)) {
                    formattedStagesList.push({'id': key, 'label': value});
                }

                let formattedGroupsList = [];
                for (const [key, value] of Object.entries(result.groups)) {
                    formattedGroupsList.push({'id': key, 'label': value});
                }

                let formattedLeadTypesList = [];
                for (const [key, value] of Object.entries(result.types)) {
                    formattedLeadTypesList.push({'id': key, 'label': value});
                }

                this.stages = formattedStagesList;
                this.customerGroups = formattedGroupsList;
                this.leadTypes = formattedLeadTypesList;

                this.userTimezoneOffset = result.userTimezoneOffset;

                this.newPresetName = '';
                this.tableColumnOrderName = result['tableColumnsInfo']['tableColumnOrderName'];
                this.userPresetsList = result['tableColumnsInfo']['userPresetsList'];
                this.presetId = result['tableColumnsInfo']['presetId'];
                this.restrictColumnEditing = result['tableColumnsInfo']['restrictColumnEditing'];

                this.listOfDefaultColumnNamesOrder = result['tableColumnsInfo']['listOfDefaultColumnNamesOrder'];
                let columnHeaders = result['tableColumnsInfo']['columnHeaders'],
                    definedColumnOrder = result['tableColumnsInfo']['definedColumnOrder'];

                let columnHeadersList = {},
                    self = this,
                    options = [];

                _.each(columnHeaders, function (columnHeader, index) {
                    if (typeof columnHeader.skipVUETranslator === 'undefined') {
                        columnHeader.message = self.$t('message.' + columnHeader.message);
                    }

                    columnHeadersList[index] = columnHeader;
                    if (columnHeader.editable) {
                        options.push(columnHeader);
                    }
                });

                if (this.userPresetsList[this.presetId]['is_default'] == '1') {
                    this.presetDefault = true;
                }

                this.columnsHeaders = columnHeadersList;
                this.options = options;

                _.each(definedColumnOrder, function (columnHeader, index) {
                    self.columnSelectionModel[index] = columnHeaders[columnHeader];
                    self.listOfDefaultColumnNamesOrder[index] = columnHeader;
                });

                let leadIdsString = '';

                _.each(this.LeadsGridInfoData, function (leadInfo, index) {
                    leadIdsString = leadIdsString.concat(leadInfo.id, ",");
                });

                this.processPreset();
                this.$store.commit('setActiveGridTablePreset', this.presetId);

                this.$store.commit('setUpdateOppStats', Date.now());
            }

        },
        recordRecentlyViewed(id)
        {
            const resultStats = this.$store.dispatch('logRecentlyViewed', {'router':this.$router, 'id':id, 'type':'lead'});
            this.goToLeadDetailsScreen(id);
        },
        openLeadInNewTab(id)
        {
          const resultStats = this.$store.dispatch('logRecentlyViewed', {'router':this.$router, 'id':id, 'type':'lead'});
          window.open(window.location.href+'#lead/'+id+'?tabName=timeline');
        },
        processPhoneMobileCountryCodesSelectors()
        {
            let self = this;

            _.each(this.LeadsGridInfoData, function(leadInfo, index) {
                if (typeof self.leadsGridAdditionalInfoData.mobileMasks[leadInfo.lead_mobile_country_code] !== 'undefined') {
                    $(document).find('#lead-edit-attribute-mobile-'+leadInfo.id).mask(self.leadsGridAdditionalInfoData.mobileMasks[leadInfo.lead_mobile_country_code].mask_value, {autoclear: false});
                } else {
                    $(document).find('#lead-edit-attribute-mobile-'+leadInfo.id).mask('(999) 999 9999', {autoclear: false});
                }
            });
        },
        async goToLeadDetailsScreen(id, tabName, subTabName)
        {
            let openTabName = tabName || '',
                openSubTabName = subTabName || '';

            if (openTabName !== '') {
                this.$router.push({ name: 'lead', params: {'id': id}, query:{'tabName': openTabName}});
            } else if (openSubTabName !== '') {
                this.$router.push({ name: 'lead', params: {'id': id}, query:{'subTabName': openSubTabName}});
            } else {
                this.$router.push({name: 'lead', params: {'id': id}, query: {'tabName': 'timeline'}});
            }
        },
        async deleteLead(leadId)
        {
            let self = this;
            showConfirm(this.$t('message.areYouSureWantToDeleteLead'), async () => {
                const result = await this.$store.dispatch('deleteLead', {'router':this.$router, 'leadId':leadId});
                if (result.error == '1') {
                    showMessage(result.message, true, 2000);
                    this.formProcessing = false;
                    return false;
                } else {
                    showMessage(result.responseText.message, false, 2000);
                    self.applyFilter();
                }
            }, async () => {

            });
        },
        async deleteAndMarkAsSpamLead(leadId)
        {
            let self = this;
            showConfirm(this.$t('message.areYouSureWantToDeleteLeadAndMarkAsSpam'), async () => {
                const result = await this.$store.dispatch('deleteAndMarkAsSpamLead', {'router':this.$router, 'leadId':leadId});
                if (result.error == '1') {
                    showMessage(result.message, true, 2000);
                    this.formProcessing = false;
                    return false;
                } else {
                    showMessage(result.responseText.message, false, 2000);
                    self.applyFilter();
                }
            }, async () => {

            });
        },
        headerTableChanged(event, columnIndex){
            let self = this;

            this.listOfDefaultColumnNamesOrder[columnIndex] = event.name;
            this.columnsModified = true;
        },
        async showCallDialog(leadId, index){
            let data = toRaw(this.LeadsGridInfoData[index]);
            let self = this;
            this.displayCallDialog = true;
            this.activeDialogId = leadId;
            this.callDialogLeadName = data['lead_first_name'] + ' ' +data['lead_last_name'];
            this.callDialogCountryCodeMobile = data['lead_mobile_country_code'];
            this.callDialogCountryCodeDesktop = data['lead_phone_country_code'];
            this.callDialogCountryCodeChosen = this.callDialogCountryCodeMobile;
            this.callDialogMobile = data['lead_mobile'];
            this.callDialogDesktop = data['lead_desktop'];
            this.callDialogNumber = this.callDialogMobile;

            setTimeout(() =>  self.processDialogMobilePhoneMask(leadId),  300);
        },
        processDialogMobilePhoneMask(leadId)
        {
            if (this.callDialogDeviceTo === 'mobile') {
                if (typeof this.leadsGridAdditionalInfoData.mobileMasks[this.callDialogCountryCodeChosen] !== 'undefined') {
                    $(document).find('#call-lead-number-'+leadId).mask(this.leadsGridAdditionalInfoData.mobileMasks[this.callDialogCountryCodeChosen].mask_value, {autoclear: false});
                } else {
                    $(document).find('#call-lead-number-'+leadId).mask('(999) 999 9999', {autoclear: false});
                }
            } else {
                if (typeof this.leadsGridAdditionalInfoData.desktopMasks[this.callDialogCountryCodeChosen] !== 'undefined') {
                    $(document).find('#call-lead-number-'+leadId).mask(this.leadsGridAdditionalInfoData.desktopMasks[this.callDialogCountryCodeChosen].mask_value, {autoclear: false});
                } else {
                    $(document).find('#call-lead-number-'+leadId).mask('(999) 999 9999', {autoclear: false});
                }
            }

        },
        async callFromWindow(leadId){
            const result = await this.$store.dispatch('callLead', {
                'router':this.$router,
                'leadId':leadId,
                'leadCallCountryCode':this.callDialogCountryCodeChosen,
                'leadCallNumber':this.callDialogNumber,
                'callFromDeviceType':this.callDialogDeviceFrom,
            });

            if (result.error == '1') {
                showMessage(result.responseText, true, 2000);
                return false;
            } else {
                showMessage(result.responseText, false, 2000);
                this.closeCallDialog(leadId);
            }
        },
        callDialogDeviceToChange(leadId)
        {
            let self = this;

            if (this.callDialogDeviceTo === 'mobile') {
                this.callDialogNumber = this.callDialogMobile;
            } else {
                this.callDialogNumber = this.callDialogDesktop
            }

            setTimeout(() =>  self.processDialogMobilePhoneMask(leadId),  100);
        },
        callDialogCountryCodeFromChosen(leadId)
        {
            this.processDialogMobilePhoneMask(leadId);
        },
        changeCallDialogCountryCode(leadId)
        {
            this.processDialogMobilePhoneMask(leadId);
        },
        closeCallDialog(leadId)
        {
            this.displayCallDialog = false;
            this.activeDialogId = 0;
        },
        changeMassAction: function(e) {
            let activeMassAction = e.target.value;
            if (activeMassAction != 0 && Object.keys(this.checkedItems).length === 0) {
                showMessage(this.$t('message.missingCheckedItems'), true, 3000);
                this.$store.commit('setActiveMassAction', '0');
                e.target.value = '0';
            } else {
                this.$store.commit('setActiveMassAction', activeMassAction);
            }
        },
        addRemoveItem: function(e, itemKey) {
            if (e.target.checked) {
                this.addCheckedItem(itemKey);
            } else {
                this.removeCheckedItem(itemKey);
            }

            this.forceUpdate();
        },
        async getLeadOrganizations(query)
        {
            if (query.length < 3) {
                return [];
            }

            const result = await this.$store.dispatch('getLeadOrganizations', {'router':this.$router, 'searchTerm':query});

            if (result.error == '1') {
                return [];
            }

            let results = [],
                self = this;

            $.map(result, function(el) {
                if (typeof el.organization_name !== 'undefined') {
                    results.push(self.unescapeValue(el.organization_name));
                }
            });

            return results;
        },
        async getLeadSources(query)
        {
            if (query.length < 3) {
                return [];
            }

            const result = await this.$store.dispatch('getLeadSources', {'router':this.$router, 'searchTerm':query});

            if (result.error == '1') {
                return [];
            }

            let results = [];

            $.map(result, function(el) {
                if (typeof el.source_name !== 'undefined') {
                    results.push(el.source_name);
                }
            });

            return results;
        },
        async updateProp(event, index, elementName){
            let newValue = event.target.value;

            if (typeof this.LeadsGridInfoData[index][elementName] ===  'undefined') {
                return false;
            }

            let data = toRaw(this.LeadsGridInfoData[index]);
            let oldValue = data[elementName];
            let leadId = data['id'];
            let self = this;

            if (oldValue === newValue || (oldValue === null && newValue === '')) {
                return false;
            }

            data[elementName] = newValue;

            const result = await this.$store.dispatch('updateParam', {'router':this.$router, 'id':leadId, 'data':data});

            if (parseInt(result.error) === 1) {
                if (typeof result.responseText.duplicatedLeadEmail !== 'undefined' || typeof result.responseText.duplicatedLeadPhone !== 'undefined' || typeof result.responseText.duplicatedLeadMobile !== 'undefined') {
                    showConfirm(result.responseText.message + ' ' + this.$t('message.areYouSureWantToMergeBothRecords'), async () => {
                        const mergeResult = await self.processMergeLeads(result.responseText.mergeToId, result.responseText.mergeBasedOn, data, elementName, newValue, oldValue);

                        if (parseInt(mergeResult.error) === 1) {
                            delete data['mergeRecordWithId'];
                            delete data['mergeBasedOn'];
                            this.LeadsGridInfoData[index][elementName] = oldValue;
                            data = structuredClone(toRaw(this.LeadsGridInfoData));
                            this.$store.commit('setLeadGridInfo', data);
                        } else {
                            this.LeadsGridInfoData[index][elementName] = newValue;
                            data = structuredClone(toRaw(this.LeadsGridInfoData));
                            this.$store.commit('setLeadGridInfo', data);
                            window.location = $('#website_url').val() + 'dashboard/leads/#lead/' + result.responseText.mergeToId;
                        }
                    }, async () => {
                        self.LeadsGridInfoData[index][elementName] = oldValue;
                        data = structuredClone(toRaw(self.LeadsGridInfoData));
                        this.$store.commit('setLeadGridInfo', data);
                        return false;
                    });
                } else {
                    showMessage(result.message, true, 3000);
                    return false;
                }
            } else {
                this.LeadsGridInfoData[index][elementName] = newValue;
                data = structuredClone(toRaw(this.LeadsGridInfoData));
                this.$store.commit('setLeadGridInfo', data);
                showMessage(result.responseText.message, false, 2000);
            }
        },
        async processMergeLeads (mergeToIdParam, mergeBasedOnParam, data, elementName, newValue, oldValue) {
            data['mergeRecordWithId'] = mergeToIdParam;
            data['mergeBasedOn'] = mergeBasedOnParam;

            const result = await this.$store.dispatch('updateParam', {
                'router':this.$router,
                'id':data['id'],
                'data':data
            });

            return result;
        },
        async saveColumnOrder(type)
        {
            let tableColumnOrder = [],
                newPresetName = this.newPresetName,
                presetId = '';

            if (type === 'update') {
                presetId = this.presetId;
                if (this.restrictColumnEditing == '1' && this.presetId == '0') {
                    return false;
                }
            } else {
                if (newPresetName === '') {
                    showMessage(this.$t('message.pleaseSpecifyPresetName'), true, 1500);
                    return false;
                }
            }

            _.each(this.columnSelectionModel, function(columnHeader, index) {
                if (typeof columnHeader !== 'undefined') {
                    tableColumnOrder[index] = columnHeader.name;
                }
            });

            showConfirm(this.$t('message.areYouSure'), async () => {
                const result = await this.$store.dispatch('saveColumnTableOrder', {'router':this.$router, 'userId':this.selectedUserId, 'tableName':this.tableColumnOrderName, 'tableColumnOrder':tableColumnOrder, 'presetName':newPresetName, 'presetId':presetId});
                if(result.status === 'error') {
                    showMessage(result.message, true, 3000);
                    return false;
                }

                this.applyColumnOrderToAllUsers = false;
                this.columnsModified = false;
                this.applyFilter();
            });
        },
        async discardColumnOrder(){
            this.columnsModified = false;
            this.loadPreset();
        },
        async markAsDefault(event)
        {
            let isChecked = event.target.checked,
                self = this;

            if (isChecked === true) {
                showConfirm(this.$t('message.areYouSure'), async () => {
                    const result = await this.$store.dispatch('updatePreset', {'router':this.$router, 'id': this.presetId, 'isDefault':'1', 'tableName':this.tableColumnOrderName});
                    this.applyFilter();

                }, function(){
                    self.presetDefault = false;
                });
            } else {
                showConfirm(this.$t('message.areYouSureDefaultPreset'), async () => {
                    const result = await this.$store.dispatch('updatePreset', {'router':this.$router, 'id': this.presetId, 'isDefault':'0', 'tableName':this.tableColumnOrderName});

                    this.applyFilter();
                }, function(){
                    self.presetDefault = true;
                });
            }
        },
        async deletePreset()
        {
            if (this.presetId == '0') {
                return false;
            }

            showConfirm(this.$t('message.areYouSure'), async () => {
                const result = await this.$store.dispatch('deletePreset', {'router':this.$router, 'id': this.presetId});

                if(result.status === 'error') {
                    showMessage('Please re-login', true, 3000);
                } else {
                    this.$store.commit('setActiveGridTablePreset', '');
                    showMessage(this.$t('message.leadPresetDeleted'), false, 1500);
                    this.applyFilter();
                }
            });
        },
        async processPreset()
        {
            if (this.activeGridTablePreset) {
                this.presetId = this.activeGridTablePreset;
                this.loadPreset();
            }
        },
        async loadPreset()
        {
            let userPresetsList = this.userPresetsList,
                self = this,
                presetId = this.presetId,
                fieldsData = userPresetsList[presetId]['fields_data'],
                columnHeaders = this.columnsHeaders;

            if (parseInt(this.userPresetsList[presetId]['is_default']) === 1) {
                this.presetDefault = true;
            } else {
                this.presetDefault = false;
            }

            this.$store.commit('setActiveGridTablePreset', presetId);

            _.each(fieldsData, function(columnHeader, index) {
                self.columnSelectionModel[index] = columnHeaders[columnHeader];
                self.listOfDefaultColumnNamesOrder[index] = columnHeader;
            });
        },
        addCheckedItem: function(itemKey) {
            let currentItems = this.checkedItems;
            if (_.isNull(currentItems)) {
                currentItems = {};
            }
            currentItems[itemKey] = itemKey;
            this.$store.commit('setCheckedItems', currentItems);
            this.$store.commit('setAllCheckedItemsTracking', {'items': currentItems});
        },
        removeCheckedItem: function(itemKey){
            let currentItems = this.checkedItems;
            if (currentItems !== null && currentItems.hasOwnProperty(itemKey)) {
                delete currentItems[itemKey];
                this.$store.commit('setCheckedItems', currentItems);
                this.$store.commit('setAllCheckedItemsTracking', {'items': currentItems});
            }
        },
        isCheckedItem: function(itemKey){
            let currentItems = this.checkedItems;

            if (currentItems !== null && currentItems.hasOwnProperty(itemKey)) {
                return true;
            }
            return false;
        },
        checkRemoveAllItemsOnPage: function(e)
        {
            let currentCheckedItems = this.checkedItems,
                leadGridInfo = this.LeadsGridInfoData;

            if (e.target.checked && leadGridInfo.length > 0) {
                leadGridInfo.forEach(function(leadGridInfo) {
                    currentCheckedItems[leadGridInfo.id] = leadGridInfo.id;
                });

            } else {
                leadGridInfo.forEach(function(leadGridInfo) {
                    delete currentCheckedItems[leadGridInfo.id];
                });
            }

            this.$store.commit('setCheckedItems', currentCheckedItems);
            this.$store.commit('setAllCheckedItemsTracking', {'items': currentCheckedItems});
            this.forceUpdate();
        },
        isAllChecked() {
            let currentCheckedItems = this.checkedItems,
                leadGridInfo = toRaw(this.LeadsGridInfoData),
                allKeyExists = true;

            leadGridInfo.forEach(function(leadGridInfo) {
                if (!currentCheckedItems.hasOwnProperty(leadGridInfo.id)) {
                    allKeyExists = false;
                }
            });

            return allKeyExists;
        },
        forceUpdate() {
            // ...
            this.$forceUpdate();  // Notice we have to use a $ here
            // ...
        },
        getParams(pathParams) {
            let result = {},
                tmpData = [];

            pathParams
                .split("&")
                .forEach(function (item) {
                    tmpData = item.split("=");
                    if (tmpData[0] !== '') {
                        result[decodeURIComponent(tmpData[0])] = decodeURIComponent(tmpData[1]);
                    }
                });
            return result;
        }

    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        let urlParamsString = window.location.search;

        if (urlParamsString !== '' && urlParamsString.indexOf('?') > -1) {
            this.loadedScreen = true;
        } else {
            this.applyFilter('firstLoad');
        }


    },
    async updated() {
        this.$nextTick(function () {
            this.processPhoneMobileCountryCodesSelectors();
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }

            const table = document.getElementById('leads-grid-table');
            const tableWidth = table.offsetWidth;
            this.scrollBarStyle = 'width:'+tableWidth+'px;';
            this.currentScrollBarSize = tableWidth;

            $('.opportunities-block-scroll').on('scroll', function (e) {
                $('#leads-grid-table-dashboard-table-scroll').scrollLeft($('.opportunities-block-scroll').scrollLeft());
            });

            $('#leads-grid-table-dashboard-table-scroll').on('scroll', function (e) {
                $('.opportunities-block-scroll').scrollLeft($('#leads-grid-table-dashboard-table-scroll').scrollLeft());
            });
        })
    }
}
