import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import moment from 'moment';
import {timelinetab} from '../../timelinetab';
import {profiletab} from '../../profiletab';
import {opportunitiestab} from '../../opportunitiestab';
import {emailsmssequencetab} from '../../emailsmssequencetab';
import {additionalinfotab} from '../../additionalinfotab';
import {notessubtab} from '../../notessubtab';
import {tasksubtab} from '../../tasksubtab';
import {meetingsubtab} from '../../meetingsubtab';
import {emailsubtab} from '../../emailsubtab';
import {smssubtab} from '../../smssubtab';
import {callsubtab} from '../../callsubtab';
import {opportunitysubtab} from '../../opportunitysubtab';
import {documentssubtab} from '../../documentssubtab';
import {customsubtab} from '../../customsubtab';
import {toRaw} from "vue";

import c3 from 'c3';
import * as d3 from "d3";
import "c3/c3.css";

export default {
    data () {
        return {
            loadedScreen: false,
            websiteUrl: $('#website_url').val(),
            localeMapping: localeMapping,
            locale: $('#dashboard-system-language').val(),
            leadId: 0,
            activeTab:'',
            activeSubTab:'',
            customSubTabsList:[],
            customTabsObject:{},
            activeCustomTabId:'',
            defaultActiveTabName:'timeline',
            defaultActiveSubTabName:'notes',
            additionalNavigationData:[],
            searchable:true,
            leadInfoSavingProcessing:false,
            temporaryErrorsFields:[],
            allowedTabNames:['timeline', 'profile', 'opportunities', 'emailSmsSequence', 'additionalInfo'],
            allowedSubTabNames:['notes', 'task', 'meeting', 'email', 'sms', 'call', 'opportunity', 'documents'],
            stages:{},
            customerGroups:{},
            leadTypes:{},
            showFullNameDetailsBlock:false,
            newLeadTagName:'',
            leadTagsListModel:[],
            leadTagIds: {},
            processingNewTag:false,
            limitedAccess:0,
            processingNpsRequest:false,
            componentKeyReviewRequestDateFb:0,
            componentKeyReviewRequestDateGmb:0,
            reviewRequestDateFb:'',
            reviewRequestDateGmb:'',
            componentKey:0,
            displaySocialServiceInfoBlockFlag: false,
            activeServiceInfoId:0,
            activeServiceInfoLinkValue:'',
            leadOpportunityStatNewCount:0,
            leadOpportunityStatNewAmount:0,
            leadOpportunityStatLostCount:0,
            leadOpportunityStatLostAmount:0,
            leadOpportunityStatWonCount:0,
            leadOpportunityStatWonAmount:0,
            leadOpportunityRatio:0,
            leadFirstWonOpportunityDate:0,
            oppportunitySubTabKey:0,
            generateAiSentimentProcessing:false,
            showSentimentChart:false,
            sentimentChart:null,
            aiSentimentCronPath:''
        }
    },
    components: {
        timelinetab:timelinetab,
        profiletab:profiletab,
        opportunitiestab:opportunitiestab,
        emailsmssequencetab:emailsmssequencetab,
        additionalinfotab:additionalinfotab,
        notessubtab:notessubtab,
        tasksubtab:tasksubtab,
        meetingsubtab:meetingsubtab,
        emailsubtab:emailsubtab,
        smssubtab:smssubtab,
        callsubtab:callsubtab,
        opportunitysubtab:opportunitysubtab,
        documentssubtab:documentssubtab,
        customsubtab:customsubtab,
    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
            isAfterDate: 'isAfterDate',
            isValidDate: 'isValidDate',
            truncateText: 'truncateText',
            additionalInfo:'getAdditionalInfoDetailedScreen',
            sortByColumn: 'sortByColumn',
            changeFilter: 'getChangeFilter',
            unescapeValue:'unescapeValue',
            toCurrency:'toCurrency',
            changeMainTabRemote:'getChangeMainTabRemote',
            changeSubTabRemote:'getChangeSubTabRemote',
            leadData:'getDetailedScreenLeadData',
        }),
    },
    watch: {
        changeMainTabRemote(newData, originalData) {
            if (typeof newData.tabName !== 'undefined' && newData.tabName !== '') {
                if (typeof newData.visitPageNumber !== 'undefined') {
                    this.changeVisitsTab(newData.tabName, newData.visitPageNumber);
                } else {
                    this.changeTab(newData.tabName);
                }
            }
        },
        changeSubTabRemote(newData, originalData) {
            if (typeof newData.tabName !== 'undefined' && newData.tabName !== '') {
                this.changeSubTab(newData.tabName, true);
            }
        },
        showSentimentChart(newVal) {
            if (newVal && !this.sentimentChart) {
                this.$nextTick(() => {
                    this.createGauge();
                });
            }
        }
    },
    methods: {
        backToGrid() {
            this.$router.push({ name: 'grid'});
        },
        changeTab(activeTabName){
            this.activeTab = activeTabName;
            this.$router.push({ name: 'lead', params: {'id': this.leadId },  query: {tabName: activeTabName, subTabName:this.activeSubTab}});
        },
        changeVisitsTab(activeTabName, visitPageNumber){
            this.activeTab = activeTabName;
            this.$store.commit('setPaginationData',
                {
                    profileLog: {
                        currentPage: parseInt(visitPageNumber) +1,
                        itemsPerPage: 10,
                        totalItems: 0,
                        visiblePages: 4
                    }
                });

            this.$router.push({ name: 'lead', params: {'id': this.leadId },  query: {tabName: activeTabName, subTabName:this.activeSubTab}});
        },
        changeSubTab(activeSubTabName, forceOpen){
            let forceOpenFlag = forceOpen || false;

            if (this.activeSubTab === activeSubTabName && forceOpenFlag !== true) {
                this.activeSubTab = '';
            } else {
                if (forceOpenFlag === true) {
                    if (activeSubTabName === 'opportunity') {
                        this.oppportunitySubTabKey += 1;
                    }

                    this.activeSubTab = activeSubTabName;
                } else {
                    this.activeSubTab = activeSubTabName;
                }
            }

            this.activeCustomTabId = '';

            if (this.activeSubTab === '') {
                this.$router.push({ name: 'lead', params: {'id': this.leadId },  query: {tabName: this.activeTab}});
            } else {
                this.$router.push({ name: 'lead', params: {'id': this.leadId },  query: {tabName: this.activeTab, subTabName:activeSubTabName}});
            }
        },
        changeCustomSubTab(activeSubTabName, customTabId){

            if (this.activeSubTab === activeSubTabName) {
                this.activeSubTab = '';
                this.activeCustomTabId = '';
            } else {
                this.activeSubTab = activeSubTabName;
                this.activeCustomTabId = customTabId;
            }

            if (this.activeSubTab === '') {
                this.$router.push({ name: 'lead', params: {'id': this.leadId },  query: {tabName: this.activeTab}});
            } else {
                this.$router.push({ name: 'lead', params: {'id': this.leadId },  query: {tabName: this.activeTab, subTabName:activeSubTabName}});
            }
        },
        setAllTabs(){
            this.$router.push({ name: 'lead', params: {'id': this.leadId },  query: {tabName: this.activeTab, subTabName:this.activeSubTab}});
        },
        getParams(pathParams) {
            let result = {},
                tmpData = [];

            pathParams
                .split("&")
                .forEach(function (item) {
                    tmpData = item.split("=");
                    if (tmpData[0] !== '') {
                        result[decodeURIComponent(tmpData[0])] = decodeURIComponent(tmpData[1]);
                    }
                });
            return result;
        },
        switchShowFullNameDetailsBlock()
        {
            if (this.showFullNameDetailsBlock === true) {
                this.showFullNameDetailsBlock = false;
            } else {
                this.showFullNameDetailsBlock = true;
            }
        },
        async addNewTag()
        {
            if (this.processingNewTag === true) {
                return false;
            }

            this.processingNewTag = true;

            let newTagName = this.newLeadTagName.trim(),
                tagIds = [],
                newLeadTagId = '',
                existingTagId = '',
                newTagInfo = [],
                tagElementObject = {},
                newTagId = [];

            this.leadTagsListModel.forEach((element) => {
                tagIds.push(element.id);
            });

            if (newTagName === '' && Object.keys(tagIds).length === 0) {
                showMessage(this.$t('message.tagNothingToAssign'), false, 2000);
                this.processingNewTag = false;
                return false;
            }

            if (newTagName !== '') {
                const result = await this.$store.dispatch('getLeadTag', {'router':this.$router, 'tagName':newTagName});
                if (parseInt(result.error) === 1) {

                } else if (typeof result.id !== 'undefined'){
                    existingTagId = result.id;
                    newTagId.push(existingTagId);
                    await this.attachLeadTags(newTagId);
                    this.leadTagIds[existingTagId] = existingTagId;
                }
            }

            if (!existingTagId) {
                const resultNewTag = await this.$store.dispatch('addNewLeadTag', {
                    'router':this.$router, 'leadId':this.leadId, 'tagName':newTagName, 'label':newTagName
                });

                if (parseInt(resultNewTag.error) === 1) {

                } else {
                    newTagInfo = resultNewTag.responseText.tagInfo;
                    newLeadTagId = newTagInfo.id;
                    tagElementObject = {'id':newLeadTagId, 'label':newTagInfo.label,'tag_name':newTagInfo.tagName};
                    this.additionalInfo.tags[newLeadTagId] = tagElementObject;
                    newTagId.push(newLeadTagId);
                    await this.attachLeadTags(newTagId);
                    this.leadTagIds[newLeadTagId] = newLeadTagId;
                }
            }

            if (Object.keys(tagIds).length > 0) {
                await this.attachLeadTags(tagIds);
            }

            this.leadTagsListModel = [];
            this.newLeadTagName = '';

            showMessage(this.$t('message.tagsHaveBeenAssigned'), false, 2000);

            this.processingNewTag = false;
        },
        async attachLeadTags(tagIds)
        {
            for (const tagId of tagIds) {
                const result = await this.$store.dispatch('attachTagToLead', {
                    'router': this.$router,
                    'leadId': this.leadId,
                    'tagId': tagId
                });

                this.leadTagIds[tagId] = tagId;
            }
        },
        async unassignTag(tagId){
            let self = this;

            showConfirm(this.$t('message.areYouSureYouWantToDelete'), async () => {
                const result = await this.$store.dispatch('unAttachTagToLead', {
                    'router': this.$router, 'leadId': this.leadId, 'tagId': tagId
                });

                if (result === null) {
                    delete self.leadTagIds[tagId];
                } else {
                    showMessage(result.responseText.message, false, 2000);
                }
            }, async () => {
                return false;
            });
        },
        async sendNpsReviewRequest(sendRequestAgain)
        {
            if (this.processingNpsRequest === true) {
                return false;
            }

            this.processingNpsRequest = true;

            let sendRequestAgainFlag = sendRequestAgain || '';

            const result = await this.$store.dispatch('sendNpsReviewRequestAction', {
                'router': this.$router, 'leadId': this.leadId, 'sendRequestAgain':sendRequestAgainFlag
            });

            if (parseInt(result.error) === 1) {
                showMessage(result.responseText.message, true, 3000);
                this.processingNpsRequest = false;
            } else {
                if (typeof result.responseText.leadData !== 'undefined') {
                    let leadData =  Object.assign({}, this.leadData);
                    leadData['reviewScore'] = result.responseText.leadData.reviewScore;
                    leadData['reviewSentAt'] = result.responseText.leadData.reviewSentAt;
                    leadData['reviewReviewedAt'] = result.responseText.leadData.reviewReviewedAt;
                    leadData['reviewStatus'] = result.responseText.leadData.reviewStatus;
                    leadData['reviewRequestSentAt'] = result.responseText.leadData.reviewRequestSentAt;
                    leadData['reviewRequestReviewedFacebookDate'] = result.responseText.leadData.reviewRequestReviewedFacebookDate;
                    leadData['reviewRequestReviewedGmbDate'] = result.responseText.leadData.reviewRequestReviewedGmbDate;
                    leadData['reviewRequestStatus'] = result.responseText.leadData.reviewRequestStatus;
                    this.$store.commit('setDetailedScreenLeadData', leadData);
                }

                this.processingNpsRequest = false;
                showMessage(result.responseText.message, false, 2000);
            }
        },
        async sendReviewRequest(sendRequestAgain)
        {
            if (this.processingNpsRequest === true) {
                return false;
            }

            this.processingNpsRequest = true;

            let sendRequestAgainFlag = sendRequestAgain || '';

            const result = await this.$store.dispatch('sendReviewRequestAction', {
                'router': this.$router, 'leadId': this.leadId, 'sendRequestAgain':sendRequestAgainFlag
            });

            if (parseInt(result.error) === 1) {
                showMessage(result.responseText.message, true, 3000);
                this.processingNpsRequest = false;
            } else {
                if (typeof result.responseText.leadData !== 'undefined') {
                    let leadData =  Object.assign({}, this.leadData);
                    leadData['reviewScore'] = result.responseText.leadData.reviewScore;
                    leadData['reviewSentAt'] = result.responseText.leadData.reviewSentAt;
                    leadData['reviewReviewedAt'] = result.responseText.leadData.reviewReviewedAt;
                    leadData['reviewStatus'] = result.responseText.leadData.reviewStatus;
                    leadData['reviewRequestSentAt'] = result.responseText.leadData.reviewRequestSentAt;
                    leadData['reviewRequestReviewedFacebookDate'] = result.responseText.leadData.reviewRequestReviewedFacebookDate;
                    leadData['reviewRequestReviewedGmbDate'] = result.responseText.leadData.reviewRequestReviewedGmbDate;
                    leadData['reviewRequestStatus'] = result.responseText.leadData.reviewRequestStatus;

                    this.$store.commit('setDetailedScreenLeadData', leadData);
                }

                this.processingNpsRequest = false;
                showMessage(result.responseText.message, false, 2000);
            }
        },
        async saveReviewRequestManual(selectedDate, reviewPlatform)
        {
            let reviewDate = moment(selectedDate).format('YYYY-MM-DD');

            const result = await this.$store.dispatch('saveReviewRequestManualAction', {
                'router': this.$router, 'leadId': this.leadId, 'reviewPlatform':reviewPlatform, 'reviewDate':reviewDate
            });

            if (parseInt(result.error) === 1) {
                showMessage(result.responseText.message, true, 3000);
            } else {
                showMessage(result.responseText.message, false, 2000);
            }

        },
        async updateLeadParam(event, elementName){
            let newValue = event.target.value;
            let data = toRaw(this.leadData);
            let oldValue = data[elementName];
            let self = this;

            if (elementName === 'use_organization_address') {
                if (parseInt(oldValue) === 1) {
                    newValue = 0;
                } else {
                    newValue = 1;
                }
            }

            if (elementName === 'lead_mobile' || elementName === 'lead_phone') {
                newValue = newValue.replace(/[^0-9.]/g, '');
            }

            if (oldValue === newValue || (oldValue === null && newValue === '')) {
                return false;
            }

            data[elementName] = newValue;

            const result = await this.$store.dispatch('updateParam', {'router':this.$router, 'id':this.leadId, 'data':data});

            if (parseInt(result.error) === 1) {
                if (typeof result.responseText !== 'undefined' && (typeof result.responseText.duplicatedLeadEmail !== 'undefined' || typeof result.responseText.duplicatedLeadPhone !== 'undefined' || typeof result.responseText.duplicatedLeadMobile !== 'undefined')) {
                    showConfirm(result.responseText.message + ' ' + this.$t('message.areYouSureWantToMergeBothRecords'), async () => {
                        const mergeResult = await self.processMergeLeads(result.responseText.mergeToId, result.responseText.mergeBasedOn, data, elementName, newValue, oldValue);

                        if (parseInt(mergeResult.error) === 1) {
                            delete data['mergeRecordWithId'];
                            delete data['mergeBasedOn'];
                            this.leadData[elementName] = oldValue;
                            data =  Object.assign({}, this.leadData);
                            this.$store.commit('setDetailedScreenLeadData', data);
                        } else {
                            this.leadData[elementName] = newValue;
                            data =  Object.assign({}, this.leadData);
                            this.$store.commit('setDetailedScreenLeadData', data);
                            window.location = $('#website_url').val() + 'dashboard/leads/#lead/' + result.responseText.mergeToId;
                        }
                    }, async () => {
                        self.leadData[elementName] = oldValue;
                        data = Object.assign({}, self.leadData);
                        this.$store.commit('setDetailedScreenLeadData', data);
                        return false;
                    });
                } else {
                    showMessage(result.message, true, 3000);
                    return false;
                }
            } else {
                this.leadData[elementName] = newValue;
                if (elementName === 'organization_name') {
                    this.leadData['organization_id']  = result.responseText.model.organizationId;
                }

                data =  Object.assign({}, this.leadData);
                this.$store.commit('setDetailedScreenLeadData', data);
                showMessage(result.responseText.message, false, 2000);
            }
        },
        async processMergeLeads(mergeToIdParam, mergeBasedOnParam, data, elementName, newValue, oldValue) {
            data['mergeRecordWithId'] = mergeToIdParam;
            data['mergeBasedOn'] = mergeBasedOnParam;

            const result = await this.$store.dispatch('updateParam', {
                'router':this.$router,
                'id':data['id'],
                'data':data
            });

            return result;
        },
        async validateLeadEmail()
        {
            const result = await this.$store.dispatch('validateLeadEmail', {
                'router':this.$router,
                'leadId':this.leadId
            });

            if (parseInt(result.error) === 1) {
                showMessage(result.responseText.message, true, 3000);
            } else {
                let emailValidatedDate = result.responseText.leadModel.emailValidatedDate,
                    validateStatus = result.responseText.leadModel.email_validated_status,
                    emailValidatedScore = result.responseText.leadModel.email_validated_score;

                this.leadData['email_validated_status'] = validateStatus;
                this.leadData['emailValidatedDate'] = emailValidatedDate;

                let data =  Object.assign({}, this.leadData);
                this.$store.commit('setDetailedScreenLeadData', data);
                showMessage(result.responseText.message, false, 2000);
            }
        },
        processPhoneMobileCountryCodesSelectors()
        {
            if (typeof this.additionalInfo.mobileMasks[this.leadData.lead_mobile_country_code] !== 'undefined') {
               $(document).find('#lead-edit-attribute-mobile').mask(this.additionalInfo.mobileMasks[this.leadData.lead_mobile_country_code].mask_value, {autoclear: false});
            } else {
               $(document).find('#lead-edit-attribute-mobile').mask('(999) 999 9999', {autoclear: false});
            }

            if (typeof this.additionalInfo.desktopMasks[this.leadData.lead_phone_country_code] !== 'undefined') {
                $(document).find('#lead-edit-attribute-phone').mask(this.additionalInfo.desktopMasks[this.leadData.lead_phone_country_code].mask_value, {autoclear: false});
            } else {
                $(document).find('#lead-edit-attribute-phone').mask('(999) 999 9999', {autoclear: false});
            }

            if (typeof this.additionalInfo.desktopMasks[this.leadData.organization_phone] !== 'undefined') {
                $(document).find('#lead-organization-phone-number-detailed-view').mask(this.additionalInfo.desktopMasks[this.leadData.organization_phone].mask_value, {autoclear: false});
            } else {
                $(document).find('#lead-organization-phone-number-detailed-view').mask('(999) 999 9999', {autoclear: false});
            }

        },
        displaySocialServiceInfoBlock(serviceInfoId)
        {
            if (parseInt(this.activeServiceInfoId) === parseInt(serviceInfoId)) {
                if (this.displaySocialServiceInfoBlockFlag === true) {
                    this.displaySocialServiceInfoBlockFlag = false;
                } else {
                    this.displaySocialServiceInfoBlockFlag = true;
                }
            } else if (parseInt(this.activeServiceInfoId) !== parseInt(serviceInfoId)) {
                this.displaySocialServiceInfoBlockFlag = true;
            }

            if (typeof this.leadData.leadSocialServices[serviceInfoId] !== 'undefined'){
                this.activeServiceInfoLinkValue = this.leadData.leadSocialServices[serviceInfoId];
            }  else {
                this.activeServiceInfoLinkValue = '';
            }

            this.activeServiceInfoId = parseInt(serviceInfoId);
        },
        async changeSocialServiceLink(event, serviceInfoId)
        {
            let newValue = event.target.value;

            const result = await this.$store.dispatch('saveSocialServiceLink', {
                'router': this.$router, 'leadId': this.leadId, 'serviceId':serviceInfoId, 'serviceLink':newValue
            });

            if (parseInt(result.error) === 1) {
                showMessage(result.responseText, true, 3000);
            } else {
                this.leadData.leadSocialServices[serviceInfoId] = newValue;
                this.activeServiceInfoLinkValue = newValue;
                showMessage(result.responseText, false, 2000);
            }
        },
        async getLeadSources(query)
        {

            if (query.length < 3) {
                return [];
            }

            const result = await this.$store.dispatch('getLeadSource', {'router':this.$router, 'searchTerm':query, 'autocomplete':true});

            if (result.error == '1') {
                return [];
            }

            let results = [];

            $.map(result, function(el) {
                if (typeof el.source_name !== 'undefined') {
                    results.push(el.source_name);
                }
            });

            return results;
        },
        async getLeadOrganizations(query)
        {
            if (query.length < 3) {
                return [];
            }

            const result = await this.$store.dispatch('getLeadOrganizations', {'router':this.$router, 'searchTerm':query});

            if (result.error == '1') {
                return [];
            }

            let results = [],
                self = this;

            $.map(result, function(el) {
                if (typeof el.organization_name !== 'undefined') {
                    results.push(self.unescapeValue(el.organization_name));
                }
            });

            return results;
        },
        viewAdditionalInfoShortInfo()
        {
            this.changeTab('additionalInfo');

            let el = $('#lead-detailed-view-statistics-tabs-tab');

            $('body,html').animate({
                scrollTop: $(el).offset().top
            }, 1000);
        },
        goToTimeLineItemLastActivity(type, filterType){
            let el = $('#lead-detailed-view-statistics-tabs-tab'),
                mainType = 'inbound',
                filterSubType = '';

            if (type.match(/outbound/gi) !== null) {
                mainType = 'outbound';
            }

            if (filterType) {
                type = mainType.replace(/_(.*)/gi, '') + '_' + filterType;
            } else {
                type = type.replace(mainType+'_', '');
            }

            if (mainType === 'inbound' && type === 'email') {
                filterSubType = 'received';
            }

            if (type !== '') {
                this.changeTab('timeline');
                setTimeout(() => this.$store.commit('setTimelineLogChangeFilter', {'searchData':
                        {
                            'filterByActionType':mainType, 'filterByType':type,
                            'hash':new Date(), 'switchFilter': true,
                            'filterBySubType':filterSubType
                        }
                }),  100);

                $('body,html').animate({
                    scrollTop: $(el).offset().top
                }, 1000);
            }
            return false;
        },
        goToTimeLineItemNextActivity(type, filterType){
            let el = $('#lead-detailed-view-statistics-tabs-tab'),
                mainType = 'outbound',
                self = this,
                filterSubType = '';

            if (filterType) {
                type = mainType.replace(/_(.*)/gi, '') + '_' + filterType;
            } else {
                type = type.replace(mainType+'_', '');
            }

            if (mainType === 'inbound' && type === 'email') {
                filterSubType = 'received';
            }

            if (type !== '') {
                this.changeTab('timeline');


                $('body,html').animate({
                    scrollTop: $(el).offset().top
                }, 1000);

                setTimeout(() => self.$store.commit('setTimelineLogChangeFilter', {'searchData':{
                    'filterByActionType':mainType, 'filterByType':type,
                    'hash':new Date(), 'switchFilter': true,
                    'filterBySubType':filterSubType
                }
                }),  100);

            }
            return false;
        },
        async changeLeadOwner(event)
        {
            let ownerId = event.target.value,
                data = toRaw(this.leadData);

            const result = await this.$store.dispatch('assignLeadOwner', {
                'router': this.$router, 'leadIds': this.leadId, 'leadOwnerId':ownerId
            });

            if (parseInt(result.error) === 1) {
                showMessage(result.responseText, true, 3000);
            } else {
                data['owner_id'] = ownerId;
                data =  Object.assign({}, this.leadData);
                this.$store.commit('setDetailedScreenLeadData', data);
                showMessage(result.responseText, false, 2000);
            }
        },
        gotoOpportunitiesTab: function(e) {
            let el = $('#lead-detailed-view-statistics-tabs-tab');

            this.changeTab('opportunities');

            $('body,html').animate({
                scrollTop: $(el).offset().top
            }, 1000);
        },
        updateKey() {
            this.componentKey += 1;
        },
        async generateAiSentiment()
        {
            let data = toRaw(this.leadData);

            if (this.generateAiSentimentProcessing === true) {
                return false;
            }

            this.generateAiSentimentProcessing = true;

            const result = await this.$store.dispatch('generateAiSentiment', {
                'router': this.$router, 'leadId': this.leadId
            });

            if (parseInt(result.error) === 1) {
                showMessage(result.responseText, true, 3000);
            } else {
                data['lead_sentiment_summary'] = result.responseText.sentimentData.lead_sentiment_summary;
                data['lead_sentiment_score'] = result.responseText.sentimentData.lead_sentiment_score;
                data =  Object.assign({}, this.leadData);
                this.$store.commit('setDetailedScreenLeadData', data);
                showMessage(result.responseText.message, false, 2000);
            }

            this.generateAiSentimentProcessing = false;
        },
        createGauge() {
            let score = parseFloat(this.leadData.lead_sentiment_score).toFixed(1);
            let columnName = "";
            let self = this;

            if (isNaN(score) || score < 1) {
                columnName = "N/A";
            }
            else if (score >= 1 && score <= 2) columnName = self.$t('message.aiSentimentVeryNegative');
            else if (score > 2 && score <= 4) columnName = self.$t('message.aiSentimentNegative');
            else if (score > 4 && score <= 6) columnName = self.$t('message.aiSentimentNeutral');
            else if (score > 6 && score <= 8) columnName = self.$t('message.aiSentimentPositive');
            else columnName = self.$t('message.aiSentimentVeryPositive')

            this.sentimentChart = c3.generate({
                bindto: this.$refs.sentimentChartContainer,
                data: {
                    columns: [
                        [columnName, parseFloat(this.leadData.lead_sentiment_score).toFixed(1)]
                    ],
                    type: "gauge",
                    color: function(color, d) {
                        if (d === self.$t('message.aiSentimentVeryNegative')) return "#F15C5C";
                        if (d === self.$t('message.aiSentimentNegative')) return "#F4C94C";
                        if (d === self.$t('message.aiSentimentNeutral')) return "#8CC4F7";
                        if (d === self.$t('message.aiSentimentPositive')) return "#4A90E2";
                        return "#7ED321";
                    }
                },
                gauge: {
                    min: 1,
                    max: 10,
                    label: {
                        format: function(value) {
                            let desc = "";
                            if (value < 1) {
                                desc = "";
                                return `${desc}`;
                            }
                            else if (value >= 1 && value <= 2) columnName = self.$t('message.aiSentimentVeryNegative');
                            else if (value > 2 && value <= 4) columnName = self.$t('message.aiSentimentNegative');
                            else if (value > 4 && value <= 6) columnName = self.$t('message.aiSentimentNeutral');
                            else if (value > 6 && value <= 8) columnName = self.$t('message.aiSentimentPositive');
                            else desc = self.$t('message.aiSentimentVeryPositive');
                            return `${value.toFixed(1)}`;
                        }
                    }
                },
                legend: { show: columnName !== "N/A" }, // hide legend if N/A
                size: { height: 150 },
            });

            // Increase legend font size after render
            d3.selectAll('.c3-legend-item text')
                .style('font-size', '14px');

        },
        copyCronPath(param, event)
        {
            event.preventDefault();

            let cronPath = '';

            if (param === 'aiSentimentCronPath') {
                cronPath = this.additionalInfo['aiSentimentCronPath'];
            }

            if (document.queryCommandSupported("copy")) {
                let copyFromEl = $('<textarea/>');
                copyFromEl.text(cronPath);
                $('body').append(copyFromEl);
                copyFromEl.select();
                document.execCommand('copy', true);
                copyFromEl.remove();
                showMessage(this.$t('message.copiedToClipboard'), false, 2000);
            }

            return true;
        }
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.leadId = this.$route.params.id;

        const result = await this.$store.dispatch('getLeadDataInfo', {
            'router': this.$router,
            'id': this.leadId
        });

        if (typeof result.id === 'undefined') {
            this.$router.push({ name: 'grid'});
        } else {
            this.loadedScreen = true;
            this.showSentimentChart = true;

            let self = this;
            let leadTagIds = [];

            console.log(result);

            if (Object.keys(this.leadData.leadOpportunityStats).length > 0) {
                for (const [stageId, statsData] of Object.entries(this.leadData.leadOpportunityStats)) {
                    if (parseInt(stageId) === 1)  {
                        this.leadOpportunityStatLostCount += parseInt(statsData.count);
                        this.leadOpportunityStatLostAmount += parseFloat(statsData.total);
                    } else if (parseInt(stageId) === 100)  {
                        this.leadOpportunityStatWonCount += parseInt(statsData.count);
                        this.leadOpportunityStatWonAmount  += parseFloat(statsData.total);
                        this.leadFirstWonOpportunityDate  = statsData.oppLastChangeDate;
                        if (this.leadFirstWonOpportunityDate == '0000-00-00 00:00:00') {
                            this.leadFirstWonOpportunityDate = statsData.oppCreatedAt;
                        }
                      } else {
                        this.leadOpportunityStatNewCount += parseInt(statsData.count);
                        this.leadOpportunityStatNewAmount += parseFloat(statsData.total);
                      }
                }

                this.leadOpportunityRatio = (((this.leadOpportunityStatWonCount)/(this.leadOpportunityStatNewCount+this.leadOpportunityStatLostCount + this.leadOpportunityStatWonCount))*100).toFixed(2);
            }

            if (this.leadData.reviewRequestReviewedFacebookDate) {
                this.reviewRequestDateFb = this.formatOnlyDate(this.leadData.reviewRequestReviewedFacebookDate);
            }

            if (this.leadData.reviewRequestReviewedGmbDate) {
                this.reviewRequestDateGmb = this.formatOnlyDate(this.leadData.reviewRequestReviewedGmbDate);
            }

            this.limitedAccess = parseInt(result.limitedAccess);

            if (result.tagIds) {
                leadTagIds = result.tagIds.split(',');
            }

            leadTagIds.forEach(function(tagId){
                self.leadTagIds[tagId] = tagId;
            });

            let formattedStagesList = [];
            for (const [key, value] of Object.entries(result.stages)) {
                formattedStagesList.push({'id': key, 'label': value});
            }

            let formattedGroupsList = [];
            for (const [key, value] of Object.entries(result.groups)) {
                formattedGroupsList.push({'id': key, 'label': value});
            }

            let formattedLeadTypesList = [];
            for (const [key, value] of Object.entries(result.types)) {
                formattedLeadTypesList.push({'id': key, 'label': value});
            }

            this.stages = formattedStagesList;
            this.customerGroups = formattedGroupsList;
            this.leadTypes = formattedLeadTypesList;

            if (typeof result.customConfigsTabs !== 'undefined') {
                this.customSubTabsList = result.customConfigsTabs
            }

            if (Object.keys(this.customSubTabsList).length > 0) {
                this.customSubTabsList.forEach(function(customTab){
                    self.allowedSubTabNames.push(customTab.tab_name);
                    self.customTabsObject[customTab.tab_name] = customTab.id;
                });
            }

            if (typeof this.$route.query.tabName !== 'undefined' && this.allowedTabNames.includes(this.$route.query.tabName)) {
                this.activeTab = this.$route.query.tabName;
            } else {
                this.activeTab = this.defaultActiveTabName;
            }

            if (typeof this.$route.query.subTabName !== 'undefined' && this.allowedSubTabNames.includes(this.$route.query.subTabName)) {
                this.activeSubTab = this.$route.query.subTabName;
                if (typeof this.customTabsObject[this.activeSubTab] !== 'undefined') {
                    this.activeCustomTabId = this.customTabsObject[this.activeSubTab];
                }
            } else {
                this.activeSubTab = this.defaultActiveSubTabName;
            }
        }

    },
    async updated() {
        this.$nextTick(function () {
            this.processPhoneMobileCountryCodesSelectors();
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    },
    mounted() {
        let vm = this;
        window.onpopstate = function(event) {
            if (event.state !== null) {
                let pathParams = decodeURI(event.state.current),
                    additionalParams = '',
                    updateNavigation = false;

                const regex = /(\btabName=[\w]*)/i;
                if (pathParams.indexOf('?') > -1 && pathParams.match(regex) && pathParams.match(regex).length >= 1) {
                    additionalParams = vm.getParams(pathParams.match(regex)[0].trim());
                    if (typeof additionalParams.tabName !== 'undefined' && vm.allowedTabNames.includes(additionalParams.tabName)) {
                        vm.activeTab = additionalParams.tabName;
                        updateNavigation = true;
                    }
                }

                const regexSubTab = /(\bsubTabName=[\w]*)/i;
                if (pathParams.indexOf('?') > -1 && pathParams.match(regexSubTab) && pathParams.match(regexSubTab).length >= 1) {
                    additionalParams = vm.getParams(pathParams.match(regexSubTab)[0].trim());
                    if (typeof additionalParams.subTabName !== 'undefined' && vm.allowedSubTabNames.includes(additionalParams.subTabName)) {
                        vm.activeSubTab = additionalParams.subTabName;
                        if (typeof vm.customTabsObject[vm.activeSubTab] !== 'undefined') {
                            vm.activeCustomTabId = vm.customTabsObject[vm.activeSubTab];
                        }
                        updateNavigation = true;
                    }
                }

                if (updateNavigation === true) {
                    vm.setAllTabs();
                }
            }
        }
    }


}
