import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import { isProxy, toRaw } from 'vue';
import moment from "moment";
export default {
    props: ['leadId'],
    data () {
        return {
            loadedScreen: true,
            locale: $('#dashboard-system-language').val(),
            localeMapping: localeMapping,
            websiteUrl: $('#website_url').val(),
            loadedEmailsSmsScreen: false,
            loadedEmailsSmsTable: false,
            subscribeInfo:{},
            subscribeSmsInfo:{},
            sequenceData:[],
            sequenceList:[],
            filterByYear: new Date().getFullYear(),
            filterByMonth: ("0" + (new Date().getMonth() + 1)).slice(-2),
            currentYear:new Date().getFullYear(),
            totalEmailsSent:0,
            totalSmsSent:0,
            totalEmailsDelayed:0,
            totalSmsDelayed:0,
            searchData: {},
            fullMonthName:'',
            processingAssigningSequence:false,
            emailSequenceId:0,
            listOfDays:{},
            listOfWeeks:{},
            dateNow:'',
            currentUserTimeZone:'',
        }
    },
    components: {

    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
            formatTimeDayFullName: 'formatTimeDayFullName',
            formatTimeOnlyWithPartOfTheDay: 'formatTimeOnlyWithPartOfTheDay',
            configDataInfo:'getAdditionalInfoDetailedScreen',
            sortByColumn: 'sortByColumn',
            truncateText: 'truncateText',
            toCurrency:'toCurrency',
            unescapeValue:'unescapeValue',
            additionalInfo:'getAdditionalInfoEmailsSmsLog',
            opportunitiesData: 'getEmailsSmsLogData',
            leadData:'getDetailedScreenLeadData',
            generalAdditionalInfo:'getAdditionalInfoDetailedScreen',
            changeFilter: 'getEmailsSmsLogChangeFilter',
            isNewWeekRow:'isNewWeekRow',
        })
    },
    watch: {
        changeFilter (newData, originalData) {
            if (typeof newData.searchData !== 'undefined') {
                if (isProxy(newData.searchData)) {
                    let filterDataObject = {};

                    if (newData.searchData.filterByYear !== 'undefined') {
                        filterDataObject['fromYear'] = toRaw(newData.searchData.filterByYear);
                    }

                    if (newData.searchData.filterByMonth !== 'undefined') {
                        filterDataObject['fromMonth'] = toRaw(newData.searchData.filterByMonth);
                    }

                    this.searchData = filterDataObject;
                } else {
                    this.searchData = newData.searchData;
                }
            } else {
                this.searchData = {};
            }

            this.$store.commit('setOpportunityFilterData', toRaw(this.searchData));
            this.applyFilter();
        }
    },
    methods: {
        async applyFilter() {

            let fromYear = this.filterByYear,
                fromMonth = this.filterByMonth;

            if (typeof this.filterData !== 'undefined' && typeof this.filterData.fromYear !== 'undefined') {
                fromYear = this.filterData.fromYear;
            }

            if (typeof this.filterData !== 'undefined' && typeof this.filterData.fromMonth !== 'undefined') {
                fromMonth = this.filterData.fromMonth;
            }

            const result = await this.$store.dispatch('getLeadEmailSequenceLogData',
                {
                    'router':this.$router,
                    'leadId':this.leadId,
                    'fromYear':fromYear,
                    'fromMonth':fromMonth
                });

            if (result.error === 1) {
                showMessage(result.message, true, 3000);
            } else {
                console.log(result);
                this.fullMonthName = result.fullMonthName;
                this.currentYear = result.currentYear;
                this.totalEmailsSent = result.totalEmailsSent;
                this.totalSmsSent = result.totalSmsSent;
                this.totalEmailsDelayed = result.totalEmailsDelayed;
                this.totalSmsDelayed = result.totalSmsDelayed;
                this.listOfDays = result.listOfDays;
                this.listOfWeeks = result.listOfWeeks;
                this.dateNow = result.dateNow;
                this.currentUserTimeZone = result.currentUserTimeZone;
                this.loadedEmailsSmsTable = true;
            }
        },
        getListOfYears()
        {
            let currentYear = new Date().getFullYear(),
                fromYear = currentYear - 10,
                toYear = currentYear + 2,
                yearsList = {};

             for (let i = fromYear; i < toYear; i++) {
                 yearsList[i] = i;
             }

             return yearsList;
        },
        async getEmailSequenceData()
        {
            const result = await this.$store.dispatch('getLeadEmailSequenceData',
                {
                    'router':this.$router,
                    'leadId':this.leadId
                });

            if (result.error === 1) {
                showMessage(result.message, true, 3000);
            } else {
                this.subscribeInfo = result.subscribeInfo;
                this.subscribeSmsInfo = result.subscribeSmsInfo;
                this.sequenceList = result.sequenceList;
                if (typeof result.data !== "undefined") {
                    this.sequenceData = result.data;
                } else {
                    this.sequenceData = [];
                }

                this.loadedEmailsSmsScreen = true;
            }
        },
        deleteSequence(sequenceId)
        {
            showConfirm(this.$t('message.emailSmsAreYouSureWantToDelete'), async () => {
                const result = await this.$store.dispatch('deleteLeadEmailSequence', {
                    'router': this.$router, 'leadId': this.leadId, 'sequenceId': sequenceId
                });

                if (result.error === 1) {
                    showMessage(result.message, false, 2000);
                } else {
                    showMessage(result.responseText, false, 2000);
                    this.getEmailSequenceData();
                }
            }, async () => {
                return false;
            });
        },
        async assignEmailSequenceToLead()
        {
            if (this.processingAssigningSequence === true) {
                return false;
            }

            if (!this.emailSequenceId) {
                showMessage(this.$t('message.emailSmsPleaseChooseASequence'), true, 2000);
                this.processingAssigningSequence = false
                return false;
            }

            this.processingAssigningSequence = true;

            const result = await this.$store.dispatch('addLeadEmailSequence', {
                'router': this.$router, 'leadId': this.leadId, 'sequenceId': this.emailSequenceId
            });

            if (result.error === 1) {
                showMessage(result.message, true, 2000);
                this.processingAssigningSequence = false;
            } else {
                showMessage(result.responseText, false, 2000);
                this.processingAssigningSequence = false;
                this.emailSequenceId = 0;
                this.getEmailSequenceData();
            }
        },
        async subscribeUnsubscribeLead(event)
        {
            let sequenceIds = '';

            if (typeof this.subscribeInfo.sequenceIds !== 'undefined') {
                sequenceIds = this.subscribeInfo.sequenceIds;
            }

            if (event.target.checked) {
                showConfirm(this.$t('message.emailSmsAreYouSureWantToUnsubscribe'), async () => {
                    const result = await this.$store.dispatch('unsubscribeEmailSequence', {
                        'router': this.$router, 'leadId': this.leadId, 'sequenceId': sequenceIds
                    });

                    if (result.error === 1) {
                        showMessage(result.message, false, 2000);
                    } else {
                        showMessage(result.responseText, false, 2000);
                    }
                }, async () => {
                    event.target.checked = false;
                    return false;
                });
            } else {
                showConfirm(this.$t('message.emailSmsAreYouSureWantToSubscribe'), async () => {
                    const result = await this.$store.dispatch('subscribeEmailSequence', {
                        'router': this.$router, 'leadId': this.leadId
                    });

                    if (result.error === 1) {
                        showMessage(result.message, false, 2000);
                    } else {
                        showMessage(result.responseText, false, 2000);
                    }
                }, async () => {
                    event.target.checked = true;
                    return false;
                });
            }
        },
        compareDatePrepare(date)
        {
            return moment(date);
        },
        prepareSequenceTypeName(type)
        {
            return type;
        },
        async sequenceToday()
        {
            const result = await this.$store.dispatch('getCurrentMonthAndYearEmailSmsTable', {
                'router': this.$router
            });

            if (result.error === 1) {
                showMessage(result.message, true, 2000);
                return false;
            } else {
                this.filterByYear = result.responseText.year;
                this.filterByMonth = result.responseText.month;
                this.applyFilter();
            }
        },
        async changeSequenceMonth(type)
        {

            let currentMonth = parseInt(this.filterByMonth),
                currentYear = parseInt(this.filterByYear);

            if (type === 'next') {
                if (currentMonth < 12) {
                    currentMonth = currentMonth + 1;
                    if (currentMonth < 10) {
                        currentMonth = '0'+currentMonth;
                    }
                    this.filterByMonth = currentMonth;
                } else {
                    currentYear = currentYear + 1;
                    if (typeof this.getListOfYears()[currentYear] !== 'undefined') {
                        this.filterByYear = currentYear;
                        this.filterByMonth ='01';
                    } else {
                        showMessage(this.$t('message.emailSmsWeDontHaveDataNextYear'), true, 5000);
                        return false;
                    }
                }
            } else {
                if (currentMonth != '01') {
                    currentMonth = currentMonth - 1;
                    if (currentMonth < 10) {
                        currentMonth = '0'+currentMonth;
                    }
                    this.filterByMonth = currentMonth;
                } else {
                    currentYear = currentYear - 1;
                    if (typeof this.getListOfYears()[currentYear] !== 'undefined') {
                        this.filterByYear = currentYear;
                        this.filterByMonth = '12';
                    } else {
                        showMessage(this.$t('message.emailSmsWeDontHaveDataNextYear'), true, 5000);
                        return false;
                    }
                }
            }

            this.applyFilter();

        },
        async testEmailSequenceEmail(sequenceQueueId)
        {
            const result = await this.$store.dispatch('sendCartStatusQueueEmail', {
                'router': this.$router,
                'queueId':sequenceQueueId
            });

            if (result.error === 1) {
                showMessage(result.responseText, true, 2000);
                return false;
            } else {
                showMessage(result.responseText, false, 5000);
            }
        },
        async removeSequence(sequenceId)
        {
            showConfirm(this.$t('message.emailSmsAreYouSureYouWantToDelete'), async () => {
                const result = await this.$store.dispatch('deleteSequence', {
                    'router': this.$router, 'sequenceId': sequenceId
                });

                if (result.error === 1) {
                    showMessage(result.responseText, false, 2000);
                } else {
                    showMessage(result.responseText, false, 2000);
                    this.applyFilter();
                }
            }, async () => {
                return false;
            });
        }
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.getEmailSequenceData();
        this.applyFilter();
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }

            if (typeof tooltip !== 'undefined' && typeof tooltip() === "function") {
                $('.tooltip').tooltip();
            }
        })
    }
}
