import {mapGetters} from 'vuex';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
import { isProxy, toRaw } from 'vue';
import moment from "moment";
export default {
    props: ['leadId', 'customTabId'],
    data () {
        return {
            loadedScreen: true,
            loadedScreenData: false,
            locale: $('#dashboard-system-language').val(),
            localeMapping: localeMapping,
            websiteUrl: $('#website_url').val(),
            customTabField: true,
            customParamDate: {},
            processingCustomAttribute:false
        }
    },
    components: {
        pagination: pagination
    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
            formatTimeOnlyWithPartOfTheDay: 'formatTimeOnlyWithPartOfTheDay',
            configDataInfo:'getAdditionalInfoDetailedScreen',
            sortByColumn: 'sortByColumn',
            truncateText: 'truncateText',
            toCurrency:'toCurrency',
            unescapeValue:'unescapeValue',
            additionalInfo:'getCustomAttrAdditionalSubTabData',
            customAttrData: 'getCustomAttrSubTabData',
            leadData:'getDetailedScreenLeadData',
            generalAdditionalInfo:'getAdditionalInfoDetailedScreen',
            changeCustomParamsSub:'getChangeCustomParamsSub',
        })
    },
    watch: {
        customTabId (customTabId) {
            this.loadData();
        },
        changeCustomParamsSub (newData, originalData) {
            this.loadData();
        }
    },
    methods: {
        async loadData() {

            const result = await this.$store.dispatch('getLeadCustomSubTabData', {'router':this.$router, 'leadId': this.leadId, 'customTabId':this.customTabId});

            if (parseInt(result.error) === 1) {
                showMessage(result.message, true, 3000);
                return false;
            } else {
                this.loadedScreenData = true;
            }
        },
        async updateCustomParam(event, type, customParamId, id, oldValue, index)
        {

            if (this.processingCustomAttribute === true) {
                return false;
            }

            this.processingCustomAttribute = true;

            let value = '';
            let result = {};
            if (type === 'text' || type === 'select' || type === 'radio') {
                value = event.target.value;

                if (type === 'text' && oldValue === value) {
                   return false;
                }
            }

            if (type === 'checkbox') {
                if (event.target.checked) {
                    value = event.target.value;
                }
            }

            if (type === 'date') {
                let dateValue = moment(event).format('YYYY-MM-DD');

                if (dateValue !== 'Invalid date') {
                    value = dateValue;
                }
            }

            if (!id) {
                result = await this.$store.dispatch(
                    'createCustomAttribute', {
                        'router': this.$router,
                        'leadId': this.leadId,
                        'paramId': customParamId,
                        'paramType': type,
                        'paramValue': value,
                    });
            } else {
                result = await this.$store.dispatch(
                    'updateCustomAttribute', {
                        'router': this.$router,
                        'leadId': this.leadId,
                        'paramId': customParamId,
                        'paramType': type,
                        'paramValue': value,
                        'id':id
                    });
            }

            if (parseInt(result.error) === 1) {
                showMessage(result.responseText.message, true, 3000);
                this.processingCustomAttribute = false;
                return false;
            } else {
                showMessage(result.responseText.message, false, 3000);
                this.processingCustomAttribute = false;
                this.$store.commit('setChangeCustomParams', Date.now());
                await this.$store.dispatch('getLeadCustomSubTabData', {
                    'router':this.$router,
                    'leadId': this.leadId,
                    'customTabId':this.customTabId,
                    'skipSpinner':1
                });
            }

        }
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.loadData();
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
