import merge from 'lodash/merge';
import mergeWith from 'lodash/mergeWith';
import isArray from 'lodash/isArray';

let state = {
    messages: [],
    creditBalance: null,
    resetDate: null,
}

const getters = {
    getState: (state) => {
        return state;
    },
};

const actions = {

    getCreditBalance: ({state, rootState, commit}) => {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: "GET",
                url: $('#website_url').val() + 'api/leadsopenai/openaiservicecredits',
                data: {},
                dataType: 'json'
            }).done(function (response) {
                if (parseInt(response.error) === 1) {
                    commit('setState',{creditBalance: 0})
                } else {
                    commit('setState',{creditBalance: response.credits, resetDate: response.resetDate})
                }

                return resolve(response);
            }).fail(async function(response){
                resolve();
            });
        });
    },

    getHistoryAction: ({commit, rootState}, payload = []) => {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: "GET",
                url: $('#website_url').val() + 'api/leadsopenai/openaiservicechat',
                data: {
                    ...payload
                },
                dataType: 'json'
            }).done(function (response) {
                if (parseInt(response.error) === 1) {
                    return resolve(response);
                }
                commit('setState', {messages: response.data});
                return resolve(response);
            }).fail(async function(response){
                resolve();
            });
        });
    },
    postHistoryAction: ({rootState}, payload = []) => {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: "POST",
                url: $('#website_url').val() + 'api/leadsopenai/openaiservicechat',
                data: {
                    ...payload
                },
                dataType: 'json'
            }).done(function (response) {
                console.log(response);
                if(response.error){
                    showMessage(response.message, response.error);
                    return resolve();
                }
                return resolve(response);
            }).fail(async function(response){
                resolve();
            });
        });
    },


};

const mutations = {
    setState: (state, payload) => {
        mergeWith(state, payload, (objValue, srcValue) => {
            if (isArray(objValue)) {
                return srcValue;
            }
        });
    },
}

export default {
    namespaced: true,
    state,
    getters,
    actions,
    mutations
};