import {mapGetters} from 'vuex';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
export default {
    data () {
        return {
            loadedGrid: false,
            loadedDetails:false,
            webhookName: '',
            webhookType:'lead',
            webhookActionType:'creation',
            actionUrl:'',
            configId: 0,
            websiteUrl: $('#website_url').val(),
            localeMapping: localeMapping,
            locale: $('#system-language-webhookurls-config').val(),
            cronPath: '',
        }
    },
    components: {
        pagination: pagination
    },
    computed: {
        configDataInfo: function() {
            return this.$store.getters.getConfigDataInfo;
        },
        getAdditionalInfo: function() {
            return this.$store.getters.getAdditionalInfo;
        }
    },
    methods: {
        async ruleDetails(configId) {

            const result = await this.$store.dispatch('getConfigSavedData', {'router':this.$router, 'configId':configId});

            if(result.status === 'error') {
                showMessage('Please re-login', true, 3000);
            } else {
                this.configId = result.id;
                this.webhookName = result.webhook_name;
                this.webhookType = result.webhook_type;
                this.webhookActionType = result.webhook_action_type;
                this.actionUrl = result.action_url;

                this.loadedGrid = false;
                this.loadedDetails = true;
            }

        },
        async saveConfig(e){
            if (this.webhookName === '') {
                showMessage(this.$t('message.pleaseSpecifyWebhookName'), true, 2000);
                return false;
            }

            if (this.webhookType === '0') {
                showMessage(this.$t('message.pleaseSpecifyWebhookType'), true, 2000);
                return false;
            }

            if (this.webhookActionType === '0') {
                showMessage(this.$t('message.pleaseSpecifyWebhookActionType'), true, 2000);
                return false;
            }

            if (this.actionUrl === '') {
                showMessage(this.$t('message.pleaseSpecifyWebhookEndpoint'), true, 2000);
                return false;
            }

            const result = await this.$store.dispatch('saveConfigData', {
                'webhookName':this.webhookName,
                'webhookType':this.webhookType,
                'webhookActionType':this.webhookActionType,
                'actionUrl':this.actionUrl,
            });

            if (result.error == '1') {
                showMessage(result.message, true, 2000);
                return false;
            } else {
                showMessage(result.message, false, 2000);
                this.resetParams();

                const resultConfigData = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
                if(result.status === 'error') {

                } else {
                    this.loadedGrid = true;
                }
            }
        },
        async updateConfig(configId) {
            if (this.webhookName === '') {
                showMessage(this.$t('message.pleaseSpecifyWebhookName'), true, 2000);
                return false;
            }

            if (this.webhookType === '0') {
                showMessage(this.$t('message.pleaseSpecifyWebhookType'), true, 2000);
                return false;
            }

            if (this.webhookActionType === '0') {
                showMessage(this.$t('message.pleaseSpecifyWebhookActionType'), true, 2000);
                return false;
            }

            if (this.actionUrl === '') {
                showMessage(this.$t('message.pleaseSpecifyWebhookEndpoint'), true, 2000);
                return false;
            }

            const result = await this.$store.dispatch('updateConfigData', {
                'configId':configId,
                'webhookName':this.webhookName,
                'webhookType':this.webhookType,
                'webhookActionType':this.webhookActionType,
                'actionUrl':this.actionUrl,
            });

            if (result.error == '1') {
                showMessage(result.message, true, 2000);
                return false;
            } else {
                showMessage(result.message, false, 2000);
            }
        },
        async deleteConfigItem(configId){
            showConfirm(this.$t('message.areYouSure'), async () => {
                const result = await this.$store.dispatch('deleteConfigRecord', {'id': configId});

                if (result.status === 'error') {
                    showMessage(result.message, true, 2000);
                    return false;
                } else {
                    showMessage(result.message, false, 2000);
                    const resultConfigData = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
                    if(result.status === 'error') {

                    } else {
                        this.loadedGrid = true;
                    }
                }
            });
        },
        backToMainGrid() {
            this.renderGrid()
        },
        async renderGrid()
        {
            const result = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});

            if(result.status === 'error') {
                showMessage('Please re-login', true, 3000);
            } else {
                this.loadedDetails = false;
                this.loadedGrid = true;
                this.cronPath = result.cronPath;
                this.resetParams();
            }
        },
        resetParams(){
            this.webhookName = '';
            this.webhookType = 'lead';
            this.webhookActionType = 'creation';
            this.actionUrl = '';
            this.configId = 0;
        },

        async imapCopyPathInfo(event){
            event.preventDefault();
            let cronPath = this.cronPath;

            if (document.queryCommandSupported("copy")) {
                let copyFromEl = $('<textarea/>');
                copyFromEl.text(cronPath);
                $('body').append(copyFromEl);
                copyFromEl.select();
                document.execCommand('copy', true);
                copyFromEl.remove();
                showMessage(this.$t('message.copiedToClipboard'), false, 2000);
            }

            return true;
        },
        changeWebHookType()
        {
            if (this.webhookType === 'lead') {
                this.webhookActionType = 'creation';
            }

            if (this.webhookType === 'order') {
                this.webhookActionType = 'completed';
            }
        }
    },
    async created(){
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }
        this.renderGrid();
    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
