export const saveConfigData = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'api/leads/leadappsoauth2config/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken' : $('#crm-oauth2-config-token').val()
            }
        }).done(async function (response) {
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }
        }).fail(async function(response){
            hideLoader();
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const getConfigSavedData = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadappsoauth2config/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'limit': state.pagination.oauth2Config.itemsPerPage,
                'offset': (state.pagination.oauth2Config.currentPage - 1) * state.pagination.oauth2Config.itemsPerPage
            }
        }).done(async function(response){
            hideLoader();
            if (response.status !== 'error') {
                commit('setPaginationData', {oauth2Config: {totalItems: response.totalRecords}});
                commit('setConfigDataInfo', response.data);
                commit('setAdditionalInfo', response.additionalInfo);
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const updateConfigAttribute = ({commit, state, dispatch}, payload) => {
    showLoader();

    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadappsoauth2config/',
            'type': 'PUT',
            'dataType': 'json',
            'data': JSON.stringify({
                'id': payload.id,
                'attributeName': payload.attributeName,
                'attributeValue': payload.attributeValue,
                'secureToken': $('#crm-oauth2-config-token').val()
            })
        }).done(function(response){
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }
        }).fail(async function(response){
            hideLoader();
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const updateConfig = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'api/leads/leadappsoauth2config/',
            'type': 'PUT',
            'dataType': 'json',
            'data': JSON.stringify( {
                'secureToken' : $('#crm-oauth2-config-token').val()
            })
        }).done(async function (response) {
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }
        }).fail(async function (response) {
            hideLoader();
            resolve({name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const deleteConfigRecord = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'api/leads/leadappsoauth2config/id/' + payload.id,
            'type': 'DELETE',
            'dataType': 'json'
        }).done(async function (response) {
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }
        }).fail(async function (response) {
            hideLoader();
            resolve({name: 'login', 'message': 'Please re-login'});
        });
    });
}