import {mapGetters} from 'vuex';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
import each from 'lodash/each';
export default {
    data () {
        return {
            loadedForm: false,
            loadedGrid: false,
            loadedDetails:false,
            serviceName:'',
            websiteUrl: $('#website_url').val(),
            localeMapping: localeMapping,
            locale: $('#system-language-oauth2-config').val(),
        }
    },
    components: {
        pagination: pagination
    },
    computed: {
        ...mapGetters({
            configDataInfo:'getConfigDataInfo',
            additionalInfo:'getAdditionalInfo'
        }),
    },
    methods: {
        async addConfig()
        {
            let serviceName = this.serviceName;

            if (serviceName === '') {
                showMessage(this.$t('message.notServiceName'), true, 2000);
                return false;
            }

            const result = await this.$store.dispatch('saveConfigData', {
                'configId' :this.configId
            });

            if (result.status === 'error') {
                showMessage(result.message, true, 2000);
                return false;
            } else {
                if (!this.isUpdate) {
                    this.resetParams();
                }

                showMessage(result.message, false, 2000);
            }
        },
        async updateConfig()
        {
            if (this.updateConfigProcessing === true) {
                return false;
            }

            this.updateConfigProcessing = true;

            const result = await this.$store.dispatch('updateConfig', {
                'configId' :this.configId
            });

            if (result.status === 'error') {
                this.updateConfigProcessing = false;
                showMessage(result.message, true, 2000);
                return false;
            } else {
                showMessage(result.message, false, 2000);
                this.updateConfigProcessing = false;
            }
        },
        async updateParamName(id, attributeName, event)
        {
            event.preventDefault();
            let attributeValue = event.target.value;

            const result = await this.$store.dispatch('updateConfigAttribute', {'id': id, 'attributeName': attributeName, 'attributeValue':attributeValue});

            if (result.status === 'error') {
                showMessage(result.message, true, 2000);
                return false;
            } else {
                showMessage(result.message, false, 2000);
                return true;
            }

        },
        async editOauth2Config(id)
        {
            const result = await this.$store.dispatch('getConfigDetails',  {'router':this.$router, 'id':id});

            if (result.status === 'error') {
                showMessage(this.$t('message.pleaseRelogin'), true, 3000);
                return false;
            } else {
                if (result.id) {
                    this.configId = result.id;
                }

                this.loadedGrid = false;
                this.loadedDetails = true;
            }
        },
        backToMainGrid()
        {
            this.loadData();
        },
        async deleteConfigItem(id)
        {
            showConfirm(this.$t('message.areYouSureYouWantToDelete'), async () => {
                const result = await this.$store.dispatch('deleteConfigRecord', {'id': id});

                if (result.status === 'error') {
                    showMessage(result.message, true, 2000);
                    return false;
                } else {
                    showMessage(result.message, false, 2000);
                    this.loadData();
                }
            });
        },
        resetParams()
        {
            this.configId = 0;
        },
        async loadData()
        {
            const result = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});

            if (result.status === 'error') {
                showMessage(this.$t('message.pleaseRelogin'), true, 3000);
                return false;
            } else {
                this.loadedForm = true;
            }

            this.resetParams();
            this.loadedGrid = true;
            this.loadedDetails = false;
        }
    },
    async created()
    {
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.loadData();
    },
    async updated()
    {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
