export const saveConfigData = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'api/leads/leadimap/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'secureToken'          : $('#crm-imap-config-token').val(),
                'service_name'         : payload.serviceName,
                'owner_id'             : payload.leadOwner,
                'host'                 : payload.host,
                'login'                : payload.login,
                'password'             : payload.password,
                'encryption'           : payload.encryption,
                'process_all_emails'   : payload.processAllEmails,
                'isOauth2'             : payload.isOauth2,
                'isTemporary'          : payload.isTemporary,
                'oauth2ServiceAppName' : payload.oauth2ServiceAppName,
            }
        }).done(async function (response) {
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }

        }).fail(async function(response){
            hideLoader();
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const deleteConfigRecord = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'api/leads/leadimap/id/' + payload.id +'/temporaryRecord/'+ payload.temporaryRecord,
            'type': 'DELETE',
            'dataType': 'json'
        }).done(async function (response) {
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }

        }).fail(async function (response) {
            hideLoader();
            resolve({name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const getConfigSavedData = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadimap/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'id': payload.id,
                'limit': state.pagination.imapConfig.itemsPerPage,
                'offset': (state.pagination.imapConfig.currentPage - 1) * state.pagination.imapConfig.itemsPerPage
            }
        }).done(async  function(response){
            hideLoader();
            if (response.status !== 'error') {
                commit('setPaginationData', {imapConfig: {totalItems: response.totalRecords}});
                commit('setConfigDataInfo', response.data);
                commit('setAdditionalInfo', response.additionalInfo);
                if (typeof payload.verifyConnection !== 'undefined') {
                    commit('setForceConnectionVerification', Date.now())
                }
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const getConfigDetails = ({commit, state, dispatch}, payload) => {

    if (typeof payload.spinner === 'undefined') {
        showLoader();
    }

    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadimap/',
            'type': 'GET',
            'dataType': 'json',
            'data': {
                'id': payload.id
            }
        }).done(async  function(response){
            if (typeof payload.spinner === 'undefined') {
                hideLoader();
            }

            if (response.status !== 'error') {
                commit('setAdditionalInfo', response.additionalInfo);
                resolve(response);
            } else {
                resolve({ name: 'login', 'message': 'Please re-login'});
            }
        }).fail(async function(response){
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
};

export const checkImapStatusData = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'plugin/leads/run/checkImapConnections/',
            'type': 'POST',
            'dataType': 'json',
            'data': {'imapRowsIds' : payload.id},
        }).done(async function (response) {
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }
        }).fail(async function (response) {
            resolve({name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const updateImapServiceName = ({commit, state, dispatch}, payload) => {
    showLoader();

    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadimap/',
            'type': 'PUT',
            'dataType': 'json',
            'data': JSON.stringify({
                'id': payload.id,
                'serviceName': payload.serviceName,
                'secureToken': $('#crm-imap-config-token').val(),
                'fastSave' : 1
            })
        }).done(function(response){
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }
        }).fail(async function(response){
            hideLoader();
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const updateOwnerId = ({commit, state, dispatch}, payload) => {
    showLoader();

    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val()+'api/leads/leadimap/',
            'type': 'PUT',
            'dataType': 'json',
            'data': JSON.stringify({
                'id': payload.id,
                'ownerId': payload.ownerId,
                'secureToken': $('#crm-imap-config-token').val(),
                'fastSave' : 1
            })
        }).done(function(response){
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }
        }).fail(async function(response){
            hideLoader();
            resolve({ name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const updateImapConfig = ({commit, state, dispatch}, payload) => {
    showLoader();
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'api/leads/leadimap/',
            'type': 'PUT',
            'dataType': 'json',
            'data': JSON.stringify( {
                'secureToken'       : $('#crm-imap-config-token').val(),
                'id'                : payload.configId,
                'service_name'      : payload.serviceName,
                'owner_id'          : payload.leadOwner,
                'host'              : payload.host,
                'login'             : payload.login,
                'password'          : payload.password,
                'encryption'        : payload.encryption,
                'process_all_emails': payload.processAllEmails,
                'isOauth2'             : payload.isOauth2,
                'isTemporary'          : payload.isTemporary,
                'oauth2ServiceAppName' : payload.oauth2ServiceAppName,
            })
        }).done(async function (response) {
            hideLoader();
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }
        }).fail(async function (response) {
            hideLoader();
            resolve({name: 'login', 'message': 'Please re-login'});
        });
    });
}

export const changeCollectEmailsPeriod = ({commit, state, dispatch}, payload) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            'url': $('#website_url').val() + 'api/leads/leadgeneralconfig/',
            'type': 'POST',
            'dataType': 'json',
            'data': {
                'paramName' : payload.paramName,
                'paramValue' : payload.paramValue,
                'secureToken' :  $('#crm-imap-config-token').val(),
            },
        }).done(async function (response) {
            if (response.status === 'error') {
                resolve(response);
            } else {
                resolve(response);
            }
        }).fail(async function (response) {
            resolve();
        });
    });
}

