define([
    'underscore',
    'backbone',
    '../collections/email-trigger',
    'text!../templates/email-trigger-grid-row.html',
    'text!../templates/paginator.html',
    'i18n!../../../nls/dashboard_'+$('#email-sequence-dashboard-system-language').val()+'_ln'
], function(_,Backbone,
            EmailTriggerCollection, EmailTriggerDataGridRowTmpl, PaginatorTmpl, i18n
            ){

    var EmailTriggerGridView = Backbone.View.extend({
        el: $('#email-trigger-grid-block'),
        events: {
            'click a[data-role=delete]': 'deleteEmailTrigger',
            'click a.email-trigger-link-to-profile': 'goToTriggerProfile',
            'click td.email-trigger-grid-table-paginator a.page': 'navigate',
            'change select.email-trigger-custom-paginator' :'customPaginate',
            'change select.email-trigger-filter-cart-template-name' :'applyTemplateFilter',
            'change select.email-trigger-filter-cart-sequence-name' :'applySequenceFilter',
            'change select.email-trigger-filter-type' :'applyTypeFilter',
            'change select.email-trigger-filter-cart-status' :'applyCartStatusFilter',
            'click #reset-filters' :'resetFilters',
        },
        templates: {
            paginator: _.template(PaginatorTmpl)
        },
        dataTable: null,
        initialize: function(options){
            this.$el.unbind();
            this.emailTrigger = new EmailTriggerCollection();
            this.emailTrigger.isGrid = 1;

            if (!_.isEmpty(options)) {
                if (typeof options.customPaginate !== 'undefined') {
                    this.emailTrigger.customPaginate = options.customPaginate;
                    this.emailTrigger.paginator_ui.perPage = options.customPaginate;
                }
                if (typeof options.filterType !== 'undefined') {
                    this.emailTrigger.filterType = options.filterType;
                    this.emailTrigger.server_api.filterType = {'type': options.filterType};
                }

                if (typeof options.filterCartStatus !== 'undefined') {
                    this.emailTrigger.filterCartStatus = options.filterCartStatus;
                    this.emailTrigger.server_api.filterCartStatus = {'cartStatus': options.filterCartStatus};
                }

                if (typeof options.filterSequenceName !== 'undefined') {
                    this.emailTrigger.filterSequenceName = options.filterSequenceName;
                    this.emailTrigger.paginator_ui.filterSequenceName = options.filterSequenceName;
                }

                if (typeof options.filterTemplate !== 'undefined') {
                    this.emailTrigger.filterTemplate = options.filterTemplate;
                    this.emailTrigger.paginator_ui.filterTemplate = options.filterTemplate;
                }

                if (typeof options.filterPage !== 'undefined') {
                    this.specialPageNavigator(options.filterPage);
                }
            }

            this.emailTrigger.on('reset', this.renderTriggers, this);
            this.emailTrigger.on('add', this.renderTriggers, this);
            this.emailTrigger.on('destroy', this.renderTriggers, this);

            if(location.href.split('?').length > 1) {
                var newURL = location.href.split('?')[0];
                window.history.pushState('object', document.title, newURL);
            }

            $('#dashboard-list').find('.dashboard-link-Email').addClass('current');
        },
        render: function(){
            this.emailTrigger.pager();
        },
        renderTriggers: function(){
            this.$el.find('tbody').empty();
            this.emailTrigger.each(this.renderTrigger, this);

            this.emailTrigger.info()['i18n'] = i18n;

            var options = '<option value="0">'+(_.isUndefined(i18n['All'])?'All':i18n['All'])+'</option>';
            $.each(this.emailTrigger.filterSequenceNames, function(sId, sName){
                options += '<option value="'+sId+'">'+sName+'</option>';
            });
            $('.email-trigger-filter-cart-sequence-name').empty().append(options);

            var options = '<option value="0">'+(_.isUndefined(i18n['All'])?'All':i18n['All'])+'</option>';
            $.each(this.emailTrigger.filterTemplateNames, function(tId, tName){
                options += '<option value="'+tId+'">'+tName+'</option>';
            });
            $('.email-trigger-filter-cart-template-name').empty().append(options);

            this.$('td.email-trigger-grid-table-paginator').html(this.templates.paginator(this.emailTrigger.information));
            $('.email-trigger-paginator-block').show();
            if(!_.isUndefined(this.emailTrigger.customPaginate)) {
                $('.email-trigger-custom-paginator').val(this.emailTrigger.customPaginate);
            }
            if(!_.isUndefined(this.emailTrigger.filterType)) {
                $('select[name=email-trigger-filter-type]').val(this.emailTrigger.filterType);
            }
            if(!_.isUndefined(this.emailTrigger.filterCartStatus)) {
                $('select[name=email-trigger-filter-cart-status]').val(this.emailTrigger.filterCartStatus);
            }

            if(!_.isUndefined(this.emailTrigger.filterTemplate)) {
                $('select[name=email-trigger-filter-cart-template-name]').val(this.emailTrigger.filterTemplate);
            }
            if(!_.isUndefined(this.emailTrigger.filterSequenceName)) {
                $('select[name=email-trigger-filter-cart-sequence-name]').val(this.emailTrigger.filterSequenceName);
            }
            if (typeof tableResponsive === "function") {
                tableResponsive();
            }
        },
        renderTrigger: function(emailTrigger){
            this.$el.find('tbody').append(_.template(EmailTriggerDataGridRowTmpl, {'emailTrigger': emailTrigger, 'i18n': i18n}));
        },
        deleteEmailTrigger: function(e){
            var cid = $(e.currentTarget).data('cid'),
                model = this.emailTrigger.get(cid),
                self = this,
                triggerName = model.get('triggerName');

            showConfirm((_.isUndefined(i18n['Are you sure you want to delete the'])?'Are you sure you want to delete the':i18n['Are you sure you want to delete the']) + ' "'+triggerName+'"'+' '+(_.isUndefined(i18n['trigger'])?'trigger':i18n['trigger'])+'?', function() {
                if (model){
                    model.destroy({
                        wait: true,
                        success: function(model, response){
                            self.emailTrigger.pager();
                        },
                        error: function(model, response){
                            showMessage(response.responseJSON, true, 2000);
                        }
                    });
                }
            })
        },
        goToTriggerProfile: function (e)
        {
            e.preventDefault();
            var triggerId = $(e.currentTarget).data('trigger-id');
            window.location.href = $('#website_url').val()+'dashboard/Email & SMS Drip/#trigger/'+triggerId;
        },
        specialPageNavigator: function(pageNumber){
            var page = pageNumber;
            if ($.isNumeric(page)){
                this.emailTrigger.goTo(page);
               $('#dashboard-list').find('.dashboard-link-Email').addClass('current');
            }
        },
        navigate: function(e){
            e.preventDefault();

            var page = $(e.currentTarget).data('page');
            if ($.isNumeric(page)){
                this.emailTrigger.goTo(page);
            } else {
                switch(page){
                    case 'first':
                        this.emailTrigger.goTo(this.emailTrigger.firstPage);
                        break;
                    case 'last':
                        this.emailTrigger.goTo(this.emailTrigger.information.lastPage);
                        break;
                    case 'prev':
                        this.emailTrigger.requestPreviousPage();
                        break;
                    case 'next':
                        this.emailTrigger.requestNextPage();
                        break;
                }
            }
        },
        applySequenceFilter: function(e) {
            var el = $(e.currentTarget),
                paginationParam = el.val();

            this.emailTrigger.filterSequenceName = paginationParam;
            this.emailTrigger.paginator_ui.filterSequenceName = paginationParam;
            this.specialPageNavigator(this.emailTrigger.firstPage);
        },
        applyTemplateFilter: function(e) {
            var el = $(e.currentTarget),
                paginationParam = el.val();

            this.emailTrigger.filterTemplate = paginationParam;
            this.emailTrigger.paginator_ui.filterTemplate = paginationParam;
            this.specialPageNavigator(this.emailTrigger.firstPage);
        },
        customPaginate: function(e) {
            var el = $(e.currentTarget),
                paginationParam = el.val();

            this.emailTrigger.customPaginate = paginationParam;
            this.emailTrigger.paginator_ui.perPage = paginationParam;
            this.specialPageNavigator(this.emailTrigger.firstPage);
        },
        applyTypeFilter: function (e) {
            var el = $(e.currentTarget),
                filterType = el.val();
            this.emailTrigger.filterType = filterType;
            this.emailTrigger.server_api.filterType = {'type': filterType};
            this.specialPageNavigator(this.emailTrigger.firstPage);
        },
        applyCartStatusFilter: function (e) {
            var el = $(e.currentTarget),
                filterCartStatus = el.val();
            this.emailTrigger.filterCartStatus = filterCartStatus;
            this.emailTrigger.server_api.filterCartStatus = {'cartStatus': filterCartStatus};
            this.specialPageNavigator(this.emailTrigger.firstPage);
        },
        resetFilters: function () {
            $('.email-trigger-filter-cart-sequence-name').val(0);
            $('.email-trigger-filter-cart-template-name').val(0);
            //$('#email-trigger-custom-paginator').val(10);
            $('.email-trigger-filter-type').val(0);
            $('.email-trigger-filter-cart-status').val(0);

            this.emailTrigger.filterSequenceName = '0';
            this.emailTrigger.paginator_ui.filterSequenceName = '0';
            this.emailTrigger.filterTemplate = '0';
            this.emailTrigger.paginator_ui.filterTemplate = '0';
            //this.emailTrigger.customPaginate = '10';
            //this.emailTrigger.paginator_ui.perPage = '10';
            this.emailTrigger.filterType = '0';
            this.emailTrigger.server_api.filterType = {'type': '0'};
            this.emailTrigger.filterCartStatus = '0';
            this.emailTrigger.server_api.filterCartStatus = {'cartStatus': '0'};

            this.specialPageNavigator(this.emailTrigger.firstPage);
        }
    });

    return EmailTriggerGridView;
});
