define([
    'backbone',
    './main',
    './email-trigger-form',
    './email-trigger-grid',
    '../models/email-trigger',
    '../models/email-sequence',
    './email-trigger-detailed-info',
    './email-sequence-form',
    './email-sequence-triggers'
], function(Backbone, MainView,
            EmailTriggerFormView, EmailTriggerGridView, EmailTriggerModel, EmailSequenceModel, EmailTriggerDetailedView,
            EmailSequenceFormView, EmailSequenceTriggersView){
    var EmailSequenceRouter = Backbone.Router.extend({
        routes: {
            ''            : 'index',
            'trigger/:id' : 'triggerDetails',
            'emailSequence/:id': 'emailSequenceDetails'
        },
        index: function (){

            //init data
            $('#email-trigger-block-section').removeClass('hidden');
            $('#lead-email-sequence-tabs').removeClass('hidden');

            this.EmailTriggerForm = new EmailTriggerFormView();
            this.EmailTriggerForm.render();
            //
            this.EmailTriggerGridView = new EmailTriggerGridView(this.getParams());
            this.EmailTriggerGridView.render();
            //
            this.EmailTriggerForm.$el.on('EmailTriggerForm:created', _.bind(this.EmailTriggerGridView.render, this.EmailTriggerGridView));
            this.EmailTriggerGridView.$el.on('EmailTriggerStatus:changed', _.bind(this.EmailTriggerGridView.render, this.EmailTriggerGridView));

            this.EmailTriggerSequenceMainView = new MainView();
            this.EmailTriggerSequenceMainView.render();

            // this.EmailSequenceForm = new EmailSequenceFormView();
            // this.EmailSequenceForm.render();
            //
            // this.EmailSequenceGridView = new EmailSequenceTriggersView(this.getParams());
            // this.EmailSequenceGridView.render();
            //
            // this.EmailSequenceForm.$el.on('EmailSequenceForm:created', _.bind(this.EmailSequenceGridView.render, this.EmailSequenceGridView));
            // this.EmailSequenceGridView.$el.on('EmailSequenceStatus:changed', _.bind(this.EmailSequenceGridView.render, this.EmailSequenceGridView));
            // this.EmailTriggerForm.$el.on('EmailTriggerForm:created', _.bind(this.EmailSequenceForm.initialize, this.EmailSequenceForm));
            // this.EmailTriggerForm.$el.on('EmailTriggerForm:created', _.bind(this.EmailSequenceForm.render, this.EmailSequenceForm));

        },
        triggerDetails: function(triggerId, params)
        {
            if (!triggerId) {
                return false;
            }

            if(!params){
                params = this.getParams();
            }

            this.emailTriggerModel =  new EmailTriggerModel();
            this.emailTriggerModel.set('id', triggerId);
            this.emailTriggerModel.fetch({data: { isGrid: 1, detailedInfo:true},
                'success': function(emailTriggerModel){
                    if(_.isUndefined(emailTriggerModel.get('id'))) {
                        window.location.href = window.location.pathname;

                    } else {
                        if(!_.isUndefined(this.EmailTriggerDetailed)) {
                            this.EmailTriggerDetailed.$el.unbind();
                        }

                        $('#email-triggers-form').remove();
                        emailTriggerModel.customDataParams = params;
                        $('#lead-organizations-recently-viewed-block').addClass('hidden');
                        this.EmailTriggerDetailed = new EmailTriggerDetailedView(emailTriggerModel);
                        window.EmailTriggerDetailed = this.EmailTriggerDetailed;
                        this.EmailTriggerDetailed.render();
                        $('#email-trigger-block-section').addClass('hidden');
                        $('#email-trigger-back-link').removeClass('hidden');
                        $('#email-trigger-detailed-view-block').removeClass('hidden');
                        $('#email-sequence-settings-section').addClass('hidden');
                        $('#lead-email-sequence-tabs').addClass('hidden');

                        var currentPage = $('td.email-trigger-grid-table-paginator span.page').data('page-orig');
                        var customPaginate = $('select[name="email-trigger-custom-paginator"]').val();
                        var filterType = $('select[name="email-trigger-filter-type"]').val();
                        var filterCartStatus = $('select[name="email-trigger-filter-cart-status"]').val();
                        var filterSequenceName = $('select[name="email-trigger-filter-cart-sequence-name"]').val();
                        var filterTemplateName = $('select[name="email-trigger-filter-cart-template-name"]').val();

                        if (typeof customPaginate === 'undefined') {
                            customPaginate = '10';
                        }

                        if (typeof filterType === 'undefined') {
                            filterType = '';
                        }

                        if (typeof filterCartStatus === 'undefined') {
                            filterCartStatus = '';
                        }

                        if (typeof filterSequenceName === 'undefined' || !filterSequenceName) {
                            filterSequenceName = '0';
                        }

                        if (typeof filterTemplateName === 'undefined' || !filterTemplateName) {
                            filterTemplateName = '0';
                        }

                        var toPage = 0;
                        if($.isNumeric(currentPage)) {
                            toPage = currentPage;
                        }

                        if (window.location.hash !== '') {
                            $('#email-trigger-back-link-back').attr('href', $('#website_url').val()+'dashboard/Email & SMS Drip/?filterPage='+ toPage + '&customPaginate=' + customPaginate + '&filterType=' + filterType + '&filterCartStatus=' + filterCartStatus + '&filterSequenceName=' + filterSequenceName + '&filterTemplate=' + filterTemplateName);
                        }
                    }
                }
            });
        },
        emailSequenceDetails: function(emailSequenceId, params)
        {
            if (!emailSequenceId) {
                return false;
            }

            if(!params){
                params = this.getParams();
            }

            var self = this;

            this.emailSequenceModel =  new EmailSequenceModel();
            this.emailSequenceModel.set('id', emailSequenceId);
            this.emailSequenceModel.fetch({data: { isGrid: 1, detailedInfo:true},
                'success': function(emailSequenceModel){
                    if(_.isUndefined(emailSequenceModel.get('sequenceName'))) {
                        window.location.href = window.location.pathname;
                    } else {
                        self.EmailTriggerSequenceMainView = new MainView();
                        self.EmailTriggerSequenceMainView.render();

                        $('#email-sequence-settings-section').removeClass('hidden');
                        $('#lead-email-sequence-tabs').removeClass('hidden');
                        $('#email-trigger-block-section').addClass('hidden');

                        $('#lead-email-sequence-tabs').find('li').removeClass('current');
                        $('#lead-emailsequence-block-tab').addClass('current');

                        self.emailSequenceForm = new EmailSequenceFormView(emailSequenceId);
                        self.emailSequenceForm.render();

                        self.emailSequenceGrid = new EmailSequenceTriggersView();
                        self.emailSequenceGrid.render();

                        self.emailSequenceForm.$el.on('EmailSequenceForm:created', _.bind(self.emailSequenceGrid.render, self.emailSequenceGrid));
                        self.emailSequenceGrid.$el.on('EmailSequenceStatus:changed', _.bind(self.emailSequenceGrid.render, self.emailSequenceGrid));
                    }
                }
            });
        },
        getParams:  function () {
            var result = {},
                tmpData = [];
            location.search
                .substr(1)
                .split("&")
                .forEach(function (item) {
                    tmpData = item.split("=");
                    result[decodeURIComponent(tmpData[0])] = decodeURIComponent(tmpData[1]);
                });
            return result;
        }

    });

    var initialize = function() {
        window.appEmailSequenceRouter = new EmailSequenceRouter;
        Backbone.history.start();
    };

    return {
        initialize: initialize
    };
});
