tinymce.PluginManager.add('leadshortcode', function(editor, url) {
    var disableForSms = 0;

    if(editor.settings.id == 'smsMessage') {
        disableForSms = 1
    }

    function getValues() {
        var shortCodeList = [];
        $.ajax({
            type: 'post',
            url: window.location.protocol+'//'+window.location.host + '/plugin/leads/run/getLeadShortCode/disableForSms/'+disableForSms,
            success: function(usefullshortcodes) {
                for(var i in usefullshortcodes) {
                    for(var j in usefullshortcodes[i]) {
                        var newShortcode = {};
                        if(typeof usefullshortcodes[i][j].alias !== 'undefined') {
                            newShortcode['text'] = usefullshortcodes[i][j].alias;
                            newShortcode['value'] = '{' + usefullshortcodes[i][j].option + '}';
                        }
                        else {
                            newShortcode['text'] = usefullshortcodes[i][j];
                            newShortcode['value'] = '{' + usefullshortcodes[i][j] + '}';
                        }
                        shortCodeList.push(newShortcode)
                    }
                }
                //remove existing menu if it is already rendered
                if(button.menu){
                    button.menu.remove();
                    button.menu = null;
                }

                button.settings.values = button.settings.menu = shortCodeList;
            },
            dataType: 'json'
        });
        return shortCodeList;
    }

    // Add a button that opens a window
    editor.addButton('leadshortcode', {
        type: 'listbox',
        text: 'Useful shortcuts',
        icon : false,
        values: getValues(),
        onselect: function() {
            //insert key
            editor.insertContent(this.value());

            //reset selected value
            this.value(null);
        },
        onPostRender: function() {
            button = this;
        }
    });
});
