<?php
/**
 * emailsequence email mail watchdog
 */
class Tools_EmailsequenceMailWatchdog implements Interfaces_Observer {

    /**
     * Abandoned trigger.
     *
     */
    const TRIGGER_CART_STATUS_ABANDONED             = 'emailsequence_abandoned';

    /**
     * new quote trigger.
     *
     */
    const TRIGGER_CART_STATUS_NEWQUOTE              = 'emailsequence_newquote';

    /**
     * quote sent trigger.
     *
     */
    const TRIGGER_CART_STATUS_QUOTESENT             = 'emailsequence_quotesent';

    /**
     * completed purchase trigger.
     *
     */
    const TRIGGER_CART_STATUS_PAYMENT_RECEIVED      = 'emailsequence_paymentreceived';

    /**
     * items shipped trigger.
     *
     */
    const TRIGGER_CART_STATUS_ITEMS_SHIPPED         = 'emailsequence_itemsshipped';

    /**
     * items shipped trigger.
     *
     */
    const TRIGGER_CART_STATUS_ITEMS_DELIVERED       = 'emailsequence_itemsdelivered';

    /**
     * refunded purchase trigger.
     *
     */
    const TRIGGER_CART_STATUS_REFUNDED_PURCHASE     = 'emailsequence_refundedpurchase';

    /**
     * pending trigger
     *
     */

    const TRIGGER_CART_STATUS_ACTION_REQUIRE        = 'emailsequence_actionrequire';

    /**
     * processing trigger
     *
     */

    const TRIGGER_CART_STATUS_TECHNICAL_PROCESSING  = 'emailsequence_technicalprocessing';

    /**
     * canceled trigger
     *
     */
    const TRIGGER_CART_STATUS_LOST_OPPORTUNITY      = 'emailsequence_lostopportunity';

    /**
     * no cart trigger
     *
     */
    const TRIGGER_CART_STATUS_DEFAULT      = 'emailsequence_nocart';

    /**
     * Unsubscribe report email. Which will be sent every month at the end of the month.
     */
    const TRIGGER_UNSUBSCRIBE_REPORT = 'emailsequence_unsubscribereport';


    const ROLE_CUSTOMER = 'customer';


    /**
     * Options passed from the toaster system mail watchdog
     *
     * @var array
     */
    protected $_options             = array();

    /**
     * Toaster mailer
     *
     * @var Tools_Mail_Mailer Toaster mailer instance
     */
    protected $_mailer              = null;

    /**
     * Toaster entity parser
     *
     * @var Tools_Content_EntityParser
     */
    protected $_entityParser        = null;

    /**
     * Toaster db config helper
     *
     * @var null|Helpers_Action_Config
     */
    protected $_configHelper        = null;

    /**
     * Toaster website helper
     *
     * @var null|Helpers_Action_Website
     */
    protected $_websiteHelper       = null;


    /**
     * Seotoaster translator instance
     *
     * @var Helpers_Action_Language
     */
    protected $_translator          = null;

    /**
     * Cartstatus email queue instance
     *
     * @var null
     */
    protected $_object               = null;

    protected $_storeConfig;

    protected $_cartStatusQueueMapper;

    protected $_template = null;

    /**
     * Roles restriction list for cart restoring
     *
     * @var array
     */
    public static $cartRecoveryProtectedRoles = array(
        Tools_Security_Acl::ROLE_SUPERADMIN,
        Tools_Security_Acl::ROLE_ADMIN,
        Shopping::ROLE_SALESPERSON,
        Tools_Security_Acl::ROLE_USER
    );


    /**
     * Init all necessary helpers and assign correct mail message
     *
     * @param array $options
     */
    public function __construct($options = array()) {
        // get global options
        $this->_options       = $options;

        // initialize helpers
        $this->_storeConfig             = Models_Mapper_ShoppingConfig::getInstance()->getConfigParams();
        $this->_entityParser            = new Tools_Content_EntityParser();
        $this->_configHelper            = Zend_Controller_Action_HelperBroker::getStaticHelper('config');
        $this->_websiteHelper           = Zend_Controller_Action_HelperBroker::getStaticHelper('website');
        $this->_translator              = Zend_Controller_Action_HelperBroker::getStaticHelper('language');
        $this->_cartStatusQueueMapper   = Emailsequence_Models_Mapper_EmailsequenceQueueMapper::getInstance();
        $this->_sessionHelper           = Zend_Controller_Action_HelperBroker::getStaticHelper('session');
        // initialize mailer and set correct message
        $this->_mailer        = Tools_Mail_Tools::initMailer();

    }

    /**
     * Mail watchdog entry point. Everything begins here
     *
     * @param Emailsequence_Models_Models_EmailsequenceQueueModel $object
     * @return bool
     * @throws Exceptions_SeotoasterException
     */

    public function notify($object) {
        if (!$object){
            return false;
        }

        $this->_object = $object;

        $template = $object->getEmailTemplate();
        if($template != '' && $template != null && $template != '0'){
           $this->_options['template'] = $template;
        }
        
        if($object->getEmailMessage() != '' && $object->getEmailMessage() != null){
            $this->_options['message'] = $object->getEmailMessage();
        }
        if($object->getEmailFrom() != '' && $object->getEmailFrom() != null){
            if(!empty($this->_options['isDemo'])) {
                $this->_options['from'] = $this->_preparseSubject($object->getEmailFrom(), array('isDemo' => true));
            } else {
                $this->_options['from'] =  $this->_preparseSubject($object->getEmailFrom());
            }
        }

        if (isset($this->_options['template']) && !empty($this->_options['template']) ){
            if(!empty($this->_options['isDemo'])) {
                $this->_template = $this->_preparseEmailTemplate(array('isDemo' => true));
            } else {
                $this->_template = $this->_preparseEmailTemplate();
            }
        } else {
            throw new Exceptions_SeotoasterException('Missing template for action email trigger');
        }

        if(!empty($object->getSubject())){
            $subject = $object->getSubject();

            if(!empty($this->_options['isDemo'])) {
                $this->_options['subject'] = $this->_preparseSubject($subject, array('isDemo' => true));
            } else {
                $this->_options['subject'] = $this->_preparseSubject($subject);
            }
        }

        if(!empty($object->getPreheader())){
            $preheader = $object->getPreheader();

            if(!empty($this->_options['isDemo'])) {
                $this->_options['preheader'] = $this->_preparseSubject($preheader, array('isDemo' => true));
            } else {
                $this->_options['preheader'] = $this->_preparseSubject($preheader);
            }
        }

        $this->_mailer
            ->setMailFromLabel($this->_storeConfig['company'])
            ->setSubject($this->_options['subject']);

        if (!empty($object->getEmailFromLabel())) {
            $this->_mailer
                ->setMailFromLabel($object->getEmailFromLabel());
        }

        if (!empty($this->_options['from'])){
            $this->_mailer->setMailFrom($this->_options['from']);
        } elseif (!empty($this->_storeConfig['email'])) {
            $this->_mailer->setMailFrom($this->_storeConfig['email']);
        } else {
            $this->_mailer->setMailFrom($this->_configHelper->getAdminEmail());
        }


        // generate sender method for the specific trigger and execute it if exists
        if (isset($this->_options['trigger'])) {
            $methodName = '_send'. str_replace(' ', '', ucwords(str_replace('_', ' ', $this->_options['trigger']))) . 'Mail';
            if (method_exists($this, $methodName)){
                $this->$methodName();
            }
        }
    }

    /**
     * Sending emails
     *
     */

    protected function _send(){
        if (!$this->_mailer->getMailFrom() || !$this->_mailer->getMailTo()) {
            throw new Exceptions_SeotoasterException('Missing required "from" and "to" fields');
        }

        $firePluginHiddenEmail = Tools_System_Tools::firePluginMethod('hiddenemail','crmHiddenEmail');
        if(!empty($firePluginHiddenEmail)){
            $firePluginHiddenEmail = array_shift($firePluginHiddenEmail);

            $this->_template .= $firePluginHiddenEmail;
        }

        /**
         * Adds preheader to Email body
         */
        if(!empty($this->_options['preheader'])) {
            $this->_template = Tools_System_Tools::insertEmailPreheaderToBody($this->_template, $this->_options['preheader']);
        }

        $this->_mailer->setBody($this->_entityParser->parse($this->_template));

        return ($this->_mailer->send() !== false);
    }



    /**
     * Sender method for the 'emailsequence_unsubscribereport' trigger
     *
     * @return bool
     */
    protected function _sendEmailsequenceUnsubscribereportMail() {
        $systemConfig = $this->_configHelper->getConfig();
        $userMapper = Application_Model_Mappers_UserMapper::getInstance();
        $adminBccArray = array();
        $customerBccArray = array();
        $adminEmail = isset($systemConfig['adminEmail'])?$systemConfig['adminEmail']:'admin@localhost';
        switch ($this->_options['recipient']) {
            case Tools_Security_Acl::ROLE_ADMIN:
                $this->_mailer->setMailToLabel('Admin')
                    ->setMailTo($adminEmail);
                $where = $userMapper->getDbTable()->getAdapter()->quoteInto("role_id = ?", Tools_Security_Acl::ROLE_ADMIN);
                $adminUsers = $userMapper->fetchAll($where);
                if(!empty($adminUsers)){
                    foreach($adminUsers as $admin){
                        array_push($adminBccArray, $admin->getEmail());
                    }
                    if(!empty($adminBccArray)){
                        $this->_mailer->setMailBcc($adminBccArray);
                    }
                }
                break;
            case Shopping::ROLE_SALESPERSON:
                $this->_mailer->setMailToLabel('Sales person')
                    ->setMailTo(!empty($this->_storeConfig['email'])?$this->_storeConfig['email']:$adminEmail);
                $where = $userMapper->getDbTable()->getAdapter()->quoteInto("role_id = ?", Shopping::ROLE_SALESPERSON);
                $salesPersons = $userMapper->fetchAll($where);
                if(!empty($salesPersons)){
                    foreach($salesPersons as $salesPerson){
                        array_push($customerBccArray, $salesPerson->getEmail());
                    }
                    if(!empty($customerBccArray)){
                        $this->_mailer->setMailBcc($customerBccArray);
                    }
                }
                break;
            default:
                error_log('Unsupported recipient '.$this->_options['recipient'].' given');
                return false;
                break;
        }

        $fromDate =  Tools_System_Tools::convertDateFromTimezone(date('Y-m-01', strtotime('now')).' 00:00:01');
        $toDate =  Tools_System_Tools::convertDateFromTimezone(date('Y-m-t', strtotime('now')).' 23:59:59');
        $unsubscribedUsers = Emailsequence_Models_Mapper_SubscribeMapper::getInstance()->getUnsubscribed($fromDate, $toDate);
        if (!empty($unsubscribedUsers)) {
            $headers[] = array($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'email'), $this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'name'), $this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'date'));
            $fileName = 'unsubscribed-list.' . date("Y-m-d", time()) . '.csv';
            $websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');
            $filePath = $websiteHelper->getPath() . $websiteHelper->getTmp() . $fileName;
            $expFile = fopen($filePath, 'w');
            $dataToExport = array_merge($headers, $unsubscribedUsers);
            foreach ($dataToExport as $data) {
                fputcsv($expFile, $data, ',', '"');
            }
            fclose($expFile);
            $at              = new Zend_Mime_Part(file_get_contents($filePath));
            $at->type        = 'application/csv';
            $at->disposition = Zend_Mime::DISPOSITION_ATTACHMENT;
            $at->encoding    = Zend_Mime::ENCODING_BASE64;
            $at->filename    = $fileName;
            $attachment[]    = $at;
            $this->_mailer->addAttachment($attachment);
            unset($at);
            $removeFiles[] = $filePath;
        }

        $this->_mailer->setSubject($this->_options['subject']);
        $this->_send();
        if (!empty($removeFiles)) {
            foreach ($removeFiles as $file) {
                if (file_exists($file)) {
                    Tools_Filesystem_Tools::deleteFile($file);
                }
            }
        }
    }


    /**
     * Sender method for the 'emailsequence_abandoned' trigger
     *
     * @return bool
     */
    protected function _sendEmailsequenceAbandonedMail() {
        $userFullName = $this->_object->getUserFullName();
        $userEmail    = $this->_object->getUserEmail();
        $cartId       = $this->_object->getCartId();
        $basketData   = $this->_prepareBasket($cartId);
        $recoveryLink = $this->_prepareRecoveryLink($this->_options['userId'], $this->_object->getCartId(), $this->_options['cartStatus']);


        $this->_entityParser->addToDictionary(array('cart:recovery'=>$recoveryLink));
        $this->_entityParser->addToDictionary(array('cart:basket'=>$basketData));
        $this->_entityParser->addToDictionary(array('user:fullname' => $userFullName));

        $unsubscribeLink = $this->_prepareUnsubscribeLink($this->_options['unsubscribeCode']);

        $this->_entityParser->addToDictionary(array('unsubscribe:link' =>$unsubscribeLink));

        $this->_mailer->setMailToLabel($userFullName)->setMailTo($userEmail);
        $this->_mailer->setSubject($this->_options['subject']);
        if (empty($this->_options['silentMode'])) {
            $this->_addToLog();
            $this->_cartStatusQueueMapper->updateQueueStatus($this->_object->getId(), '1', true);
        }
        return $this->_send();
    }

    /**
     * Sender method for the 'emailsequence_newquote' trigger
     *
     * @return bool
     */
    protected function _sendEmailsequenceQuotesentMail() {
        $userFullName = $this->_object->getUserFullName();
        $userEmail    = $this->_object->getUserEmail();
        $cartId       = $this->_object->getCartId();
        $basketData   = $this->_prepareBasket($cartId);
        $recoveryLink = $this->_prepareRecoveryLink($this->_options['userId'], $this->_object->getCartId(), $this->_options['cartStatus']);
        $quoteMapper = Quote_Models_Mapper_QuoteMapper::getInstance();
        $quote = $quoteMapper->findByCartId($cartId);
        if($quote instanceof Quote_Models_Model_Quote){
            $quoteId = $quote->getId();
            $this->_entityParser->objectToDictionary($quote);
        } else {
            $quoteId = 0;
        }

        $this->_entityParser->addToDictionary(array('cart:recovery'=>$recoveryLink));
        $this->_entityParser->addToDictionary(array('cart:basket'=>$basketData));
        $this->_entityParser->addToDictionary(array('user:fullname' => $userFullName));
        $this->_entityParser->addToDictionary(array('quote:id' => $quoteId));
        $unsubscribeLink = $this->_prepareUnsubscribeLink($this->_options['unsubscribeCode']);

        $this->_entityParser->addToDictionary(array('unsubscribe:link' =>$unsubscribeLink));
        $this->_mailer->setMailToLabel($userFullName)->setMailTo($userEmail);

        if (empty($this->_options['silentMode'])) {
            $this->_addToLog();
            $this->_cartStatusQueueMapper->updateQueueStatus($this->_object->getId(), '1', true);
        }
        return $this->_send();
    }

    /**
     * Sender method for the 'emailsequence_newquote' trigger
     *
     * @return bool
     */
    protected function _sendEmailsequenceNewquoteMail() {
        $userFullName = $this->_object->getUserFullName();
        $userEmail    = $this->_object->getUserEmail();
        $cartId       = $this->_object->getCartId();
        $basketData   = $this->_prepareBasket($cartId);
        $recoveryLink = $this->_prepareRecoveryLink($this->_options['userId'], $this->_object->getCartId(), $this->_options['cartStatus']);
        $this->_entityParser->addToDictionary(array('cart:recovery'=>$recoveryLink));
        $this->_entityParser->addToDictionary(array('cart:basket'=>$basketData));
        $quoteMapper = Quote_Models_Mapper_QuoteMapper::getInstance();
        $quote = $quoteMapper->findByCartId($cartId);
        if ($quote instanceof Quote_Models_Model_Quote) {
            $quoteId = $quote->getId();
            $this->_entityParser->objectToDictionary($quote);
        } else {
            $quoteId = 0;
        }

        $this->_entityParser->addToDictionary(array('quote:id' => $quoteId));
        $this->_entityParser->addToDictionary(array('user:fullname' => $userFullName));
        $unsubscribeLink = $this->_prepareUnsubscribeLink($this->_options['unsubscribeCode']);

        $this->_entityParser->addToDictionary(array('unsubscribe:link' =>$unsubscribeLink));
        $this->_mailer->setMailToLabel($userFullName)->setMailTo($userEmail);

        if (empty($this->_options['silentMode'])) {
            $this->_addToLog();
            $this->_cartStatusQueueMapper->updateQueueStatus($this->_object->getId(), '1', true);
        }
        return $this->_send();
    }

    /**
     * Sender method for the 'emailsequence_paymentreceived' trigger
     *
     * @return bool
     */
    protected function _sendEmailsequencePaymentreceivedMail() {
        $userFullName = $this->_object->getUserFullName();
        $userEmail    = $this->_object->getUserEmail();
        $cartId       = $this->_object->getCartId();
        $basketData   = $this->_prepareBasket($cartId);
        $recoveryLink = $this->_prepareRecoveryLink($this->_options['userId'], $this->_object->getCartId(), $this->_options['cartStatus']);
        $this->_entityParser->addToDictionary(array('cart:recovery'=>$recoveryLink));
        $this->_entityParser->addToDictionary(array('cart:basket'=>$basketData));
        $unsubscribeLink = $this->_prepareUnsubscribeLink($this->_options['unsubscribeCode']);

        $this->_entityParser->addToDictionary(array('unsubscribe:link' =>$unsubscribeLink));
        $this->_entityParser->addToDictionary(array('user:fullname' => $userFullName));
        $this->_mailer->setMailToLabel($userFullName)->setMailTo($userEmail);

        if (empty($this->_options['silentMode'])) {
            $this->_addToLog();
            $this->_cartStatusQueueMapper->updateQueueStatus($this->_object->getId(), '1', true);
        }
        return $this->_send();
    }

    /**
     * Sender method for the 'emailsequence_itemsshipped' trigger
     *
     * @return bool
     */
    protected function _sendEmailsequenceItemsshippedMail() {
        $userFullName = $this->_object->getUserFullName();
        $userEmail    = $this->_object->getUserEmail();
        $cartId       = $this->_object->getCartId();
        $basketData   = $this->_prepareBasket($cartId);
        $recoveryLink = $this->_prepareRecoveryLink($this->_options['userId'], $this->_object->getCartId(), $this->_options['cartStatus']);
        $this->_entityParser->addToDictionary(array('cart:recovery'=>$recoveryLink));
        $this->_entityParser->addToDictionary(array('cart:basket'=>$basketData));
        $unsubscribeLink = $this->_prepareUnsubscribeLink($this->_options['unsubscribeCode']);

        $this->_entityParser->addToDictionary(array('unsubscribe:link' =>$unsubscribeLink));
        $this->_entityParser->addToDictionary(array('user:fullname' => $userFullName));
        $this->_mailer->setMailToLabel($userFullName)->setMailTo($userEmail);

        if (empty($this->_options['silentMode'])) {
            $this->_addToLog();
            $this->_cartStatusQueueMapper->updateQueueStatus($this->_object->getId(), '1', true);
        }
        return $this->_send();
    }

    /**
     * Sender method for the 'emailsequence_itemsdelivered' trigger
     *
     * @return bool
     */
    protected function _sendEmailsequenceItemsdeliveredMail() {
        $userFullName = $this->_object->getUserFullName();
        $userEmail    = $this->_object->getUserEmail();
        $cartId       = $this->_object->getCartId();
        $basketData   = $this->_prepareBasket($cartId);
        $recoveryLink = $this->_prepareRecoveryLink($this->_options['userId'], $this->_object->getCartId(), $this->_options['cartStatus']);
        $this->_entityParser->addToDictionary(array('cart:recovery'=>$recoveryLink));
        $this->_entityParser->addToDictionary(array('cart:basket'=>$basketData));
        $unsubscribeLink = $this->_prepareUnsubscribeLink($this->_options['unsubscribeCode']);

        $this->_entityParser->addToDictionary(array('unsubscribe:link' =>$unsubscribeLink));
        $this->_entityParser->addToDictionary(array('user:fullname' => $userFullName));
        $this->_mailer->setMailToLabel($userFullName)->setMailTo($userEmail);

        if (empty($this->_options['silentMode'])) {
            $this->_addToLog();
            $this->_cartStatusQueueMapper->updateQueueStatus($this->_object->getId(), '1', true);
        }
        return $this->_send();
    }

    /**
     * Sender method for the 'emailsequence_refundedpurchase' trigger
     *
     * @return bool
     */
    protected function _sendEmailsequenceRefundedpurchaseMail() {
        $userFullName = $this->_object->getUserFullName();
        $userEmail    = $this->_object->getUserEmail();
        $cartId       = $this->_object->getCartId();
        $basketData   = $this->_prepareBasket($cartId);
        $recoveryLink = $this->_prepareRecoveryLink($this->_options['userId'], $this->_object->getCartId(), $this->_options['cartStatus']);
        $this->_entityParser->addToDictionary(array('cart:recovery'=>$recoveryLink));
        $this->_entityParser->addToDictionary(array('cart:basket'=>$basketData));
        $unsubscribeLink = $this->_prepareUnsubscribeLink($this->_options['unsubscribeCode']);

        $this->_entityParser->addToDictionary(array('unsubscribe:link' =>$unsubscribeLink));
        $this->_entityParser->addToDictionary(array('user:fullname' => $userFullName));
        $this->_mailer->setMailToLabel($userFullName)->setMailTo($userEmail);

        if (empty($this->_options['silentMode'])) {
            $this->_addToLog();
            $this->_cartStatusQueueMapper->updateQueueStatus($this->_object->getId(), '1', true);
        }
        return $this->_send();
    }

    /**
     * Sender method for the 'emailsequence_lostopportunity' trigger
     *
     * @return bool
     */
    protected function _sendEmailsequenceLostopportunityMail() {
        $userFullName = $this->_object->getUserFullName();
        $userEmail    = $this->_object->getUserEmail();
        $cartId       = $this->_object->getCartId();
        $basketData   = $this->_prepareBasket($cartId);
        $recoveryLink = $this->_prepareRecoveryLink($this->_options['userId'], $this->_object->getCartId(), $this->_options['cartStatus']);
        $this->_entityParser->addToDictionary(array('cart:recovery'=>$recoveryLink));
        $this->_entityParser->addToDictionary(array('cart:basket'=>$basketData));
        $quoteMapper = Quote_Models_Mapper_QuoteMapper::getInstance();
        $quote = $quoteMapper->findByCartId($cartId);
        if ($quote instanceof Quote_Models_Model_Quote) {
            $quoteId = $quote->getId();
            $this->_entityParser->objectToDictionary($quote);
        } else {
            $quoteId = 0;
        }

        $this->_entityParser->addToDictionary(array('quote:id' => $quoteId));
        $this->_entityParser->addToDictionary(array('user:fullname' => $userFullName));
        $unsubscribeLink = $this->_prepareUnsubscribeLink($this->_options['unsubscribeCode']);

        $this->_entityParser->addToDictionary(array('unsubscribe:link' =>$unsubscribeLink));
        $this->_mailer->setMailToLabel($userFullName)->setMailTo($userEmail);

        if (empty($this->_options['silentMode'])) {
            $this->_addToLog();
            $this->_cartStatusQueueMapper->updateQueueStatus($this->_object->getId(), '1', true);
        }
        return $this->_send();
    }

    /**
     * Sender method for the 'emailsequence_actionrequire' trigger
     *
     * @return bool
     */
    protected function _sendEmailsequenceActionrequireMail() {
        $userFullName = $this->_object->getUserFullName();
        $userEmail    = $this->_object->getUserEmail();
        $cartId       = $this->_object->getCartId();
        $basketData   = $this->_prepareBasket($cartId);
        $recoveryLink = $this->_prepareRecoveryLink($this->_options['userId'], $this->_object->getCartId(), $this->_options['cartStatus']);
        $this->_entityParser->addToDictionary(array('cart:recovery'=>$recoveryLink));
        $this->_entityParser->addToDictionary(array('cart:basket'=>$basketData));
        $unsubscribeLink = $this->_prepareUnsubscribeLink($this->_options['unsubscribeCode']);

        $this->_entityParser->addToDictionary(array('unsubscribe:link' =>$unsubscribeLink));
        $this->_entityParser->addToDictionary(array('user:fullname' => $userFullName));
        $this->_mailer->setMailToLabel($userFullName)->setMailTo($userEmail);

        if (empty($this->_options['silentMode'])) {
            $this->_addToLog();
            $this->_cartStatusQueueMapper->updateQueueStatus($this->_object->getId(), '1', true);
        }
        return $this->_send();
    }

    /**
     * Default email trigger
     *
     * @return bool
     * @throws Exceptions_SeotoasterException
     */
    protected function _sendEmailsequenceNocartMail() {
        $userFullName = $this->_object->getUserFullName();
        $userEmail    = $this->_object->getUserEmail();
        $unsubscribeLink = $this->_prepareUnsubscribeLink($this->_options['unsubscribeCode']);
        $this->_entityParser->addToDictionary(array('unsubscribe:link' =>$unsubscribeLink));
        $this->_entityParser->addToDictionary(array('user:fullname' => $userFullName));
        $this->_mailer->setMailToLabel($userFullName)->setMailTo($userEmail);

        if (empty($this->_options['silentMode'])) {
            $this->_addToLog();
            $this->_cartStatusQueueMapper->updateQueueStatus($this->_object->getId(), '1', true);
        }
        return $this->_send();
    }

    /**
     * Sender method for the 'emailsequence_technicalprocessing' trigger
     *
     * @return bool
     */
    protected function _sendEmailsequenceTechnicalprocessingMail() {
        $userFullName = $this->_object->getUserFullName();
        $userEmail    = $this->_object->getUserEmail();
        $cartId       = $this->_object->getCartId();
        $basketData   = $this->_prepareBasket($cartId);
        $recoveryLink = $this->_prepareRecoveryLink($this->_options['userId'], $this->_object->getCartId(), $this->_options['cartStatus']);
        $this->_entityParser->addToDictionary(array('cart:recovery'=>$recoveryLink));
        $this->_entityParser->addToDictionary(array('cart:basket'=>$basketData));
        $unsubscribeLink = $this->_prepareUnsubscribeLink($this->_options['unsubscribeCode']);

        $this->_entityParser->addToDictionary(array('unsubscribe:link' =>$unsubscribeLink));
        $this->_entityParser->addToDictionary(array('user:fullname' => $userFullName));
        $this->_mailer->setMailToLabel($userFullName)->setMailTo($userEmail);

        if (empty($this->_options['silentMode'])) {
            $this->_addToLog();
            $this->_cartStatusQueueMapper->updateQueueStatus($this->_object->getId(), '1', true);
        }
        return $this->_send();
    }

    /**
     * Prepare mail body using mail template form the trigger
     *
     * Mail template will be parsed for the:
     * 1. {emailmessage} instance
     * 2. standart toaster widgets
     * @return null
     */
    private function _preparseEmailTemplate(array $additionalParams = array()){
        $tmplName = $this->_options['template'];
        $tmplMessage = $this->_options['message'];
        $mailTemplate = Application_Model_Mappers_TemplateMapper::getInstance()->find($tmplName);

        if (!empty($mailTemplate)){
            $this->_entityParser->setDictionary(array(
                'emailmessage' => !empty($tmplMessage) ? $tmplMessage : ''
            ));
            //pushing message template to email template and cleaning dictionary
            $mailTemplate = $this->_entityParser->parse($mailTemplate->getContent());
            $this->_entityParser->setDictionary(array());

            $mailTemplate = $this->_entityParser->parse($mailTemplate);

            $themeData = Zend_Registry::get('theme');
            $extConfig = Zend_Registry::get('extConfig');
            $parserOptions = array(
                'websiteUrl'      => $this->_websiteHelper->getUrl(),
                'websitePath'     => $this->_websiteHelper->getPath(),
                'currentTheme'    => $extConfig['currentTheme'],
                'themePath'       => $themeData['path'],
                'observableModel' => $this->_object,
                'isDemo'          => !empty($additionalParams['isDemo'])
            );

            $pageMapper = Application_Model_Mappers_PageMapper::getInstance();
            $where = $pageMapper->getDbTable()->getAdapter()->quoteInto('template_id = ?', $tmplName);
            $templatePageSystem = $pageMapper->fetchAll($where, array(), 1);
            $templatePageNotSystem = $pageMapper->fetchAll($where, array());

            $checkoutPage = Tools_Misc::getCheckoutPage();
            if (!$checkoutPage instanceof Application_Model_Models_Page) {
                $checkoutPage = array();
            } else {
                $checkoutPage = $checkoutPage->toArray();
            }
            if (!empty($templatePageSystem) || !empty($templatePageNotSystem)) {
                if (!empty($templatePageSystem)) {
                    $templatePageModel = array_pop($templatePageSystem);
                } else {
                    $templatePageModel = array_pop($templatePageNotSystem);
                }

                $templatePageUrl = $templatePageModel->getUrl();
                $templatePageModelWithContainers = $pageMapper->findByUrl($templatePageUrl);
                if ($templatePageModelWithContainers instanceof Application_Model_Models_Page) {
                    $parser = new Tools_Content_Parser($mailTemplate, $templatePageModelWithContainers->toArray(),
                        $parserOptions);
                } else {
                    $parser = new Tools_Content_Parser($mailTemplate, $checkoutPage, $parserOptions);
                }

            } else {
                $parser = new Tools_Content_Parser($mailTemplate, $checkoutPage, $parserOptions);
            }

            return self::stripEditLinks($parser->parseSimple());
        }

        return false;
    }

    /**
     * Cut out edit links from contents.
     */
    public static function stripEditLinks($string) {
        if (Tools_Security_Acl::isAllowed(Tools_Security_Acl::RESOURCE_CONTENT)) {
            return preg_replace('/<a class=\"tpopup generator-links\".*>.*<\/a>/ui', '', $string);
        }
        return $string;
    }

    /**
     * Prepare subject form the trigger
     *
     * @param $subject
     * @return null
     */
    private function _preparseSubject($subject, array $additionalParams = array()){
        $themeData = Zend_Registry::get('theme');
        $extConfig = Zend_Registry::get('extConfig');
        $parserOptions = array(
            'websiteUrl'      => $this->_websiteHelper->getUrl(),
            'websitePath'     => $this->_websiteHelper->getPath(),
            'currentTheme'    => $extConfig['currentTheme'],
            'themePath'       => $themeData['path'],
            'observableModel' => $this->_object,
            'isDemo'          => !empty($additionalParams['isDemo'])
        );
        $parser = new Tools_Content_Parser($subject, array(), $parserOptions);

        return $parser->parseSimple();
    }

    /**
     * Prepare recovery link for cart
     *
     * @param string $userId system user id
     * @param int $cartId cart id
     * @param string $cartStatus cart status (completed, new, etc...)
     * @return string
     */
    protected function _prepareRecoveryLink($userId, $cartId, $cartStatus){
        $userModel = Application_Model_Mappers_UserMapper::getInstance()->find($userId);
        if ($userModel instanceof Application_Model_Models_User) {
            $userRole = $userModel->getRoleId();
            if (!in_array($userRole, self::$cartRecoveryProtectedRoles) && !in_array($this->_options['recipient'], self::$cartRecoveryProtectedRoles)) {
                $cartRestoredMapper = Emailsequence_Models_Mapper_EmailsequenceRestoredCartMapper::getInstance();
                $restoredDate = date(Tools_System_Tools::DATE_MYSQL, strtotime('now'));
                $code = sha1(uniqid(strtotime('now')));
                $restoredCartData = $cartRestoredMapper->findByCartId($cartId);
                if (!empty($restoredCartData)) {
                    $cartRestoredModel = $restoredCartData[0];
                } else {
                    $cartRestoredModel = new Emailsequence_Models_Models_EmailsequenceRestoredCartModel();
                    $cartRestoredModel->setCartId($cartId);
                    $cartRestoredModel->setUserId($userId);
                }
                $cartRestoredModel->setCode($code);
                $cartRestoredModel->setCartStatus($cartStatus);
                $cartRestoredModel->setSentAt($restoredDate);
                $cartRestoredMapper->save($cartRestoredModel);
                return $this->_websiteHelper->getUrl() . 'plugin/emailsequence/run/cartRecovery/code/' . $code . '/userId/'.$userId.'/';
            }
        }
        return '';

    }

    /**
     * Prepare link for unsubscribe
     *
     * @param string $code unsubscribe code
     * @return string
     */
    protected function _prepareUnsubscribeLink($code)
    {
        if (empty($code)) {
            return '';
        }

        return $this->_websiteHelper->getUrl() . 'plugin/emailsequence/run/unsubscribe/code/' . $code . '/'.'id/'.$this->_object->getId().'/';
    }

    /**
     * Prepare post purchase view
     *
     * @param int $cartId cart id
     * @return string
     */
    protected function _prepareBasket($cartId){
            $cartSession = Models_Mapper_CartSessionMapper::getInstance()->find($cartId);
            $view = new Zend_View();
            $websiteUrl = $this->_websiteHelper->getUrl();
            $view->websiteUrl = $websiteUrl;
            $view->setHelperPath(APPLICATION_PATH . '/views/helpers/');
            $view->addHelperPath('ZendX/JQuery/View/Helper/', 'ZendX_JQuery_View_Helper');
            $view->setScriptPath($this->_websiteHelper->getPath(). 'plugins/shopping/system/app/Widgets/Store/views');
            $view->mailReport = 1;
            $basket = '';
            if ($cartSession instanceof Models_Model_CartSession){
                $cartContent = $cartSession->getCartContent();
                $productMapper = Models_Mapper_ProductMapper::getInstance();
                $shoppingConfig = Models_Mapper_ShoppingConfig::getInstance()->getConfigParams();
                $view->shoppingConfig = $shoppingConfig;
                $shippingPrice = $cartSession->getShippingPrice();
                if($shippingPrice == null){
                    $cartSession->setShippingPrice(0);
                }
                if($cartContent != null){
                    foreach ($cartContent as $key=>$product){
                        $productObject = $productMapper->find($product['product_id']);
                        if($productObject !== null){
                            $cartContent[$key]['mpn']        = $productObject->getMpn();
                            $cartContent[$key]['photo']      = $productObject->getPhoto();
                            $cartContent[$key]['productUrl'] = $productObject->getPage()->getUrl();
                            $cartContent[$key]['taxRate']    = Tools_Tax_Tax::calculateProductTax($productObject, null, true);
                            $cartContent[$key]['isEnabled']  = $productObject->getEnabled();
                        }
                    }
                    $view->showPriceIncTax = $shoppingConfig['showPriceIncTax'];
                    $view->weightSign = $shoppingConfig['weightUnit'];
                    $view->cartContent = $cartContent;
                    $view->cart = $cartSession;
                    $basket = $view->render('post_purchase_report.phtml');
                }

            }
            return $basket;


    }

    /**
     * Add to log emailsequence
     *
     * @throws Zend_Reflection_Exception
     */
    private function _addToLog()
    {
        if (!empty($this->_object->getExternalId()) && !empty($this->_object->getSequenceId())) {

            $emailData = $this->_object->toArray();
            $emailData['observableModel'] = $this->_object;
            $emailData['dictionary'] = $this->_entityParser->getDictionary();
            $emailData['emailContent'] = $this->_entityParser->parse($this->_template);
            $trackingLinkData = $this->_getTrackingLink();
            if (!empty($trackingLinkData)) {
                $template = Tools_System_Tools::firePluginMethodByPluginName('leads','addTrackableLinks',
                    array('template' => $this->_template, 'trackingCodeHash' => $trackingLinkData['trackingCodeHash'])
                );
                if (!empty($template)) {
                    $this->_template = $template;
                }

                $this->_template = $this->_template . ' ' . $trackingLinkData['trackingLink'];
                $emailData['trackingCodeHash'] = $trackingLinkData['trackingCodeHash'];
            } else {
                $emailData['trackingCodeHash'] = '';
            }
            $emailData['leadId'] = $this->_object->getExternalId();
            $emailData['emailTo'] = $emailData['userEmail'];
            $emailData['emailSubject'] = $this->_mailer->getSubject();
            $this->_mailer->setMessageId(true);
            $emailData['emailMessageId'] = $this->_mailer->getMessageId();
            $emailData['emailMessage'] = $emailData['emailContent'];
            $emailData['sequenceId'] = $this->_object->getSequenceId();
            $emailData['triggerId'] = $this->_object->getCartStatusId();
            $logResult = Tools_System_Tools::firePluginMethodByPluginName('leads','addToEmailLog', $emailData);
        }
    }

    /**
     * Get email tracking link
     *
     * @throws Zend_Reflection_Exception
     */
    private function _getTrackingLink()
    {
        if (!empty($this->_object->getExternalId()) && !empty($this->_object->getSequenceId())) {
            $emailTrackingLinkData = Tools_System_Tools::firePluginMethodByPluginName('leads','getEmailTrackingLink');
            if (empty($emailTrackingLinkData['error']) && !empty($emailTrackingLinkData['trackingLink'])) {
                return $emailTrackingLinkData;
            }

            return '';
        }
    }

}
