<?php

/**
 * Class Tools_EmailStatsTools
 */
class Tools_EmailStatsTools
{
    /**
     * @param int $triggerId trigger id
     * @param array $sequenceIds sequence ids
     * @param string $startDateFrom start date mysql format
     * @param string $endDate end date mysql format
     * @return array
     */
    public static function getEmailStats($triggerId, $sequenceIds = array(), $startDateFrom = '', $endDate = '')
    {
        $leadsActionLogMapper = Leads_Mapper_LeadsActionLogMapper::getInstance();
        $where = $leadsActionLogMapper->getDbTable()->getAdapter()->quoteInto('plel.trigger_id = ?', $triggerId);
        $where .= ' AND '. $leadsActionLogMapper->getDbTable()->getAdapter()->quoteInto('plel.email_status = ?', Leads_Model_LeadsEmailLogModel::EMAIL_STATUS_SENT);
        if (!empty($sequenceIds)) {
            $where .= ' AND ' . $leadsActionLogMapper->getDbTable()->getAdapter()->quoteInto('plel.follow_up_sequences_id IN (?)', $sequenceIds);
        }

        if (!empty($startDateFrom)) {
            $where .= ' AND ' . $leadsActionLogMapper->getDbTable()->getAdapter()->quoteInto('plal.created_at >= ?', $startDateFrom);
        }

        if (!empty($endDate)) {
            $where .= ' AND ' . $leadsActionLogMapper->getDbTable()->getAdapter()->quoteInto('plal.created_at <= ?', $endDate);
        }

        $allSentEmails = $leadsActionLogMapper->fetchAllEmails($where, null, 1);
        $sentEmailsQuantity = 0;
        if (!empty($allSentEmails['data'])) {
            $sentEmailsQuantity = $allSentEmails['totalRecords'];
        }

        $where = $leadsActionLogMapper->getDbTable()->getAdapter()->quoteInto('plel.trigger_id = ?', $triggerId);
        $where .= ' AND '. $leadsActionLogMapper->getDbTable()->getAdapter()->quoteInto('plel.email_status = ?', Leads_Model_LeadsEmailLogModel::EMAIL_STATUS_OPENED);
        if (!empty($sequenceIds)) {
            $where .= ' AND ' . $leadsActionLogMapper->getDbTable()->getAdapter()->quoteInto('plel.follow_up_sequences_id IN (?)', $sequenceIds);
        }
        if (!empty($startDateFrom)) {
            $where .= ' AND ' . $leadsActionLogMapper->getDbTable()->getAdapter()->quoteInto('plal.created_at >= ?', $startDateFrom);
        }

        if (!empty($endDate)) {
            $where .= ' AND ' . $leadsActionLogMapper->getDbTable()->getAdapter()->quoteInto('plal.created_at <= ?', $endDate);
        }
        $allOpenedEmails = $leadsActionLogMapper->fetchAllEmails($where, null, 1);
        $openedEmailsQuantity = 0;
        if (!empty($allOpenedEmails['data'])) {
            $openedEmailsQuantity = $allOpenedEmails['totalRecords'];
        }

        $where = $leadsActionLogMapper->getDbTable()->getAdapter()->quoteInto('plel.trigger_id = ?', $triggerId);
        $where .= ' AND '. $leadsActionLogMapper->getDbTable()->getAdapter()->quoteInto('plel.email_status = ?', Leads_Model_LeadsEmailLogModel::EMAIL_STATUS_CLICK);
        if (!empty($sequenceIds)) {
            $where .= ' AND ' . $leadsActionLogMapper->getDbTable()->getAdapter()->quoteInto('plel.follow_up_sequences_id IN (?)', $sequenceIds);
        }
        if (!empty($startDateFrom)) {
            $where .= ' AND ' . $leadsActionLogMapper->getDbTable()->getAdapter()->quoteInto('plal.created_at >= ?', $startDateFrom);
        }

        if (!empty($endDate)) {
            $where .= ' AND ' . $leadsActionLogMapper->getDbTable()->getAdapter()->quoteInto('plal.created_at <= ?', $endDate);
        }
        $customCounter = "COUNT(DISTINCT CONCAT_WS('-', plel.follow_up_sequences_id, plel.trigger_id, plel.lead_id))";
        $allClickedEmails = $leadsActionLogMapper->fetchAllEmails($where, null, 1, null, false, false, true,  '', '', array(), $customCounter);
        $clickEmailsQuantity = 0;
        if (!empty($allClickedEmails['data'])) {
            $clickEmailsQuantity = $allClickedEmails['totalRecords'];
        }

        $where = $leadsActionLogMapper->getDbTable()->getAdapter()->quoteInto('plel.trigger_id = ?', $triggerId);
        $where .= ' AND '. $leadsActionLogMapper->getDbTable()->getAdapter()->quoteInto('plel.email_status = ?', Leads_Model_LeadsEmailLogModel::EMAIL_STATUS_UNSUBSCRIBED);
        if (!empty($sequenceIds)) {
            $where .= ' AND ' . $leadsActionLogMapper->getDbTable()->getAdapter()->quoteInto('plel.follow_up_sequences_id IN (?)', $sequenceIds);
        }
        if (!empty($startDateFrom)) {
            $where .= ' AND ' . $leadsActionLogMapper->getDbTable()->getAdapter()->quoteInto('plal.created_at >= ?', $startDateFrom);
        }

        if (!empty($endDate)) {
            $where .= ' AND ' . $leadsActionLogMapper->getDbTable()->getAdapter()->quoteInto('plal.created_at <= ?', $endDate);
        }
        $allUnsubscribedEmails = $leadsActionLogMapper->fetchAllEmails($where, null, 1);
        $unsubscribedEmailsQuantity = 0;
        if (!empty($allUnsubscribedEmails['data'])) {
            $unsubscribedEmailsQuantity = $allUnsubscribedEmails['totalRecords'];
        }

        if (empty($sentEmailsQuantity)) {
            $openRate = 0;
            $clickRate = 0;
        } else {
            $openRate = round(($openedEmailsQuantity/$sentEmailsQuantity) * 100,2);
            $clickRate = round(($clickEmailsQuantity/$sentEmailsQuantity) * 100, 2);
        }

        if (empty($openedEmailsQuantity)) {
            $clickThroughRate = 0;
        } else {
            $clickThroughRate = round(($clickEmailsQuantity/$openedEmailsQuantity) * 100,2);
        }

        $where = $leadsActionLogMapper->getDbTable()->getAdapter()->quoteInto('plel.trigger_id = ?', $triggerId);
        $where .= ' AND '. $leadsActionLogMapper->getDbTable()->getAdapter()->quoteInto('plel.email_status = ?', Leads_Model_LeadsEmailLogModel::EMAIL_STATUS_SENT);
        if (!empty($sequenceIds)) {
            $where .= ' AND ' . $leadsActionLogMapper->getDbTable()->getAdapter()->quoteInto('plel.follow_up_sequences_id IN (?)', $sequenceIds);
        }
        if (!empty($startDateFrom)) {
            $where .= ' AND ' . $leadsActionLogMapper->getDbTable()->getAdapter()->quoteInto('plal.created_at >= ?', $startDateFrom);
        }

        if (!empty($endDate)) {
            $where .= ' AND ' . $leadsActionLogMapper->getDbTable()->getAdapter()->quoteInto('plal.created_at <= ?', $endDate);
        }

        $allUniqueReplyEmails = $leadsActionLogMapper->fetchReplyEmails($where, null, 1);
        $replyQuantity = 0;
        if (!empty($allUniqueReplyEmails['data'])) {
            $replyQuantity = $allUniqueReplyEmails['totalRecords'];
        }

        if (empty($replyQuantity)) {
            $replyRate = 0;
        } else {
            $replyRate = round(($replyQuantity/$sentEmailsQuantity) * 100,2);
        }

        $emailStats = array(
            'sentEmailsQuantity' => $sentEmailsQuantity,
            'openedEmailsQuantity' => $openedEmailsQuantity,
            'clickEmailsQuantity' => $clickEmailsQuantity,
            'unsubscribedEmailsQuantity' => $unsubscribedEmailsQuantity,
            'replyQuantity' => $replyQuantity,
            'openRate' => $openRate,
            'clickRate' => $clickRate,
            'clickThroughRate' => $clickThroughRate,
            'replyRate' => $replyRate,
        );

        return $emailStats;
    }

    /**
     * @param int $triggerId trigger id
     * @return array
     */
    public static function getUsedInEmailSequences($triggerId)
    {
        $emailSequenceTriggersMapper = Emailsequence_Models_Mapper_EmailSequenceTriggersMapper::getInstance();
        $where = $emailSequenceTriggersMapper->getDbTable()->getAdapter()->quoteInto('pet.trigger_id = ?', $triggerId);
        $sequencesData = $emailSequenceTriggersMapper->getBySequenceId($where);
        $numberOfSequences = 0;
        $sequencesInfo = array();
        if (!empty($sequencesData['data'])) {
            $numberOfSequences = $sequencesData['totalRecords'];
            $sequencesInfo = $sequencesData['data'];
        }

        return array('numberOfSequences' => $numberOfSequences, 'sequencesInfo' => $sequencesInfo);
    }

    /**
     * @param int $triggerId trigger id
     * @param string $type type opened|click
     * @param array $sequenceIds sequence ids
     * @param string $startDateFrom start date mysql format
     * @param string $endDate end date mysql format
     * @return array
     */
    public static function getOpenByEmailClient($triggerId, $type = Leads_Model_LeadsEmailLogModel::EMAIL_STATUS_OPENED, $sequenceIds = array(), $startDateFrom = '', $endDate = '')
    {
        $leadsActionLogMapper = Leads_Mapper_LeadsActionLogMapper::getInstance();
        $where = $leadsActionLogMapper->getDbTable()->getAdapter()->quoteInto('plel.trigger_id = ?', $triggerId);
        $where .= ' AND '. $leadsActionLogMapper->getDbTable()->getAdapter()->quoteInto('plel.email_status = ?', $type);
        if (!empty($sequenceIds)) {
            $where .= ' AND ' . $leadsActionLogMapper->getDbTable()->getAdapter()->quoteInto('plel.follow_up_sequences_id IN (?)', $sequenceIds);
        }
        if (!empty($startDateFrom)) {
            $where .= ' AND ' . $leadsActionLogMapper->getDbTable()->getAdapter()->quoteInto('plal.created_at >= ?', $startDateFrom);
        }

        if (!empty($endDate)) {
            $where .= ' AND ' . $leadsActionLogMapper->getDbTable()->getAdapter()->quoteInto('plal.created_at <= ?', $endDate);
        }
        $groupBy = 'plel.email_client';
        $additionalColumns = array('openEmailClientQuantity' => new Zend_Db_Expr('COUNT(plel.email_client)'));
        $openedEmails = $leadsActionLogMapper->fetchAllEmails($where, null, null, null, false, false, true, $groupBy, '', $additionalColumns);
        if (empty($openedEmails['data'])) {
            return array();
        }

        $totalOpened = $openedEmails['totalRecords'];
        $openedByEmailClientResult = array();
        foreach ($openedEmails['data'] as $openedEmail) {
            $value = round(($openedEmail['openEmailClientQuantity']/$totalOpened)* 100,2);
            array_push($openedByEmailClientResult, array('label' => $openedEmail['emailClient'], 'value' => $value));
        }

        return $openedByEmailClientResult;

    }
}
