-- 12/11/2018
-- version: 2.2.0

UPDATE `plugin` SET `status`='disabled' WHERE `name` = 'cartstatusemail';

UPDATE `email_triggers` SET `email_triggers`.`trigger_name` = REPLACE(`email_triggers`.`trigger_name`, 'cartstatusemail_', 'emailsequence_');
UPDATE `email_triggers` SET `email_triggers`.`observer` = REPLACE(`email_triggers`.`observer`, 'Cartstatusemail_Tools_CartstatusemailMailWatchdog', 'Tools_EmailsequenceMailWatchdog');

INSERT IGNORE INTO `email_triggers` (`id`, `enabled`, `trigger_name`, `observer`)
SELECT CONCAT(NULL), CONCAT('1'), CONCAT('emailsequence_abandoned'), CONCAT('Tools_EmailsequenceMailWatchdog') FROM email_triggers WHERE
NOT EXISTS (SELECT `id`, `enabled`, `trigger_name`, `observer` FROM `email_triggers`
WHERE `enabled` = '1' AND `trigger_name` = 'emailsequence_abandoned' AND `observer` = 'Tools_EmailsequenceMailWatchdog') LIMIT 1;

INSERT IGNORE INTO `email_triggers` (`id`, `enabled`, `trigger_name`, `observer`)
SELECT CONCAT(NULL), CONCAT('1'), CONCAT('emailsequence_newquote'), CONCAT('Tools_EmailsequenceMailWatchdog') FROM email_triggers WHERE
NOT EXISTS (SELECT `id`, `enabled`, `trigger_name`, `observer` FROM `email_triggers`
WHERE `enabled` = '1' AND `trigger_name` = 'emailsequence_newquote' AND `observer` = 'Tools_EmailsequenceMailWatchdog') LIMIT 1;

INSERT IGNORE INTO `email_triggers` (`id`, `enabled`, `trigger_name`, `observer`)
SELECT CONCAT(NULL), CONCAT('1'), CONCAT('emailsequence_quotesent'), CONCAT('Tools_EmailsequenceMailWatchdog') FROM email_triggers WHERE
NOT EXISTS (SELECT `id`, `enabled`, `trigger_name`, `observer` FROM `email_triggers`
WHERE `enabled` = '1' AND `trigger_name` = 'emailsequence_quotesent' AND `observer` = 'Tools_EmailsequenceMailWatchdog') LIMIT 1;

INSERT IGNORE INTO `email_triggers` (`id`, `enabled`, `trigger_name`, `observer`)
SELECT CONCAT(NULL), CONCAT('1'), CONCAT('emailsequence_paymentreceived'), CONCAT('Tools_EmailsequenceMailWatchdog') FROM email_triggers WHERE
NOT EXISTS (SELECT `id`, `enabled`, `trigger_name`, `observer` FROM `email_triggers`
WHERE `enabled` = '1' AND `trigger_name` = 'emailsequence_paymentreceived' AND `observer` = 'Tools_EmailsequenceMailWatchdog') LIMIT 1;

INSERT IGNORE INTO `email_triggers` (`id`, `enabled`, `trigger_name`, `observer`)
SELECT CONCAT(NULL), CONCAT('1'), CONCAT('emailsequence_itemsshipped'), CONCAT('Tools_EmailsequenceMailWatchdog') FROM email_triggers WHERE
NOT EXISTS (SELECT `id`, `enabled`, `trigger_name`, `observer` FROM `email_triggers`
WHERE `enabled` = '1' AND `trigger_name` = 'emailsequence_itemsshipped' AND `observer` = 'Tools_EmailsequenceMailWatchdog') LIMIT 1;

INSERT IGNORE INTO `email_triggers` (`id`, `enabled`, `trigger_name`, `observer`)
SELECT CONCAT(NULL), CONCAT('1'), CONCAT('emailsequence_itemsdelivered'), CONCAT('Tools_EmailsequenceMailWatchdog') FROM email_triggers WHERE
NOT EXISTS (SELECT `id`, `enabled`, `trigger_name`, `observer` FROM `email_triggers`
WHERE `enabled` = '1' AND `trigger_name` = 'emailsequence_itemsdelivered' AND `observer` = 'Tools_EmailsequenceMailWatchdog') LIMIT 1;

INSERT IGNORE INTO `email_triggers` (`id`, `enabled`, `trigger_name`, `observer`)
SELECT CONCAT(NULL), CONCAT('1'), CONCAT('emailsequence_refundedpurchase'), CONCAT('Tools_EmailsequenceMailWatchdog') FROM email_triggers WHERE
NOT EXISTS (SELECT `id`, `enabled`, `trigger_name`, `observer` FROM `email_triggers`
WHERE `enabled` = '1' AND `trigger_name` = 'emailsequence_refundedpurchase' AND `observer` = 'Tools_EmailsequenceMailWatchdog') LIMIT 1;

INSERT IGNORE INTO `email_triggers` (`id`, `enabled`, `trigger_name`, `observer`)
SELECT CONCAT(NULL), CONCAT('1'), CONCAT('emailsequence_actionrequire'), CONCAT('Tools_EmailsequenceMailWatchdog') FROM email_triggers WHERE
NOT EXISTS (SELECT `id`, `enabled`, `trigger_name`, `observer` FROM `email_triggers`
WHERE `enabled` = '1' AND `trigger_name` = 'emailsequence_actionrequire' AND `observer` = 'Tools_EmailsequenceMailWatchdog') LIMIT 1;

INSERT IGNORE INTO `email_triggers` (`id`, `enabled`, `trigger_name`, `observer`)
SELECT CONCAT(NULL), CONCAT('1'), CONCAT('emailsequence_technicalprocessing'), CONCAT('Tools_EmailsequenceMailWatchdog') FROM email_triggers WHERE
NOT EXISTS (SELECT `id`, `enabled`, `trigger_name`, `observer` FROM `email_triggers`
WHERE `enabled` = '1' AND `trigger_name` = 'emailsequence_technicalprocessing' AND `observer` = 'Tools_EmailsequenceMailWatchdog') LIMIT 1;

INSERT IGNORE INTO `email_triggers` (`id`, `enabled`, `trigger_name`, `observer`)
SELECT CONCAT(NULL), CONCAT('1'), CONCAT('emailsequence_lostopportunity'), CONCAT('Tools_EmailsequenceMailWatchdog') FROM email_triggers WHERE
NOT EXISTS (SELECT `id`, `enabled`, `trigger_name`, `observer` FROM `email_triggers`
WHERE `enabled` = '1' AND `trigger_name` = 'emailsequence_lostopportunity' AND `observer` = 'Tools_EmailsequenceMailWatchdog') LIMIT 1;

INSERT IGNORE INTO `email_triggers` (`id`, `enabled`, `trigger_name`, `observer`)
SELECT CONCAT(NULL), CONCAT('1'), CONCAT('emailsequence_nocart'), CONCAT('Tools_EmailsequenceMailWatchdog') FROM email_triggers WHERE
NOT EXISTS (SELECT `id`, `enabled`, `trigger_name`, `observer` FROM `email_triggers`
WHERE `enabled` = '1' AND `trigger_name` = 'emailsequence_nocart' AND `observer` = 'Tools_EmailsequenceMailWatchdog') LIMIT 1;

INSERT IGNORE INTO `email_triggers` (`id`, `enabled`, `trigger_name`, `observer`)
SELECT CONCAT(NULL), CONCAT('1'), CONCAT('emailsequence_unsubscribereport'), CONCAT('Tools_EmailsequenceMailWatchdog') FROM email_triggers WHERE
NOT EXISTS (SELECT `id`, `enabled`, `trigger_name`, `observer` FROM `email_triggers`
WHERE `enabled` = '1' AND `trigger_name` = 'emailsequence_unsubscribereport' AND `observer` = 'Tools_EmailsequenceMailWatchdog') LIMIT 1;

INSERT IGNORE INTO `email_triggers_actions` (`trigger`, `template`, `recipient`, `message`, `from`, `subject`)
SELECT CONCAT('emailsequence_abandoned'), CONCAT('default'), CONCAT('customer'), CONCAT('You’ve left something rather lovely in your shopping basket. {cart:basket} Ready to make it yours? Click here {cart:recovery}'), CONCAT('admin@example.com'), CONCAT('What’s that in your shopping basket? Do you see what we see?') FROM email_triggers_actions WHERE
NOT EXISTS (SELECT `trigger`, `template`, `recipient`, `message`, `from`, `subject` FROM `email_triggers_actions`
WHERE `trigger` = 'emailsequence_abandoned') LIMIT 1;

INSERT IGNORE INTO `email_triggers_actions` (`trigger`, `template`, `recipient`, `message`, `from`, `subject`)
SELECT CONCAT('emailsequence_quotesent'), CONCAT('default'), CONCAT('customer'), CONCAT('Don’t forget, you left something behind. To help you make up your mind, enjoy 15% off your quote when you call us at XXX XXX XXXX with coupon # Click here to view your private quote {cart:recovery} Hurry this offer ends on XX/XX/XXXX'), CONCAT('admin@example.com'), CONCAT('A little something to sweeten your day') FROM email_triggers_actions WHERE
NOT EXISTS (SELECT `trigger`, `template`, `recipient`, `message`, `from`, `subject` FROM `email_triggers_actions`
WHERE `trigger` = 'emailsequence_quotesent') LIMIT 1;

INSERT IGNORE INTO `email_triggers_actions` (`trigger`, `template`, `recipient`, `message`, `from`, `subject`)
SELECT CONCAT('emailsequence_paymentreceived'), CONCAT('default'), CONCAT('customer'), CONCAT('We wanted to thank you for your business with a free shipping voucher code for your next purchase. Next time you shop with us, please enter XXXXX in the promotional code field on the checkout page.'), CONCAT('admin@example.com'), CONCAT('Thank you for your payment') FROM email_triggers_actions WHERE
NOT EXISTS (SELECT `trigger`, `template`, `recipient`, `message`, `from`, `subject` FROM `email_triggers_actions`
WHERE `trigger` = 'emailsequence_paymentreceived') LIMIT 1;

-- 08/02/2019
-- version: 2.2.1
ALTER TABLE `plugin_cartstatusemail_settings` ADD COLUMN `type` ENUM('email', 'sms') NOT NULL DEFAULT 'email' AFTER `cartStatus`;
ALTER TABLE `plugin_cartstatusemail_queue` ADD COLUMN `type` ENUM('email', 'sms') NOT NULL DEFAULT 'email' AFTER `cartId`;
ALTER TABLE `plugin_cartstatusemail_queue` ADD COLUMN `userPhoneNumber` VARCHAR(100) DEFAULT NULL COLLATE 'utf8_unicode_ci' AFTER `userFullName`;

-- 25/02/2019
-- version: 2.2.2
ALTER TABLE `plugin_cartstatusemail_subscribe` DROP INDEX `PRIMARY`;
ALTER TABLE `plugin_cartstatusemail_subscribe` ADD COLUMN `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY FIRST;
ALTER TABLE `plugin_cartstatusemail_subscribe` ADD COLUMN `external` ENUM('0', '1') DEFAULT '0';
ALTER TABLE `plugin_cartstatusemail_subscribe` ADD COLUMN `external_email` varchar(255) DEFAULT NULL COLLATE 'utf8_unicode_ci';

-- 17/05/2019
-- version: 2.2.3
ALTER TABLE `plugin_emailsequence_settings` ADD COLUMN `archive` ENUM('0', '1') DEFAULT '0';

-- 27/09/2019
-- version: 2.2.4
CREATE TABLE IF NOT EXISTS `plugin_cartstatusemail_subscribe_sms`(
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `user_id` INT(10) UNSIGNED NOT NULL,
  `code` CHAR(40) NOT NULL COMMENT 'Hash for unsubscribe link',
  `status` ENUM('subscribed', 'unsubscribed') NOT NULL DEFAULT 'subscribed',
  `unsubscribed_at` TIMESTAMP NULL,
  `external` ENUM('0', '1') DEFAULT '0',
  `external_email` VARCHAR (255) DEFAULT NULL COLLATE 'utf8_unicode_ci',
  `mobile_number` VARCHAR(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 08/07/2021
-- version: 2.2.5
ALTER TABLE `plugin_cartstatusemail_queue` ADD INDEX (`externalId`);

-- 08/11/2022
-- version: 2.2.6
ALTER TABLE `plugin_cartstatusemail_settings` ADD COLUMN `preheader` TEXT COLLATE utf8_unicode_ci COMMENT 'Email preheader text is a small line of text that appears after the subject line in an email inbox.';
ALTER TABLE `plugin_cartstatusemail_queue` ADD COLUMN `preheader` TEXT COLLATE utf8_unicode_ci COMMENT 'Email preheader text is a small line of text that appears after the subject line in an email inbox.';

-- 24/04/2023
-- version: 2.2.7
ALTER TABLE `plugin_cartstatusemail_settings` ADD COLUMN `emailFromLabel` TEXT DEFAULT NULL COLLATE 'utf8_unicode_ci' COMMENT 'Email from label';
ALTER TABLE `plugin_cartstatusemail_queue` ADD COLUMN `emailFromLabel` TEXT DEFAULT NULL COLLATE 'utf8_unicode_ci' COMMENT 'Email from label';

-- 18/08/2023
-- version: 2.2.8
CREATE TABLE IF NOT EXISTS `plugin_emailsequence_has_mms` (
    `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
    `sequence_id` INT(10) UNSIGNED NOT NULL,
    `mms_files` TEXT DEFAULT NULL COLLATE 'utf8_unicode_ci',
    `mms_files_original_names` MEDIUMTEXT DEFAULT NULL COLLATE 'utf8_unicode_ci',
    PRIMARY KEY(`id`),
    FOREIGN KEY(`sequence_id`) REFERENCES `plugin_cartstatusemail_settings` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


-- 06/08/2025
-- version: 2.2.9
ALTER TABLE `plugin_cartstatusemail_queue` ADD INDEX (`sequence_id`);

-- These alters are always the latest and updated version of the database
UPDATE `plugin` SET `version`='2.3.0' WHERE `name`='emailsequence';
UPDATE `plugin` SET `tags`='cartstatusemail' WHERE `name` = 'emailsequence';
SELECT version FROM `plugin` WHERE `name` = 'emailsequence';
