<?php

class Tools_SmsServiceFormWatchdog implements Interfaces_Observer
{

    public function notify($object)
    {
        $requestHelper = Zend_Controller_Front::getInstance()->getRequest();
        $configHelper = Zend_Controller_Action_HelperBroker::getExistingHelper('config');
        $formParams = $requestHelper->getParams();
        if (!empty($formParams)) {
            $adminMobilePhones = explode(',', $object->getMobile());
            $subscriber = array();
            $formName = $object->getName();
            $formUrl = $formParams['formUrl'];
            unset($formParams['formUrl']);
            $subscriber['form_url'] = $formUrl;
            $subscriber['form_name'] = $formName;
            $subscriber['sms_from_type'] = Apps::SMS_FROM_TYPE_FORM;

            $customFormParams = array();

            foreach ($formParams as $paramName => $paramValue) {
                $customFormParams[$paramName] = $paramValue;
            }

            if (!empty($adminMobilePhones)) {
                $formId = $object->getId();
                unset($formParams['module']);
                unset($formParams['controller']);
                unset($formParams['action']);
                unset($formParams['recaptcha']);
                unset($formParams[md5($formName . $formId)]);
                unset($formParams['recaptcha_challenge_field']);
                unset($formParams['recaptcha_response_field']);
                unset($formParams['g-recaptcha-response']);
                unset($formParams['formPageId']);
                unset($formParams['submit']);
                unset($formParams['uploadLimitSize']);
                unset($formParams['formName']);
                if (isset($formParams['conversionPageUrl'])) {
                    unset($formParams['conversionPageUrl']);
                }
                $messageAdmin = 'Hello you\'ve received a request from: ' . $formUrl. PHP_EOL;

                foreach ($formParams as $name => $value) {
                    if (!$value) {
                        continue;
                    }
                    $messageAdmin .= $name . ': ' . (is_array($value) ? implode(', ', $value) : $value) . PHP_EOL;
                }

                $adminMobiles = array();

                foreach($adminMobilePhones as $adminMobile) {
                    $mobilePhoneAdmin = Apps_Tools_Twilio::normalizePhoneNumberToE164($adminMobile);
                    if ($mobilePhoneAdmin) {
                        array_push($adminMobiles, $mobilePhoneAdmin);
                    }
                }

                if (!empty($adminMobiles)) {
                    $originalAdminMobile = array_shift($adminMobiles);

                    $subscriber['subscriber']['admin'] = array(
                        'phone' => array($originalAdminMobile),
                        'message' => $messageAdmin,
                        'owner_type' => Apps::SMS_OWNER_TYPE_ADMIN,
                        'custom_params' => $customFormParams
                    );
                }

            }

            $enabledSms = $object->getEnableSms();

            if (isset($formParams['mobile']) && $enabledSms) {

                if(!empty($formParams['mobilePhoneCode'])) {
                    $formParams['mobile'] = $formParams['mobilePhoneCode'] . $formParams['mobile'];
                } elseif (!empty($formParams['mobile-country-code'])) {
                    $formParams['mobile-country-code'] = '+'.Zend_Locale::getTranslation($formParams['mobile-country-code'], 'phoneToTerritory');
                    $formParams['mobile'] = $formParams['mobile-country-code'] . $formParams['mobile'];
                }

                $mobilePhoneUser = Apps_Tools_Twilio::normalizePhoneNumberToE164($formParams['mobile']);

                $replyText = $this->_parseData($object->getReplyText());
                $formParamsLexemsToSms = $this->_buildLexemesValues($formParams);

                if(!empty($formParamsLexemsToSms)) {
                    $wicEmail = $configHelper->getConfig('wicEmail');
                    $bizEmail = !empty($wicEmail) ? $wicEmail : $configHelper->getConfig('adminEmail');
                    $formParamsLexemsToSms['{widcard:BizEmail}'] = $bizEmail;

                    foreach ($formParamsLexemsToSms as $lexem => $lexemValue) {
                        $replyText = str_replace($lexem, $lexemValue, $replyText);
                    }
                }

                $messageUser = $replyText;

                if ($mobilePhoneUser) {
                    $subscriber['subscriber']['user'] = array(
                        'phone' => array($mobilePhoneUser),
                        'message' => $messageUser,
                        'owner_type' => Apps::SMS_OWNER_TYPE_USER,
                        'custom_params' => $customFormParams
                    );
                }
            }

            $subscriber['ipAddress'] = Tools_System_Tools::getIpAddress();

            if (!empty($subscriber['subscriber'])) {
                Apps::apiCall('POST', 'apps', array('twilioSms'), $subscriber);

                if (!empty($adminMobiles)) {
                    $subscriber['subscriber']['user'] = array(
                        'phone' => $adminMobiles,
                        'message' => $messageAdmin,
                        'owner_type' => Apps::SMS_OWNER_TYPE_USER,
                        'sms_from_type' => 'crm',
                        'custom_params' => $customFormParams
                    );

                    unset($subscriber['subscriber']['admin']);

                    Apps::apiCall('POST', 'apps', array('twilioSms'), $subscriber);
                }

            }
        }
    }

    /**
     * Parse widgets for template
     *
     * @param string $data
     * @return null
     * @throws Zend_Exception
     */
    private function _parseData($data)
    {
        $websiteHelper = Zend_Controller_Action_HelperBroker::getExistingHelper('website');

        $themeData = Zend_Registry::get('theme');
        $extConfig = Zend_Registry::get('extConfig');
        $parserOptions = array(
            'websiteUrl' => $websiteHelper->getUrl(),
            'websitePath' => $websiteHelper->getPath(),
            'currentTheme' => $extConfig['currentTheme'],
            'themePath'    => Tools_Filesystem_Tools::cleanWinPath($themeData['path']),
        );
        $parser = new Tools_Content_Parser($data, array(), $parserOptions);

        return $parser->parseSimple();
    }

    /**
     * Adding additional lexemes
     *
     * @param array $params form params
     * @param string $lexemePrefix lexeme prefix
     */
    private function _buildLexemesValues(array $params, $lexemePrefix = 'form')
    {
        $lexemsParams = array();
        foreach ($params as $paramName => $paramValue) {
            $lexemsParams['{' . $lexemePrefix . ':' . $paramName. '}'] = $paramValue;
        }

        return $lexemsParams;
    }


}

