<?php

class Tools_MailServiceFormWatchdog implements Interfaces_Observer
{

    public function notify($object)
    {
        $requestHelper = Zend_Controller_Front::getInstance()->getRequest();
        $formParams = $requestHelper->getParams();
        if (!empty($formParams) && isset($formParams['emailMarketing'])) {
            $formName = $object->getName();
            $enabledServices = Apps_Models_Mapper_AppsSettingsMapper::getInstance()->selectConfigByStatusCategory('1',
                Apps::SERVICE_TYPE_EMAIL, false);

            if (!empty($enabledServices)) {
                $isPluginShoppingEnabled = false;

                $shoppingEnabled = Tools_Plugins_Tools::findPluginByName('shopping');
                if($shoppingEnabled->getStatus() == Application_Model_Models_Plugin::ENABLED) {
                    $isPluginShoppingEnabled = true;
                }

                foreach ($enabledServices as $service => $serviceInfo) {
                    $systemFormMapper = Apps_Models_Mapper_AppsSystemFormMapper::getInstance();
                    $existingForms = $systemFormMapper->getByFormNameService($formName, $service);
                    if (!empty($existingForms)) {
                        $data = array();
                        $commands = array();
                        $data['services'] = array($service => array('type' => Apps::SERVICE_TYPE_EMAIL));
                        if (!empty($serviceInfo['detailed_info'])) {
                            $name = $formParams['name'];
                            $lastName = '';
                            $phone = '';
                            $mobile = '';
                            $city = '';
                            $countryCode = '';
                            $phoneCountryCode = '';
                            $mobileCountryCode = '';
                            $state = '';
                            $zip = '';
                            $position = '';
                            $organization = '';


                            if (!empty($formParams['lastname'])) {
                                $lastName = $formParams['lastname'];
                            }

                            if (!empty($formParams['city'])) {
                                $city = $formParams['city'];
                            }

                            if (!empty($formParams['state'])) {
                                $state = $formParams['state'];
                            }

                            if (!empty($formParams['zip'])) {
                                $zip = $formParams['zip'];
                            }

                            if (!empty($formParams['phone'])) {
                                $phone = $formParams['phone'];
                            }

                            if (!empty($formParams['mobile'])) {
                                $mobile = $formParams['mobile'];
                            }

                            if (!empty($formParams['position'])) {
                                $position = $formParams['position'];
                            }

                            if (!empty($formParams['organization'])) {
                                $organization = $formParams['organization'];
                            }

                            if (!empty($formParams['phone-country-code'])) {
                                $phoneCountryCode = $formParams['phone-country-code'];
                            }

                            if (!empty($formParams['mobile-country-code'])) {
                                $mobileCountryCode = $formParams['mobile-country-code'];
                            }

                            if(!$isPluginShoppingEnabled) {
                                $countryCodes = Tools_AppsTools::getCountries();
                            } else {
                                $countryCodes = Tools_Geo::getCountries(true);
                            }

                            if (!empty($formParams['country'])) {
                                $countryCode = $formParams['country'];
                                if (!empty($countryCode)) {
                                    if (!array_key_exists($countryCode, $countryCodes)) {
                                        $countryCode = '';
                                    }
                                }
                            }

                            if (empty($phoneCountryCode)) {
                                if (!array_key_exists($phoneCountryCode, $countryCodes)) {
                                    $phoneCountryCode = '';
                                }
                            }

                            if (empty($mobileCountryCode)) {
                                if (!array_key_exists($mobileCountryCode, $countryCodes)) {
                                    $mobileCountryCode = '';
                                }
                            }

                            $data['services'][$service]['clients'][] =  array(
                                'email' => $formParams['email'],
                                'firstName' => $name,
                                'lastName' => $lastName,
                                'city' => $city,
                                'state' => $state,
                                'country' => $countryCode,
                                'zip' => $zip,
                                'phoneCountryCode' => $phoneCountryCode,
                                'phoneNumber' => $phone,
                                'mobileCode' => $mobileCountryCode,
                                'mobileNumber' => $mobile,
                                'position' => $position,
                                'organization' => $organization
                            );
                        } else {
                            $data['services'][$service]['clients'] = array($formParams['email'] => '');
                            if (isset($formParams['name'])) {
                                $data['services'][$service]['clients'][$formParams['email']] = $formParams['name'];
                            }
                            if (isset($formParams['lastname']) && isset($formParams['name'])) {
                                $data['services'][$service]['clients'][$formParams['email']] = $formParams['name'] . ' ' . $formParams['lastname'];
                            }
                        }

                        $data['services'][$service]['lists'] = explode(',', $existingForms[0]->getLists());
                        $commands[] = $service . 'Client';

                        Apps::apiCall('POST', 'apps', $commands, $data);
                    }
                }

            }
        }
    }


}

