<?php

namespace garethp\ews\API\Type;

/**
 * Class representing UnifiedMessageServiceConfigurationType
 *
 *
 * XSD Type: UnifiedMessageServiceConfiguration
 */
class UnifiedMessageServiceConfigurationType extends ServiceConfigurationType
{

    /**
     * @var boolean
     */
    protected $umEnabled = null;

    /**
     * @var string
     */
    protected $playOnPhoneDialString = null;

    /**
     * @var boolean
     */
    protected $playOnPhoneEnabled = null;

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isUmEnabled()
    {
        return ((bool) $this->umEnabled);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getUmEnabled()
    {
        return $this->umEnabled;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return UnifiedMessageServiceConfigurationType
     */
    public function setUmEnabled($value)
    {
        $this->umEnabled = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getPlayOnPhoneDialString()
    {
        return $this->playOnPhoneDialString;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return UnifiedMessageServiceConfigurationType
     */
    public function setPlayOnPhoneDialString($value)
    {
        $this->playOnPhoneDialString = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isPlayOnPhoneEnabled()
    {
        return ((bool) $this->playOnPhoneEnabled);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getPlayOnPhoneEnabled()
    {
        return $this->playOnPhoneEnabled;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return UnifiedMessageServiceConfigurationType
     */
    public function setPlayOnPhoneEnabled($value)
    {
        $this->playOnPhoneEnabled = $value;
        return $this;
    }
}
