<?php

namespace garethp\ews\API\Type;

/**
 * Class representing TwoOperandExpressionType
 *
 *
 * XSD Type: TwoOperandExpressionType
 */
class TwoOperandExpressionType extends SearchExpressionType
{

    /**
     * @var \garethp\ews\API\Type\FieldURI[]
     */
    protected $fieldURI = null;

    /**
     * @var \garethp\ews\API\Type\IndexedFieldURI[]
     */
    protected $indexedFieldURI = null;

    /**
     * @var \garethp\ews\API\Type\ExtendedFieldURI[]
     */
    protected $extendedFieldURI = null;

    /**
     * @var \garethp\ews\API\Type\FieldURIOrConstantType
     */
    protected $fieldURIOrConstant = null;

    /**
     * @autogenerated This method is safe to replace
     * @param $value FieldURI
     * @return TwoOperandExpressionType
     */
    public function addFieldURI(FieldURI $value)
    {
        if ($this->fieldURI === null) {
                        $this->fieldURI = array();
        }

        if (!is_array($this->fieldURI)) {
            $this->fieldURI = array($this->fieldURI);
        }

        $this->fieldURI[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return FieldURI[]
     */
    public function getFieldURI()
    {
        return $this->fieldURI;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value PathToUnindexedFieldType[]|PathToUnindexedFieldType
     * @return TwoOperandExpressionType
     */
    public function setFieldURI(array|PathToUnindexedFieldType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->fieldURI = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value IndexedFieldURI
     * @return TwoOperandExpressionType
     */
    public function addIndexedFieldURI(IndexedFieldURI $value)
    {
        if ($this->indexedFieldURI === null) {
                        $this->indexedFieldURI = array();
        }

        if (!is_array($this->indexedFieldURI)) {
            $this->indexedFieldURI = array($this->indexedFieldURI);
        }

        $this->indexedFieldURI[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return IndexedFieldURI[]
     */
    public function getIndexedFieldURI()
    {
        return $this->indexedFieldURI;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value PathToIndexedFieldType[]|PathToIndexedFieldType
     * @return TwoOperandExpressionType
     */
    public function setIndexedFieldURI(array|PathToIndexedFieldType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->indexedFieldURI = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ExtendedFieldURI
     * @return TwoOperandExpressionType
     */
    public function addExtendedFieldURI(ExtendedFieldURI $value)
    {
        if ($this->extendedFieldURI === null) {
                        $this->extendedFieldURI = array();
        }

        if (!is_array($this->extendedFieldURI)) {
            $this->extendedFieldURI = array($this->extendedFieldURI);
        }

        $this->extendedFieldURI[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ExtendedFieldURI[]
     */
    public function getExtendedFieldURI()
    {
        return $this->extendedFieldURI;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value PathToExtendedFieldType[]|PathToExtendedFieldType
     * @return TwoOperandExpressionType
     */
    public function setExtendedFieldURI(array|PathToExtendedFieldType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->extendedFieldURI = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return FieldURIOrConstantType
     */
    public function getFieldURIOrConstant()
    {
        return $this->fieldURIOrConstant;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value FieldURIOrConstantType
     * @return TwoOperandExpressionType
     */
    public function setFieldURIOrConstant(FieldURIOrConstantType $value)
    {
        $this->fieldURIOrConstant = $value;
        return $this;
    }
}
