<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing SuggestionsViewOptionsType
 *
 *
 * XSD Type: SuggestionsViewOptionsType
 */
class SuggestionsViewOptionsType extends Type
{

    /**
     * @var integer
     */
    protected $goodThreshold = null;

    /**
     * @var integer
     */
    protected $maximumResultsByDay = null;

    /**
     * @var integer
     */
    protected $maximumNonWorkHourResultsByDay = null;

    /**
     * @var integer
     */
    protected $meetingDurationInMinutes = null;

    /**
     * @var string
     */
    protected $minimumSuggestionQuality = null;

    /**
     * @var \garethp\ews\API\Type\DurationType
     */
    protected $detailedSuggestionsWindow = null;

    /**
     * @var \DateTime
     */
    protected $currentMeetingTime = null;

    /**
     * @var string
     */
    protected $globalObjectId = null;

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getGoodThreshold()
    {
        return $this->goodThreshold;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return SuggestionsViewOptionsType
     */
    public function setGoodThreshold($value)
    {
        $this->goodThreshold = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getMaximumResultsByDay()
    {
        return $this->maximumResultsByDay;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return SuggestionsViewOptionsType
     */
    public function setMaximumResultsByDay($value)
    {
        $this->maximumResultsByDay = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getMaximumNonWorkHourResultsByDay()
    {
        return $this->maximumNonWorkHourResultsByDay;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return SuggestionsViewOptionsType
     */
    public function setMaximumNonWorkHourResultsByDay($value)
    {
        $this->maximumNonWorkHourResultsByDay = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getMeetingDurationInMinutes()
    {
        return $this->meetingDurationInMinutes;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return SuggestionsViewOptionsType
     */
    public function setMeetingDurationInMinutes($value)
    {
        $this->meetingDurationInMinutes = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getMinimumSuggestionQuality()
    {
        return $this->minimumSuggestionQuality;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return SuggestionsViewOptionsType
     */
    public function setMinimumSuggestionQuality($value)
    {
        $this->minimumSuggestionQuality = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return DurationType
     */
    public function getDetailedSuggestionsWindow()
    {
        return $this->detailedSuggestionsWindow;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value DurationType
     * @return SuggestionsViewOptionsType
     */
    public function setDetailedSuggestionsWindow(DurationType $value)
    {
        $this->detailedSuggestionsWindow = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \DateTime
     */
    public function getCurrentMeetingTime()
    {
        return $this->currentMeetingTime;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \DateTime|string
     * @return SuggestionsViewOptionsType
     */
    public function setCurrentMeetingTime(\DateTime|string $value)
    {
        if (is_string($value)) {
            $value = new \DateTime($value);
        }
        $this->currentMeetingTime = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getGlobalObjectId()
    {
        return $this->globalObjectId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return SuggestionsViewOptionsType
     */
    public function setGlobalObjectId($value)
    {
        $this->globalObjectId = $value;
        return $this;
    }
}
