<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing SuggestionDayResultType
 *
 *
 * XSD Type: SuggestionDayResult
 */
class SuggestionDayResultType extends Type
{

    /**
     * @var \DateTime
     */
    protected $date = null;

    /**
     * @var string
     */
    protected $dayQuality = null;

    /**
     * @var \garethp\ews\API\Type\SuggestionType[]
     */
    protected $suggestionArray = null;

    /**
     * @autogenerated This method is safe to replace
     * @return \DateTime
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \DateTime|string
     * @return SuggestionDayResultType
     */
    public function setDate(\DateTime|string $value)
    {
        if (is_string($value)) {
            $value = new \DateTime($value);
        }
        $this->date = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getDayQuality()
    {
        return $this->dayQuality;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return SuggestionDayResultType
     */
    public function setDayQuality($value)
    {
        $this->dayQuality = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value SuggestionType
     * @return SuggestionDayResultType
     */
    public function addSuggestionArray(SuggestionType $value)
    {
        if ($this->suggestionArray === null) {
                        $this->suggestionArray = array();
        }

        if (!is_array($this->suggestionArray)) {
            $this->suggestionArray = array($this->suggestionArray);
        }

        $this->suggestionArray[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return SuggestionType[]
     */
    public function getSuggestionArray()
    {
        return $this->suggestionArray;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value SuggestionType[]|SuggestionType
     * @return SuggestionDayResultType
     */
    public function setSuggestionArray(array|SuggestionType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->suggestionArray = $value;
        return $this;
    }
}
