<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing ServerVersionInfo
 */
class ServerVersionInfo extends Type
{

    /**
     * @var integer
     */
    protected $majorVersion = null;

    /**
     * @var integer
     */
    protected $minorVersion = null;

    /**
     * @var integer
     */
    protected $majorBuildNumber = null;

    /**
     * @var integer
     */
    protected $minorBuildNumber = null;

    /**
     * @var string
     */
    protected $version = null;

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getMajorVersion()
    {
        return $this->majorVersion;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return ServerVersionInfo
     */
    public function setMajorVersion($value)
    {
        $this->majorVersion = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getMinorVersion()
    {
        return $this->minorVersion;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return ServerVersionInfo
     */
    public function setMinorVersion($value)
    {
        $this->minorVersion = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getMajorBuildNumber()
    {
        return $this->majorBuildNumber;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return ServerVersionInfo
     */
    public function setMajorBuildNumber($value)
    {
        $this->majorBuildNumber = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getMinorBuildNumber()
    {
        return $this->minorBuildNumber;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return ServerVersionInfo
     */
    public function setMinorBuildNumber($value)
    {
        $this->minorBuildNumber = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getVersion()
    {
        return $this->version;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ServerVersionInfo
     */
    public function setVersion($value)
    {
        $this->version = $value;
        return $this;
    }
}
