<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing RuleValidationErrorType
 *
 * Represents a single validation error on a particular rule property value,
 * predicate property value or action property value
 * XSD Type: RuleValidationErrorType
 */
class RuleValidationErrorType extends Type
{

    /**
     * @var string
     */
    protected $fieldURI = null;

    /**
     * @var string
     */
    protected $errorCode = null;

    /**
     * @var string
     */
    protected $errorMessage = null;

    /**
     * @var string
     */
    protected $fieldValue = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getFieldURI()
    {
        return $this->fieldURI;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return RuleValidationErrorType
     */
    public function setFieldURI($value)
    {
        $this->fieldURI = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return RuleValidationErrorType
     */
    public function setErrorCode($value)
    {
        $this->errorCode = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return RuleValidationErrorType
     */
    public function setErrorMessage($value)
    {
        $this->errorMessage = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getFieldValue()
    {
        return $this->fieldValue;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return RuleValidationErrorType
     */
    public function setFieldValue($value)
    {
        $this->fieldValue = $value;
        return $this;
    }
}
