<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing RuleActionsType
 *
 * Rule actions
 * XSD Type: RuleActionsType
 */
class RuleActionsType extends Type
{

    /**
     * @var string[]
     */
    protected $assignCategories = null;

    /**
     * @var \garethp\ews\API\Type\TargetFolderIdType
     */
    protected $copyToFolder = null;

    /**
     * @var boolean
     */
    protected $delete = null;

    /**
     * @var \garethp\ews\API\Type\EmailAddressType[]
     */
    protected $forwardAsAttachmentToRecipients = null;

    /**
     * @var \garethp\ews\API\Type\EmailAddressType[]
     */
    protected $forwardToRecipients = null;

    /**
     * @var string
     */
    protected $markImportance = null;

    /**
     * @var boolean
     */
    protected $markAsRead = null;

    /**
     * @var \garethp\ews\API\Type\TargetFolderIdType
     */
    protected $moveToFolder = null;

    /**
     * @var boolean
     */
    protected $permanentDelete = null;

    /**
     * @var \garethp\ews\API\Type\EmailAddressType[]
     */
    protected $redirectToRecipients = null;

    /**
     * @var \garethp\ews\API\Type\EmailAddressType[]
     */
    protected $sendSMSAlertToRecipients = null;

    /**
     * @var \garethp\ews\API\Type\ItemIdType
     */
    protected $serverReplyWithMessage = null;

    /**
     * @var boolean
     */
    protected $stopProcessingRules = null;

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return RuleActionsType
     */
    public function addAssignCategories($value)
    {
        if ($this->assignCategories === null) {
                        $this->assignCategories = array();
        }

        if (!is_array($this->assignCategories)) {
            $this->assignCategories = array($this->assignCategories);
        }

        $this->assignCategories[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getAssignCategories()
    {
        return $this->assignCategories;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return RuleActionsType
     */
    public function setAssignCategories(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->assignCategories = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return TargetFolderIdType
     */
    public function getCopyToFolder()
    {
        return $this->copyToFolder;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value TargetFolderIdType
     * @return RuleActionsType
     */
    public function setCopyToFolder(TargetFolderIdType $value)
    {
        $this->copyToFolder = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isDelete()
    {
        return ((bool) $this->delete);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getDelete()
    {
        return $this->delete;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return RuleActionsType
     */
    public function setDelete($value)
    {
        $this->delete = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value EmailAddressType
     * @return RuleActionsType
     */
    public function addForwardAsAttachmentToRecipients(EmailAddressType $value)
    {
        if ($this->forwardAsAttachmentToRecipients === null) {
                        $this->forwardAsAttachmentToRecipients = array();
        }

        if (!is_array($this->forwardAsAttachmentToRecipients)) {
            $this->forwardAsAttachmentToRecipients = array($this->forwardAsAttachmentToRecipients);
        }

        $this->forwardAsAttachmentToRecipients[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return EmailAddressType[]
     */
    public function getForwardAsAttachmentToRecipients()
    {
        return $this->forwardAsAttachmentToRecipients;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value EmailAddressType[]|EmailAddressType
     * @return RuleActionsType
     */
    public function setForwardAsAttachmentToRecipients(array|EmailAddressType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->forwardAsAttachmentToRecipients = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value EmailAddressType
     * @return RuleActionsType
     */
    public function addForwardToRecipients(EmailAddressType $value)
    {
        if ($this->forwardToRecipients === null) {
                        $this->forwardToRecipients = array();
        }

        if (!is_array($this->forwardToRecipients)) {
            $this->forwardToRecipients = array($this->forwardToRecipients);
        }

        $this->forwardToRecipients[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return EmailAddressType[]
     */
    public function getForwardToRecipients()
    {
        return $this->forwardToRecipients;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value EmailAddressType[]|EmailAddressType
     * @return RuleActionsType
     */
    public function setForwardToRecipients(array|EmailAddressType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->forwardToRecipients = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getMarkImportance()
    {
        return $this->markImportance;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return RuleActionsType
     */
    public function setMarkImportance($value)
    {
        $this->markImportance = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isMarkAsRead()
    {
        return ((bool) $this->markAsRead);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getMarkAsRead()
    {
        return $this->markAsRead;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return RuleActionsType
     */
    public function setMarkAsRead($value)
    {
        $this->markAsRead = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return TargetFolderIdType
     */
    public function getMoveToFolder()
    {
        return $this->moveToFolder;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value TargetFolderIdType
     * @return RuleActionsType
     */
    public function setMoveToFolder(TargetFolderIdType $value)
    {
        $this->moveToFolder = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isPermanentDelete()
    {
        return ((bool) $this->permanentDelete);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getPermanentDelete()
    {
        return $this->permanentDelete;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return RuleActionsType
     */
    public function setPermanentDelete($value)
    {
        $this->permanentDelete = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value EmailAddressType
     * @return RuleActionsType
     */
    public function addRedirectToRecipients(EmailAddressType $value)
    {
        if ($this->redirectToRecipients === null) {
                        $this->redirectToRecipients = array();
        }

        if (!is_array($this->redirectToRecipients)) {
            $this->redirectToRecipients = array($this->redirectToRecipients);
        }

        $this->redirectToRecipients[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return EmailAddressType[]
     */
    public function getRedirectToRecipients()
    {
        return $this->redirectToRecipients;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value EmailAddressType[]|EmailAddressType
     * @return RuleActionsType
     */
    public function setRedirectToRecipients(array|EmailAddressType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->redirectToRecipients = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value EmailAddressType
     * @return RuleActionsType
     */
    public function addSendSMSAlertToRecipients(EmailAddressType $value)
    {
        if ($this->sendSMSAlertToRecipients === null) {
                        $this->sendSMSAlertToRecipients = array();
        }

        if (!is_array($this->sendSMSAlertToRecipients)) {
            $this->sendSMSAlertToRecipients = array($this->sendSMSAlertToRecipients);
        }

        $this->sendSMSAlertToRecipients[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return EmailAddressType[]
     */
    public function getSendSMSAlertToRecipients()
    {
        return $this->sendSMSAlertToRecipients;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value EmailAddressType[]|EmailAddressType
     * @return RuleActionsType
     */
    public function setSendSMSAlertToRecipients(array|EmailAddressType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->sendSMSAlertToRecipients = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ItemIdType
     */
    public function getServerReplyWithMessage()
    {
        return $this->serverReplyWithMessage;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ItemIdType
     * @return RuleActionsType
     */
    public function setServerReplyWithMessage(ItemIdType $value)
    {
        $this->serverReplyWithMessage = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isStopProcessingRules()
    {
        return ((bool) $this->stopProcessingRules);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getStopProcessingRules()
    {
        return $this->stopProcessingRules;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return RuleActionsType
     */
    public function setStopProcessingRules($value)
    {
        $this->stopProcessingRules = $value;
        return $this;
    }
}
