<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing PhysicalAddressDictionaryEntryType
 *
 *
 * XSD Type: PhysicalAddressDictionaryEntryType
 */
class PhysicalAddressDictionaryEntryType extends Type
{

    /**
     * @var string
     */
    protected $key = null;

    /**
     * @var string
     */
    protected $street = null;

    /**
     * @var string
     */
    protected $city = null;

    /**
     * @var string
     */
    protected $state = null;

    /**
     * @var string
     */
    protected $countryOrRegion = null;

    /**
     * @var string
     */
    protected $postalCode = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getKey()
    {
        return $this->key;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return PhysicalAddressDictionaryEntryType
     */
    public function setKey($value)
    {
        $this->key = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return PhysicalAddressDictionaryEntryType
     */
    public function setStreet($value)
    {
        $this->street = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return PhysicalAddressDictionaryEntryType
     */
    public function setCity($value)
    {
        $this->city = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return PhysicalAddressDictionaryEntryType
     */
    public function setState($value)
    {
        $this->state = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getCountryOrRegion()
    {
        return $this->countryOrRegion;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return PhysicalAddressDictionaryEntryType
     */
    public function setCountryOrRegion($value)
    {
        $this->countryOrRegion = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getPostalCode()
    {
        return $this->postalCode;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return PhysicalAddressDictionaryEntryType
     */
    public function setPostalCode($value)
    {
        $this->postalCode = $value;
        return $this;
    }
}
