<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing NonEmptyArrayOfAllItemsType
 *
 *
 * XSD Type: NonEmptyArrayOfAllItemsType
 */
class NonEmptyArrayOfAllItemsType extends Type
{

    /**
     * @var \garethp\ews\API\Type\ItemType[]
     */
    protected $item = null;

    /**
     * @var \garethp\ews\API\Type\MessageType[]
     */
    protected $message = null;

    /**
     * @var \garethp\ews\API\Type\CalendarItemType[]
     */
    protected $calendarItem = null;

    /**
     * @var \garethp\ews\API\Type\ContactItemType[]
     */
    protected $contact = null;

    /**
     * @var \garethp\ews\API\Type\DistributionListType[]
     */
    protected $distributionList = null;

    /**
     * @var \garethp\ews\API\Type\MeetingMessageType[]
     */
    protected $meetingMessage = null;

    /**
     * @var \garethp\ews\API\Type\MeetingRequestMessageType[]
     */
    protected $meetingRequest = null;

    /**
     * @var \garethp\ews\API\Type\MeetingResponseMessageType[]
     */
    protected $meetingResponse = null;

    /**
     * @var \garethp\ews\API\Type\MeetingCancellationMessageType[]
     */
    protected $meetingCancellation = null;

    /**
     * @var \garethp\ews\API\Type\TaskType[]
     */
    protected $task = null;

    /**
     * @var \garethp\ews\API\Type\PostItemType[]
     */
    protected $postItem = null;

    /**
     * @var \garethp\ews\API\Type\ReplyToItemType[]
     */
    protected $replyToItem = null;

    /**
     * @var \garethp\ews\API\Type\ForwardItemType[]
     */
    protected $forwardItem = null;

    /**
     * @var \garethp\ews\API\Type\ReplyAllToItemType[]
     */
    protected $replyAllToItem = null;

    /**
     * @var \garethp\ews\API\Type\AcceptItemType[]
     */
    protected $acceptItem = null;

    /**
     * @var \garethp\ews\API\Type\TentativelyAcceptItemType[]
     */
    protected $tentativelyAcceptItem = null;

    /**
     * @var \garethp\ews\API\Type\DeclineItemType[]
     */
    protected $declineItem = null;

    /**
     * @var \garethp\ews\API\Type\CancelCalendarItemType[]
     */
    protected $cancelCalendarItem = null;

    /**
     * @var \garethp\ews\API\Type\RemoveItemType[]
     */
    protected $removeItem = null;

    /**
     * @var \garethp\ews\API\Type\SuppressReadReceiptType[]
     */
    protected $suppressReadReceipt = null;

    /**
     * @var \garethp\ews\API\Type\PostReplyItemType[]
     */
    protected $postReplyItem = null;

    /**
     * @var \garethp\ews\API\Type\AcceptSharingInvitationType[]
     */
    protected $acceptSharingInvitation = null;

    /**
     * @autogenerated This method is safe to replace
     * @param $value ItemType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function addItem(ItemType $value)
    {
        if ($this->item === null) {
                        $this->item = array();
        }

        if (!is_array($this->item)) {
            $this->item = array($this->item);
        }

        $this->item[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ItemType[]
     */
    public function getItem()
    {
        return $this->item;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ItemType[]|ItemType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function setItem(array|ItemType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->item = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value MessageType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function addMessage(MessageType $value)
    {
        if ($this->message === null) {
                        $this->message = array();
        }

        if (!is_array($this->message)) {
            $this->message = array($this->message);
        }

        $this->message[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return MessageType[]
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value MessageType[]|MessageType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function setMessage(array|MessageType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->message = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value CalendarItemType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function addCalendarItem(CalendarItemType $value)
    {
        if ($this->calendarItem === null) {
                        $this->calendarItem = array();
        }

        if (!is_array($this->calendarItem)) {
            $this->calendarItem = array($this->calendarItem);
        }

        $this->calendarItem[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return CalendarItemType[]
     */
    public function getCalendarItem()
    {
        return $this->calendarItem;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value CalendarItemType[]|CalendarItemType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function setCalendarItem(array|CalendarItemType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->calendarItem = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ContactItemType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function addContact(ContactItemType $value)
    {
        if ($this->contact === null) {
                        $this->contact = array();
        }

        if (!is_array($this->contact)) {
            $this->contact = array($this->contact);
        }

        $this->contact[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ContactItemType[]
     */
    public function getContact()
    {
        return $this->contact;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ContactItemType[]|ContactItemType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function setContact(array|ContactItemType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->contact = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value DistributionListType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function addDistributionList(DistributionListType $value)
    {
        if ($this->distributionList === null) {
                        $this->distributionList = array();
        }

        if (!is_array($this->distributionList)) {
            $this->distributionList = array($this->distributionList);
        }

        $this->distributionList[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return DistributionListType[]
     */
    public function getDistributionList()
    {
        return $this->distributionList;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value DistributionListType[]|DistributionListType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function setDistributionList(array|DistributionListType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->distributionList = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value MeetingMessageType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function addMeetingMessage(MeetingMessageType $value)
    {
        if ($this->meetingMessage === null) {
                        $this->meetingMessage = array();
        }

        if (!is_array($this->meetingMessage)) {
            $this->meetingMessage = array($this->meetingMessage);
        }

        $this->meetingMessage[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return MeetingMessageType[]
     */
    public function getMeetingMessage()
    {
        return $this->meetingMessage;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value MeetingMessageType[]|MeetingMessageType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function setMeetingMessage(array|MeetingMessageType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->meetingMessage = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value MeetingRequestMessageType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function addMeetingRequest(MeetingRequestMessageType $value)
    {
        if ($this->meetingRequest === null) {
                        $this->meetingRequest = array();
        }

        if (!is_array($this->meetingRequest)) {
            $this->meetingRequest = array($this->meetingRequest);
        }

        $this->meetingRequest[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return MeetingRequestMessageType[]
     */
    public function getMeetingRequest()
    {
        return $this->meetingRequest;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value MeetingRequestMessageType[]|MeetingRequestMessageType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function setMeetingRequest(array|MeetingRequestMessageType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->meetingRequest = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value MeetingResponseMessageType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function addMeetingResponse(MeetingResponseMessageType $value)
    {
        if ($this->meetingResponse === null) {
                        $this->meetingResponse = array();
        }

        if (!is_array($this->meetingResponse)) {
            $this->meetingResponse = array($this->meetingResponse);
        }

        $this->meetingResponse[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return MeetingResponseMessageType[]
     */
    public function getMeetingResponse()
    {
        return $this->meetingResponse;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value MeetingMessageType[]|MeetingMessageType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function setMeetingResponse(array|MeetingMessageType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->meetingResponse = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value MeetingCancellationMessageType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function addMeetingCancellation(MeetingCancellationMessageType $value)
    {
        if ($this->meetingCancellation === null) {
                        $this->meetingCancellation = array();
        }

        if (!is_array($this->meetingCancellation)) {
            $this->meetingCancellation = array($this->meetingCancellation);
        }

        $this->meetingCancellation[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return MeetingCancellationMessageType[]
     */
    public function getMeetingCancellation()
    {
        return $this->meetingCancellation;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value MeetingMessageType[]|MeetingMessageType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function setMeetingCancellation(array|MeetingMessageType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->meetingCancellation = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value TaskType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function addTask(TaskType $value)
    {
        if ($this->task === null) {
                        $this->task = array();
        }

        if (!is_array($this->task)) {
            $this->task = array($this->task);
        }

        $this->task[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return TaskType[]
     */
    public function getTask()
    {
        return $this->task;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value TaskType[]|TaskType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function setTask(array|TaskType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->task = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value PostItemType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function addPostItem(PostItemType $value)
    {
        if ($this->postItem === null) {
                        $this->postItem = array();
        }

        if (!is_array($this->postItem)) {
            $this->postItem = array($this->postItem);
        }

        $this->postItem[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return PostItemType[]
     */
    public function getPostItem()
    {
        return $this->postItem;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value PostItemType[]|PostItemType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function setPostItem(array|PostItemType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->postItem = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ReplyToItemType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function addReplyToItem(ReplyToItemType $value)
    {
        if ($this->replyToItem === null) {
                        $this->replyToItem = array();
        }

        if (!is_array($this->replyToItem)) {
            $this->replyToItem = array($this->replyToItem);
        }

        $this->replyToItem[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ReplyToItemType[]
     */
    public function getReplyToItem()
    {
        return $this->replyToItem;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value SmartResponseType[]|SmartResponseType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function setReplyToItem(array|SmartResponseType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->replyToItem = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ForwardItemType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function addForwardItem(ForwardItemType $value)
    {
        if ($this->forwardItem === null) {
                        $this->forwardItem = array();
        }

        if (!is_array($this->forwardItem)) {
            $this->forwardItem = array($this->forwardItem);
        }

        $this->forwardItem[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ForwardItemType[]
     */
    public function getForwardItem()
    {
        return $this->forwardItem;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value SmartResponseType[]|SmartResponseType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function setForwardItem(array|SmartResponseType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->forwardItem = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ReplyAllToItemType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function addReplyAllToItem(ReplyAllToItemType $value)
    {
        if ($this->replyAllToItem === null) {
                        $this->replyAllToItem = array();
        }

        if (!is_array($this->replyAllToItem)) {
            $this->replyAllToItem = array($this->replyAllToItem);
        }

        $this->replyAllToItem[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ReplyAllToItemType[]
     */
    public function getReplyAllToItem()
    {
        return $this->replyAllToItem;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value SmartResponseType[]|SmartResponseType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function setReplyAllToItem(array|SmartResponseType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->replyAllToItem = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value AcceptItemType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function addAcceptItem(AcceptItemType $value)
    {
        if ($this->acceptItem === null) {
                        $this->acceptItem = array();
        }

        if (!is_array($this->acceptItem)) {
            $this->acceptItem = array($this->acceptItem);
        }

        $this->acceptItem[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return AcceptItemType[]
     */
    public function getAcceptItem()
    {
        return $this->acceptItem;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ResponseObjectType[]|ResponseObjectType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function setAcceptItem(array|ResponseObjectType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->acceptItem = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value TentativelyAcceptItemType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function addTentativelyAcceptItem(TentativelyAcceptItemType $value)
    {
        if ($this->tentativelyAcceptItem === null) {
                        $this->tentativelyAcceptItem = array();
        }

        if (!is_array($this->tentativelyAcceptItem)) {
            $this->tentativelyAcceptItem = array($this->tentativelyAcceptItem);
        }

        $this->tentativelyAcceptItem[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return TentativelyAcceptItemType[]
     */
    public function getTentativelyAcceptItem()
    {
        return $this->tentativelyAcceptItem;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ResponseObjectType[]|ResponseObjectType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function setTentativelyAcceptItem(array|ResponseObjectType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->tentativelyAcceptItem = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value DeclineItemType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function addDeclineItem(DeclineItemType $value)
    {
        if ($this->declineItem === null) {
                        $this->declineItem = array();
        }

        if (!is_array($this->declineItem)) {
            $this->declineItem = array($this->declineItem);
        }

        $this->declineItem[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return DeclineItemType[]
     */
    public function getDeclineItem()
    {
        return $this->declineItem;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ResponseObjectType[]|ResponseObjectType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function setDeclineItem(array|ResponseObjectType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->declineItem = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value CancelCalendarItemType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function addCancelCalendarItem(CancelCalendarItemType $value)
    {
        if ($this->cancelCalendarItem === null) {
                        $this->cancelCalendarItem = array();
        }

        if (!is_array($this->cancelCalendarItem)) {
            $this->cancelCalendarItem = array($this->cancelCalendarItem);
        }

        $this->cancelCalendarItem[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return CancelCalendarItemType[]
     */
    public function getCancelCalendarItem()
    {
        return $this->cancelCalendarItem;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value SmartResponseType[]|SmartResponseType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function setCancelCalendarItem(array|SmartResponseType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->cancelCalendarItem = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value RemoveItemType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function addRemoveItem(RemoveItemType $value)
    {
        if ($this->removeItem === null) {
                        $this->removeItem = array();
        }

        if (!is_array($this->removeItem)) {
            $this->removeItem = array($this->removeItem);
        }

        $this->removeItem[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return RemoveItemType[]
     */
    public function getRemoveItem()
    {
        return $this->removeItem;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ResponseObjectType[]|ResponseObjectType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function setRemoveItem(array|ResponseObjectType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->removeItem = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value SuppressReadReceiptType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function addSuppressReadReceipt(SuppressReadReceiptType $value)
    {
        if ($this->suppressReadReceipt === null) {
                        $this->suppressReadReceipt = array();
        }

        if (!is_array($this->suppressReadReceipt)) {
            $this->suppressReadReceipt = array($this->suppressReadReceipt);
        }

        $this->suppressReadReceipt[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return SuppressReadReceiptType[]
     */
    public function getSuppressReadReceipt()
    {
        return $this->suppressReadReceipt;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ResponseObjectType[]|ResponseObjectType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function setSuppressReadReceipt(array|ResponseObjectType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->suppressReadReceipt = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value PostReplyItemType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function addPostReplyItem(PostReplyItemType $value)
    {
        if ($this->postReplyItem === null) {
                        $this->postReplyItem = array();
        }

        if (!is_array($this->postReplyItem)) {
            $this->postReplyItem = array($this->postReplyItem);
        }

        $this->postReplyItem[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return PostReplyItemType[]
     */
    public function getPostReplyItem()
    {
        return $this->postReplyItem;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value PostReplyItemType[]|PostReplyItemType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function setPostReplyItem(array|PostReplyItemType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->postReplyItem = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value AcceptSharingInvitationType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function addAcceptSharingInvitation(AcceptSharingInvitationType $value)
    {
        if ($this->acceptSharingInvitation === null) {
                        $this->acceptSharingInvitation = array();
        }

        if (!is_array($this->acceptSharingInvitation)) {
            $this->acceptSharingInvitation = array($this->acceptSharingInvitation);
        }

        $this->acceptSharingInvitation[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return AcceptSharingInvitationType[]
     */
    public function getAcceptSharingInvitation()
    {
        return $this->acceptSharingInvitation;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ResponseObjectType[]|ResponseObjectType
     * @return NonEmptyArrayOfAllItemsType
     */
    public function setAcceptSharingInvitation(array|ResponseObjectType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->acceptSharingInvitation = $value;
        return $this;
    }
}
