<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing MailboxDataType
 *
 *
 * XSD Type: MailboxData
 */
class MailboxDataType extends Type
{

    /**
     * @var \garethp\ews\API\Type\EmailAddressType
     */
    protected $email = null;

    /**
     * @var string
     */
    protected $attendeeType = null;

    /**
     * @var boolean
     */
    protected $excludeConflicts = null;

    /**
     * @autogenerated This method is safe to replace
     * @return EmailAddressType
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value EmailAddressType
     * @return MailboxDataType
     */
    public function setEmail(EmailAddressType $value)
    {
        $this->email = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getAttendeeType()
    {
        return $this->attendeeType;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return MailboxDataType
     */
    public function setAttendeeType($value)
    {
        $this->attendeeType = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isExcludeConflicts()
    {
        return ((bool) $this->excludeConflicts);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getExcludeConflicts()
    {
        return $this->excludeConflicts;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return MailboxDataType
     */
    public function setExcludeConflicts($value)
    {
        $this->excludeConflicts = $value;
        return $this;
    }
}
