<?php

namespace garethp\ews\API\Type;

/**
 * Class representing MailTipsServiceConfigurationType
 *
 *
 * XSD Type: MailTipsServiceConfiguration
 */
class MailTipsServiceConfigurationType extends ServiceConfigurationType
{

    /**
     * @var boolean
     */
    protected $mailTipsEnabled = null;

    /**
     * @var integer
     */
    protected $maxRecipientsPerGetMailTipsRequest = null;

    /**
     * @var integer
     */
    protected $maxMessageSize = null;

    /**
     * @var integer
     */
    protected $largeAudienceThreshold = null;

    /**
     * @var boolean
     */
    protected $showExternalRecipientCount = null;

    /**
     * @var \garethp\ews\API\Type\SmtpDomainType[]
     */
    protected $internalDomains = null;

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isMailTipsEnabled()
    {
        return ((bool) $this->mailTipsEnabled);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getMailTipsEnabled()
    {
        return $this->mailTipsEnabled;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return MailTipsServiceConfigurationType
     */
    public function setMailTipsEnabled($value)
    {
        $this->mailTipsEnabled = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getMaxRecipientsPerGetMailTipsRequest()
    {
        return $this->maxRecipientsPerGetMailTipsRequest;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return MailTipsServiceConfigurationType
     */
    public function setMaxRecipientsPerGetMailTipsRequest($value)
    {
        $this->maxRecipientsPerGetMailTipsRequest = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getMaxMessageSize()
    {
        return $this->maxMessageSize;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return MailTipsServiceConfigurationType
     */
    public function setMaxMessageSize($value)
    {
        $this->maxMessageSize = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getLargeAudienceThreshold()
    {
        return $this->largeAudienceThreshold;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return MailTipsServiceConfigurationType
     */
    public function setLargeAudienceThreshold($value)
    {
        $this->largeAudienceThreshold = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isShowExternalRecipientCount()
    {
        return ((bool) $this->showExternalRecipientCount);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getShowExternalRecipientCount()
    {
        return $this->showExternalRecipientCount;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return MailTipsServiceConfigurationType
     */
    public function setShowExternalRecipientCount($value)
    {
        $this->showExternalRecipientCount = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value SmtpDomainType
     * @return MailTipsServiceConfigurationType
     */
    public function addInternalDomains(SmtpDomainType $value)
    {
        if ($this->internalDomains === null) {
                        $this->internalDomains = array();
        }

        if (!is_array($this->internalDomains)) {
            $this->internalDomains = array($this->internalDomains);
        }

        $this->internalDomains[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return SmtpDomainType[]
     */
    public function getInternalDomains()
    {
        return $this->internalDomains;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value SmtpDomainType[]|SmtpDomainType
     * @return MailTipsServiceConfigurationType
     */
    public function setInternalDomains(array|SmtpDomainType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->internalDomains = $value;
        return $this;
    }
}
