<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing ItemResponseShapeType
 *
 *
 * XSD Type: ItemResponseShapeType
 */
class ItemResponseShapeType extends Type
{

    /**
     * @var string
     */
    protected $baseShape = null;

    /**
     * @var boolean
     */
    protected $includeMimeContent = null;

    /**
     * @var string
     */
    protected $bodyType = null;

    /**
     * @var boolean
     */
    protected $filterHtmlContent = null;

    /**
     * @var boolean
     */
    protected $convertHtmlCodePageToUTF8 = null;

    /**
     * @var \garethp\ews\API\Type\NonEmptyArrayOfPathsToElementType
     */
    protected $additionalProperties = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getBaseShape()
    {
        return $this->baseShape;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ItemResponseShapeType
     */
    public function setBaseShape($value)
    {
        $this->baseShape = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isIncludeMimeContent()
    {
        return ((bool) $this->includeMimeContent);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getIncludeMimeContent()
    {
        return $this->includeMimeContent;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return ItemResponseShapeType
     */
    public function setIncludeMimeContent($value)
    {
        $this->includeMimeContent = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getBodyType()
    {
        return $this->bodyType;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ItemResponseShapeType
     */
    public function setBodyType($value)
    {
        $this->bodyType = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isFilterHtmlContent()
    {
        return ((bool) $this->filterHtmlContent);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getFilterHtmlContent()
    {
        return $this->filterHtmlContent;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return ItemResponseShapeType
     */
    public function setFilterHtmlContent($value)
    {
        $this->filterHtmlContent = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isConvertHtmlCodePageToUTF8()
    {
        return ((bool) $this->convertHtmlCodePageToUTF8);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getConvertHtmlCodePageToUTF8()
    {
        return $this->convertHtmlCodePageToUTF8;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return ItemResponseShapeType
     */
    public function setConvertHtmlCodePageToUTF8($value)
    {
        $this->convertHtmlCodePageToUTF8 = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return NonEmptyArrayOfPathsToElementType
     */
    public function getAdditionalProperties()
    {
        return $this->additionalProperties;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value NonEmptyArrayOfPathsToElementType
     * @return ItemResponseShapeType
     */
    public function setAdditionalProperties(NonEmptyArrayOfPathsToElementType $value)
    {
        $this->additionalProperties = $value;
        return $this;
    }
}
