<?php

namespace garethp\ews\API\Type;

/**
 * Class representing ItemIdType
 *
 * Identifier for a fully resolved item
 * XSD Type: ItemIdType
 */
class ItemIdType extends BaseItemIdType
{

    /**
     * @var string
     */
    protected $id = null;

    /**
     * @var string
     */
    protected $changeKey = null;

    public function __construct($id = null, $changeKey = null)
    {
        $this->id = $id;
        $this->changeKey = $changeKey;
    }

    public function toArray()
    {
        return ['Id' => $this->id, 'ChangeKey' => $this->changeKey ];
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ItemIdType
     */
    public function setId($value)
    {
        $this->id = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getChangeKey()
    {
        return $this->changeKey;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ItemIdType
     */
    public function setChangeKey($value)
    {
        $this->changeKey = $value;
        return $this;
    }
}
