<?php

namespace garethp\ews\API\Type;

/**
 * Class representing GroupByType
 *
 * Allows consumers to specify arbitrary groupings for FindItem queries.
 * XSD Type: GroupByType
 */
class GroupByType extends BaseGroupByType
{

    /**
     * @var \garethp\ews\API\Type\PathToUnindexedFieldType
     */
    protected $fieldURI = null;

    /**
     * @var \garethp\ews\API\Type\PathToIndexedFieldType
     */
    protected $indexedFieldURI = null;

    /**
     * @var \garethp\ews\API\Type\PathToExtendedFieldType
     */
    protected $extendedFieldURI = null;

    /**
     * @var \garethp\ews\API\Type\AggregateOnType
     */
    protected $aggregateOn = null;

    /**
     * @autogenerated This method is safe to replace
     * @return PathToUnindexedFieldType
     */
    public function getFieldURI()
    {
        return $this->fieldURI;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value PathToUnindexedFieldType
     * @return GroupByType
     */
    public function setFieldURI(PathToUnindexedFieldType $value)
    {
        $this->fieldURI = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return PathToIndexedFieldType
     */
    public function getIndexedFieldURI()
    {
        return $this->indexedFieldURI;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value PathToIndexedFieldType
     * @return GroupByType
     */
    public function setIndexedFieldURI(PathToIndexedFieldType $value)
    {
        $this->indexedFieldURI = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return PathToExtendedFieldType
     */
    public function getExtendedFieldURI()
    {
        return $this->extendedFieldURI;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value PathToExtendedFieldType
     * @return GroupByType
     */
    public function setExtendedFieldURI(PathToExtendedFieldType $value)
    {
        $this->extendedFieldURI = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return AggregateOnType
     */
    public function getAggregateOn()
    {
        return $this->aggregateOn;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value AggregateOnType
     * @return GroupByType
     */
    public function setAggregateOn(AggregateOnType $value)
    {
        $this->aggregateOn = $value;
        return $this;
    }
}
