<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing FreeBusyViewOptionsType
 *
 *
 * XSD Type: FreeBusyViewOptionsType
 */
class FreeBusyViewOptionsType extends Type
{

    /**
     * @var \garethp\ews\API\Type\DurationType
     */
    protected $timeWindow = null;

    /**
     * @var integer
     */
    protected $mergedFreeBusyIntervalInMinutes = null;

    /**
     * @var string[]
     */
    protected $requestedView = null;

    /**
     * @autogenerated This method is safe to replace
     * @return DurationType
     */
    public function getTimeWindow()
    {
        return $this->timeWindow;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value DurationType
     * @return FreeBusyViewOptionsType
     */
    public function setTimeWindow(DurationType $value)
    {
        $this->timeWindow = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getMergedFreeBusyIntervalInMinutes()
    {
        return $this->mergedFreeBusyIntervalInMinutes;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return FreeBusyViewOptionsType
     */
    public function setMergedFreeBusyIntervalInMinutes($value)
    {
        $this->mergedFreeBusyIntervalInMinutes = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return FreeBusyViewOptionsType
     */
    public function addRequestedView($value)
    {
        if ($this->requestedView === null) {
                        $this->requestedView = array();
        }

        if (!is_array($this->requestedView)) {
            $this->requestedView = array($this->requestedView);
        }

        $this->requestedView[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getRequestedView()
    {
        return $this->requestedView;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return FreeBusyViewOptionsType
     */
    public function setRequestedView(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->requestedView = $value;
        return $this;
    }
}
