<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing ConversationType
 *
 *
 * XSD Type: ConversationType
 */
class ConversationType extends Type
{

    /**
     * @var \garethp\ews\API\Type\ItemIdType
     */
    protected $conversationId = null;

    /**
     * @var string
     */
    protected $conversationTopic = null;

    /**
     * @var string[]
     */
    protected $uniqueRecipients = null;

    /**
     * @var string[]
     */
    protected $globalUniqueRecipients = null;

    /**
     * @var string[]
     */
    protected $uniqueUnreadSenders = null;

    /**
     * @var string[]
     */
    protected $globalUniqueUnreadSenders = null;

    /**
     * @var string[]
     */
    protected $uniqueSenders = null;

    /**
     * @var string[]
     */
    protected $globalUniqueSenders = null;

    /**
     * @var \DateTime
     */
    protected $lastDeliveryTime = null;

    /**
     * @var \DateTime
     */
    protected $globalLastDeliveryTime = null;

    /**
     * @var string[]
     */
    protected $categories = null;

    /**
     * @var string[]
     */
    protected $globalCategories = null;

    /**
     * @var string
     */
    protected $flagStatus = null;

    /**
     * @var string
     */
    protected $globalFlagStatus = null;

    /**
     * @var boolean
     */
    protected $hasAttachments = null;

    /**
     * @var boolean
     */
    protected $globalHasAttachments = null;

    /**
     * @var integer
     */
    protected $messageCount = null;

    /**
     * @var integer
     */
    protected $globalMessageCount = null;

    /**
     * @var integer
     */
    protected $unreadCount = null;

    /**
     * @var integer
     */
    protected $globalUnreadCount = null;

    /**
     * @var integer
     */
    protected $size = null;

    /**
     * @var integer
     */
    protected $globalSize = null;

    /**
     * @var string[]
     */
    protected $itemClasses = null;

    /**
     * @var string[]
     */
    protected $globalItemClasses = null;

    /**
     * @var string
     */
    protected $importance = null;

    /**
     * @var string
     */
    protected $globalImportance = null;

    /**
     * @var \garethp\ews\API\Type\NonEmptyArrayOfBaseItemIdsType
     */
    protected $itemIds = null;

    /**
     * @var \garethp\ews\API\Type\NonEmptyArrayOfBaseItemIdsType
     */
    protected $globalItemIds = null;

    /**
     * @autogenerated This method is safe to replace
     * @return ItemIdType
     */
    public function getConversationId()
    {
        return $this->conversationId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ItemIdType
     * @return ConversationType
     */
    public function setConversationId(ItemIdType $value)
    {
        $this->conversationId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getConversationTopic()
    {
        return $this->conversationTopic;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ConversationType
     */
    public function setConversationTopic($value)
    {
        $this->conversationTopic = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ConversationType
     */
    public function addUniqueRecipients($value)
    {
        if ($this->uniqueRecipients === null) {
                        $this->uniqueRecipients = array();
        }

        if (!is_array($this->uniqueRecipients)) {
            $this->uniqueRecipients = array($this->uniqueRecipients);
        }

        $this->uniqueRecipients[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getUniqueRecipients()
    {
        return $this->uniqueRecipients;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return ConversationType
     */
    public function setUniqueRecipients(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->uniqueRecipients = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ConversationType
     */
    public function addGlobalUniqueRecipients($value)
    {
        if ($this->globalUniqueRecipients === null) {
                        $this->globalUniqueRecipients = array();
        }

        if (!is_array($this->globalUniqueRecipients)) {
            $this->globalUniqueRecipients = array($this->globalUniqueRecipients);
        }

        $this->globalUniqueRecipients[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getGlobalUniqueRecipients()
    {
        return $this->globalUniqueRecipients;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return ConversationType
     */
    public function setGlobalUniqueRecipients(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->globalUniqueRecipients = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ConversationType
     */
    public function addUniqueUnreadSenders($value)
    {
        if ($this->uniqueUnreadSenders === null) {
                        $this->uniqueUnreadSenders = array();
        }

        if (!is_array($this->uniqueUnreadSenders)) {
            $this->uniqueUnreadSenders = array($this->uniqueUnreadSenders);
        }

        $this->uniqueUnreadSenders[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getUniqueUnreadSenders()
    {
        return $this->uniqueUnreadSenders;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return ConversationType
     */
    public function setUniqueUnreadSenders(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->uniqueUnreadSenders = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ConversationType
     */
    public function addGlobalUniqueUnreadSenders($value)
    {
        if ($this->globalUniqueUnreadSenders === null) {
                        $this->globalUniqueUnreadSenders = array();
        }

        if (!is_array($this->globalUniqueUnreadSenders)) {
            $this->globalUniqueUnreadSenders = array($this->globalUniqueUnreadSenders);
        }

        $this->globalUniqueUnreadSenders[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getGlobalUniqueUnreadSenders()
    {
        return $this->globalUniqueUnreadSenders;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return ConversationType
     */
    public function setGlobalUniqueUnreadSenders(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->globalUniqueUnreadSenders = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ConversationType
     */
    public function addUniqueSenders($value)
    {
        if ($this->uniqueSenders === null) {
                        $this->uniqueSenders = array();
        }

        if (!is_array($this->uniqueSenders)) {
            $this->uniqueSenders = array($this->uniqueSenders);
        }

        $this->uniqueSenders[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getUniqueSenders()
    {
        return $this->uniqueSenders;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return ConversationType
     */
    public function setUniqueSenders(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->uniqueSenders = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ConversationType
     */
    public function addGlobalUniqueSenders($value)
    {
        if ($this->globalUniqueSenders === null) {
                        $this->globalUniqueSenders = array();
        }

        if (!is_array($this->globalUniqueSenders)) {
            $this->globalUniqueSenders = array($this->globalUniqueSenders);
        }

        $this->globalUniqueSenders[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getGlobalUniqueSenders()
    {
        return $this->globalUniqueSenders;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return ConversationType
     */
    public function setGlobalUniqueSenders(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->globalUniqueSenders = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \DateTime
     */
    public function getLastDeliveryTime()
    {
        return $this->lastDeliveryTime;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \DateTime|string
     * @return ConversationType
     */
    public function setLastDeliveryTime(\DateTime|string $value)
    {
        if (is_string($value)) {
            $value = new \DateTime($value);
        }
        $this->lastDeliveryTime = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \DateTime
     */
    public function getGlobalLastDeliveryTime()
    {
        return $this->globalLastDeliveryTime;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \DateTime|string
     * @return ConversationType
     */
    public function setGlobalLastDeliveryTime(\DateTime|string $value)
    {
        if (is_string($value)) {
            $value = new \DateTime($value);
        }
        $this->globalLastDeliveryTime = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ConversationType
     */
    public function addCategories($value)
    {
        if ($this->categories === null) {
                        $this->categories = array();
        }

        if (!is_array($this->categories)) {
            $this->categories = array($this->categories);
        }

        $this->categories[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getCategories()
    {
        return $this->categories;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return ConversationType
     */
    public function setCategories(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->categories = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ConversationType
     */
    public function addGlobalCategories($value)
    {
        if ($this->globalCategories === null) {
                        $this->globalCategories = array();
        }

        if (!is_array($this->globalCategories)) {
            $this->globalCategories = array($this->globalCategories);
        }

        $this->globalCategories[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getGlobalCategories()
    {
        return $this->globalCategories;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return ConversationType
     */
    public function setGlobalCategories(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->globalCategories = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getFlagStatus()
    {
        return $this->flagStatus;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ConversationType
     */
    public function setFlagStatus($value)
    {
        $this->flagStatus = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getGlobalFlagStatus()
    {
        return $this->globalFlagStatus;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ConversationType
     */
    public function setGlobalFlagStatus($value)
    {
        $this->globalFlagStatus = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isHasAttachments()
    {
        return ((bool) $this->hasAttachments);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getHasAttachments()
    {
        return $this->hasAttachments;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return ConversationType
     */
    public function setHasAttachments($value)
    {
        $this->hasAttachments = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isGlobalHasAttachments()
    {
        return ((bool) $this->globalHasAttachments);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getGlobalHasAttachments()
    {
        return $this->globalHasAttachments;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return ConversationType
     */
    public function setGlobalHasAttachments($value)
    {
        $this->globalHasAttachments = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getMessageCount()
    {
        return $this->messageCount;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return ConversationType
     */
    public function setMessageCount($value)
    {
        $this->messageCount = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getGlobalMessageCount()
    {
        return $this->globalMessageCount;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return ConversationType
     */
    public function setGlobalMessageCount($value)
    {
        $this->globalMessageCount = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getUnreadCount()
    {
        return $this->unreadCount;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return ConversationType
     */
    public function setUnreadCount($value)
    {
        $this->unreadCount = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getGlobalUnreadCount()
    {
        return $this->globalUnreadCount;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return ConversationType
     */
    public function setGlobalUnreadCount($value)
    {
        $this->globalUnreadCount = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getSize()
    {
        return $this->size;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return ConversationType
     */
    public function setSize($value)
    {
        $this->size = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getGlobalSize()
    {
        return $this->globalSize;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return ConversationType
     */
    public function setGlobalSize($value)
    {
        $this->globalSize = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ConversationType
     */
    public function addItemClasses($value)
    {
        if ($this->itemClasses === null) {
                        $this->itemClasses = array();
        }

        if (!is_array($this->itemClasses)) {
            $this->itemClasses = array($this->itemClasses);
        }

        $this->itemClasses[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getItemClasses()
    {
        return $this->itemClasses;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return ConversationType
     */
    public function setItemClasses(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->itemClasses = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ConversationType
     */
    public function addGlobalItemClasses($value)
    {
        if ($this->globalItemClasses === null) {
                        $this->globalItemClasses = array();
        }

        if (!is_array($this->globalItemClasses)) {
            $this->globalItemClasses = array($this->globalItemClasses);
        }

        $this->globalItemClasses[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getGlobalItemClasses()
    {
        return $this->globalItemClasses;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return ConversationType
     */
    public function setGlobalItemClasses(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->globalItemClasses = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getImportance()
    {
        return $this->importance;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ConversationType
     */
    public function setImportance($value)
    {
        $this->importance = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getGlobalImportance()
    {
        return $this->globalImportance;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ConversationType
     */
    public function setGlobalImportance($value)
    {
        $this->globalImportance = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return NonEmptyArrayOfBaseItemIdsType
     */
    public function getItemIds()
    {
        return $this->itemIds;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value NonEmptyArrayOfBaseItemIdsType
     * @return ConversationType
     */
    public function setItemIds(NonEmptyArrayOfBaseItemIdsType $value)
    {
        $this->itemIds = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return NonEmptyArrayOfBaseItemIdsType
     */
    public function getGlobalItemIds()
    {
        return $this->globalItemIds;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value NonEmptyArrayOfBaseItemIdsType
     * @return ConversationType
     */
    public function setGlobalItemIds(NonEmptyArrayOfBaseItemIdsType $value)
    {
        $this->globalItemIds = $value;
        return $this;
    }
}
