<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing CalendarEventType
 *
 *
 * XSD Type: CalendarEvent
 */
class CalendarEventType extends Type
{

    /**
     * @var \DateTime
     */
    protected $startTime = null;

    /**
     * @var \DateTime
     */
    protected $endTime = null;

    /**
     * @var string
     */
    protected $busyType = null;

    /**
     * @var \garethp\ews\API\Type\CalendarEventDetailsType
     */
    protected $calendarEventDetails = null;

    /**
     * @autogenerated This method is safe to replace
     * @return \DateTime
     */
    public function getStartTime()
    {
        return $this->startTime;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \DateTime|string
     * @return CalendarEventType
     */
    public function setStartTime(\DateTime|string $value)
    {
        if (is_string($value)) {
            $value = new \DateTime($value);
        }
        $this->startTime = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \DateTime
     */
    public function getEndTime()
    {
        return $this->endTime;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \DateTime|string
     * @return CalendarEventType
     */
    public function setEndTime(\DateTime|string $value)
    {
        if (is_string($value)) {
            $value = new \DateTime($value);
        }
        $this->endTime = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getBusyType()
    {
        return $this->busyType;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return CalendarEventType
     */
    public function setBusyType($value)
    {
        $this->busyType = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return CalendarEventDetailsType
     */
    public function getCalendarEventDetails()
    {
        return $this->calendarEventDetails;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value CalendarEventDetailsType
     * @return CalendarEventType
     */
    public function setCalendarEventDetails(CalendarEventDetailsType $value)
    {
        $this->calendarEventDetails = $value;
        return $this;
    }
}
