<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing BaseFolderType
 *
 *
 * XSD Type: BaseFolderType
 */
class BaseFolderType extends Type
{

    /**
     * @var \garethp\ews\API\Type\FolderIdType
     */
    protected $folderId = null;

    /**
     * @var \garethp\ews\API\Type\FolderIdType
     */
    protected $parentFolderId = null;

    /**
     * @var string
     */
    protected $folderClass = null;

    /**
     * @var string
     */
    protected $displayName = null;

    /**
     * @var integer
     */
    protected $totalCount = null;

    /**
     * @var integer
     */
    protected $childFolderCount = null;

    /**
     * @var \garethp\ews\API\Type\ExtendedPropertyType[]
     */
    protected $extendedProperty = null;

    /**
     * @var \garethp\ews\API\Type\ManagedFolderInformationType
     */
    protected $managedFolderInformation = null;

    /**
     * @var \garethp\ews\API\Type\EffectiveRightsType
     */
    protected $effectiveRights = null;

    /**
     * @autogenerated This method is safe to replace
     * @return FolderIdType
     */
    public function getFolderId()
    {
        return $this->folderId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value FolderIdType
     * @return BaseFolderType
     */
    public function setFolderId(FolderIdType $value)
    {
        $this->folderId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return FolderIdType
     */
    public function getParentFolderId()
    {
        return $this->parentFolderId;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value FolderIdType
     * @return BaseFolderType
     */
    public function setParentFolderId(FolderIdType $value)
    {
        $this->parentFolderId = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getFolderClass()
    {
        return $this->folderClass;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return BaseFolderType
     */
    public function setFolderClass($value)
    {
        $this->folderClass = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getDisplayName()
    {
        return $this->displayName;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return BaseFolderType
     */
    public function setDisplayName($value)
    {
        $this->displayName = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getTotalCount()
    {
        return $this->totalCount;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return BaseFolderType
     */
    public function setTotalCount($value)
    {
        $this->totalCount = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getChildFolderCount()
    {
        return $this->childFolderCount;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return BaseFolderType
     */
    public function setChildFolderCount($value)
    {
        $this->childFolderCount = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ExtendedPropertyType
     * @return BaseFolderType
     */
    public function addExtendedProperty(ExtendedPropertyType $value)
    {
        if ($this->extendedProperty === null) {
                        $this->extendedProperty = array();
        }

        if (!is_array($this->extendedProperty)) {
            $this->extendedProperty = array($this->extendedProperty);
        }

        $this->extendedProperty[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ExtendedPropertyType[]
     */
    public function getExtendedProperty()
    {
        return $this->extendedProperty;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ExtendedPropertyType[]|ExtendedPropertyType
     * @return BaseFolderType
     */
    public function setExtendedProperty(array|ExtendedPropertyType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->extendedProperty = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ManagedFolderInformationType
     */
    public function getManagedFolderInformation()
    {
        return $this->managedFolderInformation;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ManagedFolderInformationType
     * @return BaseFolderType
     */
    public function setManagedFolderInformation(ManagedFolderInformationType $value)
    {
        $this->managedFolderInformation = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return EffectiveRightsType
     */
    public function getEffectiveRights()
    {
        return $this->effectiveRights;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value EffectiveRightsType
     * @return BaseFolderType
     */
    public function setEffectiveRights(EffectiveRightsType $value)
    {
        $this->effectiveRights = $value;
        return $this;
    }
}
