<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing ArrayOfTransitionsType
 *
 *
 * XSD Type: ArrayOfTransitionsType
 */
class ArrayOfTransitionsType extends Type
{

    /**
     * @var string
     */
    protected $id = null;

    /**
     * @var \garethp\ews\API\Type\AbsoluteDateTransition[]
     */
    protected $absoluteDateTransition = null;

    /**
     * @var \garethp\ews\API\Type\RecurringDayTransition[]
     */
    protected $recurringDayTransition = null;

    /**
     * @var \garethp\ews\API\Type\RecurringDateTransition[]
     */
    protected $recurringDateTransition = null;

    /**
     * @var \garethp\ews\API\Type\Transition[]
     */
    protected $transition = null;

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return ArrayOfTransitionsType
     */
    public function setId($value)
    {
        $this->id = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value AbsoluteDateTransition
     * @return ArrayOfTransitionsType
     */
    public function addAbsoluteDateTransition(AbsoluteDateTransition $value)
    {
        if ($this->absoluteDateTransition === null) {
                        $this->absoluteDateTransition = array();
        }

        if (!is_array($this->absoluteDateTransition)) {
            $this->absoluteDateTransition = array($this->absoluteDateTransition);
        }

        $this->absoluteDateTransition[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return AbsoluteDateTransition[]
     */
    public function getAbsoluteDateTransition()
    {
        return $this->absoluteDateTransition;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value AbsoluteDateTransitionType[]|AbsoluteDateTransitionType
     * @return ArrayOfTransitionsType
     */
    public function setAbsoluteDateTransition(array|AbsoluteDateTransitionType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->absoluteDateTransition = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value RecurringDayTransition
     * @return ArrayOfTransitionsType
     */
    public function addRecurringDayTransition(RecurringDayTransition $value)
    {
        if ($this->recurringDayTransition === null) {
                        $this->recurringDayTransition = array();
        }

        if (!is_array($this->recurringDayTransition)) {
            $this->recurringDayTransition = array($this->recurringDayTransition);
        }

        $this->recurringDayTransition[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return RecurringDayTransition[]
     */
    public function getRecurringDayTransition()
    {
        return $this->recurringDayTransition;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value RecurringDayTransitionType[]|RecurringDayTransitionType
     * @return ArrayOfTransitionsType
     */
    public function setRecurringDayTransition(array|RecurringDayTransitionType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->recurringDayTransition = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value RecurringDateTransition
     * @return ArrayOfTransitionsType
     */
    public function addRecurringDateTransition(RecurringDateTransition $value)
    {
        if ($this->recurringDateTransition === null) {
                        $this->recurringDateTransition = array();
        }

        if (!is_array($this->recurringDateTransition)) {
            $this->recurringDateTransition = array($this->recurringDateTransition);
        }

        $this->recurringDateTransition[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return RecurringDateTransition[]
     */
    public function getRecurringDateTransition()
    {
        return $this->recurringDateTransition;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value RecurringDateTransitionType[]|RecurringDateTransitionType
     * @return ArrayOfTransitionsType
     */
    public function setRecurringDateTransition(array|RecurringDateTransitionType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->recurringDateTransition = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value Transition
     * @return ArrayOfTransitionsType
     */
    public function addTransition(Transition $value)
    {
        if ($this->transition === null) {
                        $this->transition = array();
        }

        if (!is_array($this->transition)) {
            $this->transition = array($this->transition);
        }

        $this->transition[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return Transition[]
     */
    public function getTransition()
    {
        return $this->transition;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value TransitionType[]|TransitionType
     * @return ArrayOfTransitionsType
     */
    public function setTransition(array|TransitionType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->transition = $value;
        return $this;
    }
}
