<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing ArrayOfResolutionType
 *
 *
 * XSD Type: ArrayOfResolutionType
 */
class ArrayOfResolutionType extends Type
{

    /**
     * @var integer
     */
    protected $indexedPagingOffset = null;

    /**
     * @var integer
     */
    protected $numeratorOffset = null;

    /**
     * @var integer
     */
    protected $absoluteDenominator = null;

    /**
     * @var boolean
     */
    protected $includesLastItemInRange = null;

    /**
     * @var integer
     */
    protected $totalItemsInView = null;

    /**
     * @var \garethp\ews\API\Type\ResolutionType[]
     */
    protected $resolution = null;

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getIndexedPagingOffset()
    {
        return $this->indexedPagingOffset;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return ArrayOfResolutionType
     */
    public function setIndexedPagingOffset($value)
    {
        $this->indexedPagingOffset = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getNumeratorOffset()
    {
        return $this->numeratorOffset;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return ArrayOfResolutionType
     */
    public function setNumeratorOffset($value)
    {
        $this->numeratorOffset = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getAbsoluteDenominator()
    {
        return $this->absoluteDenominator;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return ArrayOfResolutionType
     */
    public function setAbsoluteDenominator($value)
    {
        $this->absoluteDenominator = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isIncludesLastItemInRange()
    {
        return ((bool) $this->includesLastItemInRange);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getIncludesLastItemInRange()
    {
        return $this->includesLastItemInRange;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return ArrayOfResolutionType
     */
    public function setIncludesLastItemInRange($value)
    {
        $this->includesLastItemInRange = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return integer
     */
    public function getTotalItemsInView()
    {
        return $this->totalItemsInView;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value int
     * @return ArrayOfResolutionType
     */
    public function setTotalItemsInView($value)
    {
        $this->totalItemsInView = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ResolutionType
     * @return ArrayOfResolutionType
     */
    public function addResolution(ResolutionType $value)
    {
        if ($this->resolution === null) {
                        $this->resolution = array();
        }

        if (!is_array($this->resolution)) {
            $this->resolution = array($this->resolution);
        }

        $this->resolution[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return ResolutionType[]
     */
    public function getResolution()
    {
        return $this->resolution;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ResolutionType[]|ResolutionType
     * @return ArrayOfResolutionType
     */
    public function setResolution(array|ResolutionType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->resolution = $value;
        return $this;
    }
}
