<?php

namespace garethp\ews\API\Message;

use garethp\ews\API\Message;

/**
 * Class representing GetUserOofSettingsResponseType
 *
 *
 * XSD Type: GetUserOofSettingsResponse
 */
class GetUserOofSettingsResponseType extends Message
{

    /**
     * @var \garethp\ews\API\Message\ResponseMessageType
     */
    protected $responseMessage = null;

    /**
     * @var \garethp\ews\API\Type\OofSettings
     */
    protected $oofSettings = null;

    /**
     * @var string
     */
    protected $allowExternalOof = null;

    /**
     * @autogenerated This method is safe to replace
     * @return ResponseMessageType
     */
    public function getResponseMessage()
    {
        return $this->responseMessage;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value ResponseMessageType
     * @return GetUserOofSettingsResponseType
     */
    public function setResponseMessage(ResponseMessageType $value)
    {
        $this->responseMessage = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\OofSettings
     */
    public function getOofSettings()
    {
        return $this->oofSettings;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\UserOofSettingsType
     * @return GetUserOofSettingsResponseType
     */
    public function setOofSettings(\garethp\ews\API\Type\UserOofSettingsType $value)
    {
        $this->oofSettings = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string
     */
    public function getAllowExternalOof()
    {
        return $this->allowExternalOof;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return GetUserOofSettingsResponseType
     */
    public function setAllowExternalOof($value)
    {
        $this->allowExternalOof = $value;
        return $this;
    }
}
